/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.doGenerateFiles(state.getFiles(), state, errorHandler);
    }

    public static void doGenerateFiles(@NotNull Collection<KtFile> files2, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        MultiMap filesInPackages = new MultiMap();
        MultiMap filesInMultifileClasses = new MultiMap();
        for (KtFile ktFile : files2) {
            if (ktFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = state.getFileClassesProvider().getFileClassInfo(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue((Object)fileClassInfo.getFacadeClassFqName(), (Object)ktFile);
                continue;
            }
            filesInPackages.putValue((Object)ktFile.getPackageFqName(), (Object)ktFile);
        }
        HashSet<FqName> obsoleteMultifileClasses = new HashSet<FqName>(state.getObsoleteMultifileClasses());
        for (FqName multifileClassFqName : SetsKt.plus((Set)filesInMultifileClasses.keySet(), obsoleteMultifileClasses)) {
            KotlinCodegenFacade.doCheckCancelled(state);
            KotlinCodegenFacade.generateMultifileClass(state, multifileClassFqName, filesInMultifileClasses.get((Object)multifileClassFqName), errorHandler);
        }
        HashSet<FqName> hashSet = new HashSet<FqName>(state.getPackagesWithObsoleteParts());
        for (FqName packageFqName : SetsKt.plus(hashSet, (Iterable)filesInPackages.keySet())) {
            KotlinCodegenFacade.doCheckCancelled(state);
            KotlinCodegenFacade.generatePackage(state, packageFqName, filesInPackages.get((Object)packageFqName), errorHandler);
        }
        KotlinCodegenFacade.doCheckCancelled(state);
        state.getFactory().done();
    }

    private static void doCheckCancelled(GenerationState state) {
        if (state.getClassBuilderMode().generateBodies) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName packageFqName, @NotNull Collection<KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private static void generateMultifileClass(@NotNull GenerationState state, @NotNull FqName multifileClassFqName, @NotNull Collection<KtFile> files2, @NotNull CompilationErrorHandler handler2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (multifileClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multifileClassFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        MultifileClassCodegen codegen = state.getFactory().forMultifileClass(multifileClassFqName, files2);
        codegen.generate(handler2);
    }

    private KotlinCodegenFacade() {
    }
}

