/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public class SamType {
    private final KotlinType type;

    public static SamType create(@NotNull KotlinType originalType) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/codegen/SamType", "create"));
        }
        if (!SingleAbstractMethodUtils.isSamType(originalType)) {
            return null;
        }
        return new SamType(originalType);
    }

    private SamType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/SamType", "<init>"));
        }
        this.type = type2;
    }

    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = this.type;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getType"));
        }
        return kotlinType;
    }

    @NotNull
    public JavaClassDescriptor getJavaClassDescriptor() {
        ClassifierDescriptor classifier = this.type.getConstructor().getDeclarationDescriptor();
        assert (classifier instanceof JavaClassDescriptor) : "Sam interface not a Java class: " + classifier;
        JavaClassDescriptor javaClassDescriptor = (JavaClassDescriptor)classifier;
        if (javaClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getJavaClassDescriptor"));
        }
        return javaClassDescriptor;
    }

    @NotNull
    public KotlinType getKotlinFunctionType() {
        SimpleType simpleType2 = this.getJavaClassDescriptor().getDefaultFunctionTypeForSamInterface();
        if (simpleType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getKotlinFunctionType"));
        }
        return simpleType2;
    }

    @NotNull
    public SimpleFunctionDescriptor getAbstractMethod() {
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(this.type).get(0);
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/SamType", "getAbstractMethod"));
        }
        return simpleFunctionDescriptor;
    }

    public boolean equals(Object o) {
        return o instanceof SamType && this.type.equals(((SamType)o).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "SamType(" + this.type + ")";
    }
}

