/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameGenerator {
    private final String generatorClass;
    private int nextLambdaIndex = 1;
    private int nextWhenIndex = 1;
    private final Map<String, NameGenerator> subGenerators = new HashMap<String, NameGenerator>();

    public NameGenerator(String generatorClass) {
        this.generatorClass = generatorClass;
    }

    public String getGeneratorClass() {
        return this.generatorClass;
    }

    private String genLambdaClassName() {
        return this.generatorClass + "$" + this.nextLambdaIndex++;
    }

    private String genWhenClassName(@NotNull String original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/codegen/inline/NameGenerator", "genWhenClassName"));
        }
        return this.generatorClass + "$" + this.nextWhenIndex++ + "$wm$" + original;
    }

    public NameGenerator subGenerator(String inliningMethod) {
        return this.subGenerators.computeIfAbsent(inliningMethod, method -> new NameGenerator(this.generatorClass + "$" + method));
    }

    @NotNull
    public NameGenerator subGenerator(boolean lambdaNoWhen, @Nullable String nameSuffix) {
        String generatorClass;
        String string = generatorClass = lambdaNoWhen ? this.genLambdaClassName() : this.genWhenClassName(nameSuffix);
        assert (!this.subGenerators.containsKey(generatorClass)) : "Name generator for regenerated class should be unique: " + generatorClass;
        NameGenerator generator = new NameGenerator(generatorClass);
        this.subGenerators.put(generatorClass, generator);
        NameGenerator nameGenerator2 = generator;
        if (nameGenerator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/NameGenerator", "subGenerator"));
        }
        return nameGenerator2;
    }
}

