/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.KtFunctionPsiElementCellRenderer;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public class GotoSuperActionHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        PsiElement element3 = file2.findElementAt(editor.getCaretModel().getOffset());
        if (element3 == null) {
            return;
        }
        KtDeclaration declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])new Class[]{KtNamedFunction.class, KtClass.class, KtProperty.class, KtObjectDeclaration.class});
        if (declaration2 == null) {
            return;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(declaration2, BodyResolveMode.PARTIAL);
        List<PsiElement> superDeclarations = GotoSuperActionHandler.findSuperDeclarations(descriptor2);
        if (superDeclarations == null || superDeclarations.isEmpty()) {
            return;
        }
        if (superDeclarations.size() == 1) {
            Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)superDeclarations.get(0));
            if (navigatable != null && navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else {
            String message2 = GotoSuperActionHandler.getTitle(descriptor2);
            PsiElement[] superDeclarationsArray = PsiUtilCore.toPsiElementArray(superDeclarations);
            JBPopup popup2 = descriptor2 instanceof ClassDescriptor ? NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (String)message2) : NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (PsiElementListCellRenderer)new KtFunctionPsiElementCellRenderer(), (String)message2);
            popup2.showInBestPositionFor(editor);
        }
    }

    @Nullable
    private static String getTitle(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            return KotlinBundle.message("goto.super.class.chooser.title", new Object[0]);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return KotlinBundle.message("goto.super.property.chooser.title", new Object[0]);
        }
        if (descriptor2 instanceof SimpleFunctionDescriptor) {
            return KotlinBundle.message("goto.super.function.chooser.title", new Object[0]);
        }
        return null;
    }

    @Nullable
    private static List<PsiElement> findSuperDeclarations(DeclarationDescriptor descriptor2) {
        List superDescriptors;
        if (descriptor2 instanceof ClassDescriptor) {
            Collection<KotlinType> supertypes2 = ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes();
            List superclasses = ContainerUtil.mapNotNull(supertypes2, (Function)new Function<KotlinType, ClassDescriptor>(){

                public ClassDescriptor fun(KotlinType type2) {
                    ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
                    if (descriptor2 instanceof ClassDescriptor) {
                        return (ClassDescriptor)descriptor2;
                    }
                    return null;
                }
            });
            ContainerUtil.removeDuplicates((Collection)superclasses);
            superDescriptors = superclasses;
        } else if (descriptor2 instanceof CallableMemberDescriptor) {
            superDescriptors = DescriptorUtilsKt.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor2);
        } else {
            return null;
        }
        return ContainerUtil.mapNotNull(superDescriptors, (Function)new Function<DeclarationDescriptor, PsiElement>(){

            public PsiElement fun(DeclarationDescriptor descriptor2) {
                if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
                    return null;
                }
                return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

