/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.LanguageSettingsProvider;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.config.TargetPlatformVersion;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.utils.Jsr305State;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/IDELanguageSettingsProvider;", "Lorg/jetbrains/kotlin/analyzer/LanguageSettingsProvider;", "()V", "getExtraAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getTargetPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformVersion;", "idea-analysis"})
public final class IDELanguageSettingsProvider
implements LanguageSettingsProvider {
    public static final IDELanguageSettingsProvider INSTANCE;

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings(@NotNull ModuleInfo moduleInfo, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ModuleInfo moduleInfo2 = moduleInfo;
        return moduleInfo2 instanceof ModuleSourceInfo ? PlatformKt.getLanguageVersionSettings(((ModuleSourceInfo)moduleInfo).getModule()) : (moduleInfo2 instanceof LibraryInfo ? PlatformKt.getLanguageVersionSettings$default(project, null, this.getExtraAnalysisFlags(project), 1, null) : PlatformKt.getLanguageVersionSettings$default(project, null, null, 3, null));
    }

    private final Map<AnalysisFlag<?>, Object> getExtraAnalysisFlags(Project project) {
        Map map2 = new LinkedHashMap();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            K2JVMCompilerArguments compilerArguments;
            KotlinFacetSettings settings2;
            Module module = moduleArray[i];
            KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
            Module module2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (kotlinFacetSettingsProvider.getSettings(module2) == null) {
                continue;
            }
            CommonCompilerArguments commonCompilerArguments = settings2.getMergedCompilerArguments();
            if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                commonCompilerArguments = null;
            }
            if ((K2JVMCompilerArguments)commonCompilerArguments == null) {
                continue;
            }
            Jsr305State jsr305state = Jsr305State.Companion.findByDescription(compilerArguments.getJsr305());
            if (jsr305state == null || !(Intrinsics.areEqual((Object)((Object)jsr305state), (Object)((Object)Jsr305State.DEFAULT)) ^ true)) continue;
            map2.put(AnalysisFlag.Flags.getJsr305(), jsr305state);
            break;
        }
        return map2;
    }

    @Override
    @NotNull
    public TargetPlatformVersion getTargetPlatform(@NotNull ModuleInfo moduleInfo) {
        TargetPlatformKind<?> targetPlatformKind;
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        ModuleInfo moduleInfo2 = moduleInfo;
        if (!(moduleInfo2 instanceof ModuleSourceInfo)) {
            moduleInfo2 = null;
        }
        if ((targetPlatformKind = (ModuleSourceInfo)moduleInfo2) == null || (targetPlatformKind = targetPlatformKind.getModule()) == null || (targetPlatformKind = PlatformKt.getTargetPlatform((Module)targetPlatformKind)) == null || (targetPlatformKind = targetPlatformKind.getVersion()) == null) {
            targetPlatformKind = TargetPlatformVersion.NoVersion.INSTANCE;
        }
        return targetPlatformKind;
    }

    private IDELanguageSettingsProvider() {
        INSTANCE = this;
    }

    static {
        new IDELanguageSettingsProvider();
    }
}

