/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 Z2\u00020\u0001:\u0001ZB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J*\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\b\b\u0002\u0010!\u001a\u00020\u00142\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0016\u0010%\u001a\u0004\u0018\u00010&*\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010)*\u00020&2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u001e\u0010*\u001a\u00020+*\u00020&2\u0006\u0010,\u001a\u00020\u00142\b\b\u0002\u0010-\u001a\u00020\u0011H\u0002J\u001c\u0010.\u001a\u00020/*\u00020&2\u0006\u0010,\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0007H\u0002J\u001e\u00101\u001a\u00020/*\u00020&2\u0006\u0010,\u001a\u00020\u00142\b\b\u0002\u0010-\u001a\u00020\u0011H\u0002J\u0014\u00102\u001a\u000203*\u00020\u00032\u0006\u00104\u001a\u00020\u0014H\u0002J\u0016\u00105\u001a\u00020\u000b*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\u00020\u000b*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0002J\u0016\u00109\u001a\u00020\u000b*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010)*\u00020&H\u0002J\u0016\u0010;\u001a\u0004\u0018\u00010)*\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010<\u001a\u00020\u0007*\u00020\u00072\u0006\u0010=\u001a\u00020\u0007H\u0002J<\u0010>\u001a\u0002H?\"\n\b\u0000\u0010?\u0018\u0001*\u00020\u0007*\u00020&2\u0006\u0010,\u001a\u00020\u00142\u0014\b\u0004\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070AH\u0082\b\u00a2\u0006\u0002\u0010BJ \u0010C\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010=\u001a\u00020\u00072\b\b\u0002\u0010-\u001a\u00020\u0011H\u0002J \u0010D\u001a\u0004\u0018\u00010&*\u00020\u00032\u0006\u0010'\u001a\u00020\u00142\b\b\u0002\u0010-\u001a\u00020\u0011H\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J&\u0010E\u001a\u0004\u0018\u00010\u0007*\u00020\u00032\u0006\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0014\u0010H\u001a\u00020\u0011*\u00020\u00032\u0006\u0010I\u001a\u00020\u0014H\u0002J\f\u0010J\u001a\u00020\u0011*\u00020\u0003H\u0002J\u000e\u0010K\u001a\u0004\u0018\u00010&*\u00020\u0003H\u0002J\u0016\u0010L\u001a\u0004\u0018\u00010)*\u00020&2\u0006\u0010I\u001a\u00020\u0014H\u0002J\u0014\u0010M\u001a\u00020N*\u00020\u00062\u0006\u0010,\u001a\u00020\u0014H\u0002J\u0016\u0010O\u001a\u0004\u0018\u00010&*\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u000e\u0010P\u001a\u0004\u0018\u00010)*\u00020&H\u0002J\u0016\u0010Q\u001a\u0004\u0018\u00010)*\u00020&2\u0006\u0010I\u001a\u00020\u0014H\u0002J\u0016\u0010R\u001a\u0004\u0018\u00010N*\u00020\u00032\u0006\u0010S\u001a\u00020\u0014H\u0002J\u000e\u0010T\u001a\u0004\u0018\u00010&*\u00020\u0003H\u0002J\u000e\u0010U\u001a\u0004\u0018\u00010&*\u00020)H\u0002J\u000e\u0010U\u001a\u0004\u0018\u00010&*\u00020NH\u0002J\u000e\u0010V\u001a\u0004\u0018\u00010&*\u00020\u0003H\u0002J\u000e\u0010W\u001a\u0004\u0018\u00010&*\u00020&H\u0002J\u000e\u0010W\u001a\u0004\u0018\u00010&*\u00020\u0003H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\u0014*\u00020\u0003H\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010&*\u00020&H\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010&*\u00020\u0003H\u0002J\f\u0010Y\u001a\u00020\u0011*\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildScriptManipulator;", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "kotlinScript", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/psi/PsiElement;", "getPsiFactory", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "addKotlinLibraryToModuleBuildScript", "", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "isAndroidModule", "", "changeApiVersion", "version", "", "forTests", "changeCoroutineConfiguration", "coroutineOption", "changeLanguageVersion", "configureModuleBuildScript", "kotlinPluginName", "stdlibArtifactName", "jvmTarget", "configureProjectBuildScript", "getCompileDependencySnippet", "groupId", "artifactId", "compileScope", "getKotlinModuleDependencySnippet", "getKotlinStdlibVersion", "isConfigured", "addBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "name", "addCompileStdlibIfMissing", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "addDeclarationIfMissing", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "text", "first", "addExpressionAfterIfMissing", "Lorg/jetbrains/kotlin/psi/KtExpression;", "after", "addExpressionIfMissing", "addImportIfMissing", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "path", "addNewLineAfter", "lineBreaks", "", "addNewLineBefore", "addNewLinesIfNeeded", "addPluginToClassPathIfMissing", "addRepositoryIfMissing", "addSibling", "element", "addStatementIfMissing", "T", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/intellij/psi/PsiElement;", "addToScriptBlock", "addTopLevelBlock", "changeKotlinTaskParameter", "parameterName", "parameterValue", "containsApplyKotlinPlugin", "pluginName", "containsCompileStdLib", "createApplyBlock", "createPluginIfMissing", "createScriptInitializer", "Lorg/jetbrains/kotlin/psi/KtScriptInitializer;", "findBlock", "findCompileStdLib", "findPlugin", "findScriptInitializer", "startsWith", "getApplyBlock", "getBlock", "getBuildScriptBlock", "getDependenciesBlock", "getRepositoriesBlock", "isKotlinStdLib", "Companion", "idea-gradle"})
public final class KotlinBuildScriptManipulator
implements GradleBuildScriptManipulator {
    private final KtFile kotlinScript;
    private static final String STDLIB_ARTIFACT_PREFIX = "org.jetbrains.kotlin:kotlin-stdlib";
    private static final String GSK_KOTLIN_VERSION_PROPERTY_NAME = "kotlin_version";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isConfigured(@NotNull String kotlinPluginName) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginName, (String)"kotlinPluginName");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this, kotlinPluginName){
            final /* synthetic */ KotlinBuildScriptManipulator this$0;
            final /* synthetic */ String $kotlinPluginName;

            public final boolean invoke() {
                return KotlinBuildScriptManipulator.access$containsApplyKotlinPlugin(this.this$0, KotlinBuildScriptManipulator.access$getKotlinScript$p(this.this$0), this.$kotlinPluginName) && KotlinBuildScriptManipulator.access$containsCompileStdLib(this.this$0, KotlinBuildScriptManipulator.access$getKotlinScript$p(this.this$0));
            }
            {
                this.this$0 = kotlinBuildScriptManipulator;
                this.$kotlinPluginName = string;
                super(0);
            }
        });
    }

    @Override
    public boolean configureProjectBuildScript(@NotNull String version) {
        String originalText;
        block2: {
            KtDeclaration ktDeclaration;
            KtBlockExpression ktBlockExpression;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            originalText = this.kotlinScript.getText();
            KtBlockExpression ktBlockExpression2 = this.getBuildScriptBlock(this.kotlinScript);
            if (ktBlockExpression2 == null) break block2;
            KtBlockExpression $receiver = ktBlockExpression = ktBlockExpression2;
            KtDeclaration it = ktDeclaration = this.addDeclarationIfMissing($receiver, "var " + KotlinBuildScriptManipulator.Companion.getGSK_KOTLIN_VERSION_PROPERTY_NAME() + ": String by extra", true);
            this.addExpressionAfterIfMissing($receiver, "" + KotlinBuildScriptManipulator.Companion.getGSK_KOTLIN_VERSION_PROPERTY_NAME() + " = \"" + version + '\"', it);
            KtBlockExpression ktBlockExpression3 = this.getRepositoriesBlock($receiver);
            if (ktBlockExpression3 != null) {
                this.addRepositoryIfMissing(ktBlockExpression3, version);
            }
            KtBlockExpression ktBlockExpression4 = this.getDependenciesBlock($receiver);
            if (ktBlockExpression4 != null) {
                this.addPluginToClassPathIfMissing(ktBlockExpression4);
            }
        }
        return Intrinsics.areEqual((Object)originalText, (Object)this.kotlinScript.getText()) ^ true;
    }

    @Override
    public boolean configureModuleBuildScript(@NotNull String kotlinPluginName, @NotNull String stdlibArtifactName, @NotNull String version, @Nullable String jvmTarget) {
        String originalText;
        block4: {
            String string;
            KtFile ktFile;
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginName, (String)"kotlinPluginName");
            Intrinsics.checkParameterIsNotNull((Object)stdlibArtifactName, (String)"stdlibArtifactName");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            originalText = this.kotlinScript.getText();
            KtFile $receiver = ktFile = this.kotlinScript;
            KtStatementExpression ktStatementExpression = $receiver.getScript();
            if (ktStatementExpression != null && (ktStatementExpression = ktStatementExpression.getBlockExpression()) != null) {
                this.addDeclarationIfMissing((KtBlockExpression)ktStatementExpression, "val " + KotlinBuildScriptManipulator.Companion.getGSK_KOTLIN_VERSION_PROPERTY_NAME() + ": String by extra", true);
            }
            KtBlockExpression ktBlockExpression = this.getApplyBlock($receiver);
            if (ktBlockExpression != null) {
                this.createPluginIfMissing(ktBlockExpression, kotlinPluginName);
            }
            KtBlockExpression ktBlockExpression2 = this.getDependenciesBlock($receiver);
            if (ktBlockExpression2 != null) {
                this.addCompileStdlibIfMissing(ktBlockExpression2, stdlibArtifactName);
            }
            KtBlockExpression ktBlockExpression3 = this.getRepositoriesBlock($receiver);
            if (ktBlockExpression3 != null) {
                this.addRepositoryIfMissing(ktBlockExpression3, version);
            }
            String string2 = jvmTarget;
            if (string2 == null) break block4;
            String it = string = string2;
            this.changeKotlinTaskParameter($receiver, "jvmTarget", it, false);
            this.changeKotlinTaskParameter($receiver, "jvmTarget", it, true);
        }
        return Intrinsics.areEqual((Object)originalText, (Object)this.kotlinScript.getText()) ^ true;
    }

    @Override
    @Nullable
    public PsiElement changeCoroutineConfiguration(@NotNull String coroutineOption) {
        Intrinsics.checkParameterIsNotNull((Object)coroutineOption, (String)"coroutineOption");
        return this.changeCoroutineConfiguration(this.kotlinScript, coroutineOption);
    }

    @Override
    @Nullable
    public PsiElement changeLanguageVersion(@NotNull String version, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.changeKotlinTaskParameter(this.kotlinScript, "languageVersion", version, forTests);
    }

    @Override
    @Nullable
    public PsiElement changeApiVersion(@NotNull String version, boolean forTests) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.changeKotlinTaskParameter(this.kotlinScript, "apiVersion", version, forTests);
    }

    @Override
    public void addKotlinLibraryToModuleBuildScript(@NotNull DependencyScope scope2, @NotNull ExternalLibraryDescriptor libraryDescriptor, boolean isAndroidModule) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)libraryDescriptor, (String)"libraryDescriptor");
            Object object = libraryDescriptor.getMaxVersion();
            String it = object;
            String kotlinLibraryVersion = Intrinsics.areEqual((Object)it, (Object)KotlinBuildScriptManipulator.Companion.getGSK_KOTLIN_VERSION_PROPERTY_NAME()) ^ true ? object : null;
            KtBlockExpression ktBlockExpression = this.getDependenciesBlock(this.kotlinScript);
            if (ktBlockExpression == null) break block0;
            Object $receiver = object = ktBlockExpression;
            String string = libraryDescriptor.getLibraryGroupId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libraryDescriptor.libraryGroupId");
            String string2 = libraryDescriptor.getLibraryArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"libraryDescriptor.libraryArtifactId");
            KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, (KtBlockExpression)$receiver, this.getCompileDependencySnippet(string, string2, ConfigureKotlinInProjectUtilsKt.toGradleCompileScope(scope2, isAndroidModule), kotlinLibraryVersion), false, 2, null);
        }
    }

    @Override
    @Nullable
    public String getKotlinStdlibVersion() {
        return this.getKotlinStdlibVersion(this.kotlinScript);
    }

    private final KtCallExpression addCompileStdlibIfMissing(@NotNull KtBlockExpression $receiver, String stdlibArtifactName) {
        KtCallExpression ktCallExpression = this.findCompileStdLib($receiver);
        if (ktCallExpression == null) {
            KtExpression ktExpression = KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, $receiver, KotlinBuildScriptManipulator.getCompileDependencySnippet$default(this, ConfigureKotlinInProjectUtilsKt.getKOTLIN_GROUP_ID(), stdlibArtifactName, null, null, 12, null), false, 2, null);
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            ktCallExpression = (KtCallExpression)ktExpression;
        }
        return ktCallExpression;
    }

    private final boolean containsCompileStdLib(@NotNull KtFile $receiver) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "dependencies");
        return (ktExpressionImpl != null && (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) != null ? this.findCompileStdLib((KtBlockExpression)ktExpressionImpl) : null) != null;
    }

    private final boolean containsApplyKotlinPlugin(@NotNull KtFile $receiver, String pluginName) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "apply");
        return (ktExpressionImpl != null && (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) != null ? this.findPlugin((KtBlockExpression)ktExpressionImpl, pluginName) : null) != null;
    }

    /*
     * Unable to fully structure code
     */
    private final KtCallExpression findPlugin(@NotNull KtBlockExpression $receiver, String pluginName) {
        block5: {
            block4: {
                block3: {
                    v0 = (KtCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$receiver), KtCallExpression.class);
                    if (v0 == null) break block4;
                    var4_4 = var3_3 = (Object[])v0;
                    for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
                        var6_6 = var4_4[var5_5];
                        it = (KtCallExpression)var6_6;
                        v1 = it.getCalleeExpression();
                        if (!Intrinsics.areEqual((Object)(v1 != null ? v1.getText() : null), (Object)"plugin")) ** GOTO lbl-1000
                        v2 = (KtValueArgument)CollectionsKt.firstOrNull(it.getValueArguments());
                        if (Intrinsics.areEqual((Object)(v2 != null ? v2.getText() : null), (Object)('\"' + pluginName + '\"'))) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v4 = var6_6;
                        break block3;
                    }
                    v4 = null;
                }
                v5 = (KtCallExpression)v4;
                break block5;
            }
            v5 = null;
        }
        return v5;
    }

    private final KtScriptInitializer findScriptInitializer(@NotNull KtFile $receiver, String startsWith) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)$receiver), KtScriptInitializer.class);
            for (Object t : iterable2) {
                KtScriptInitializer it = (KtScriptInitializer)t;
                if (!StringsKt.startsWith$default((String)it.getText(), (String)startsWith, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private final KtBlockExpression findBlock(@NotNull KtBlockExpression $receiver, String name) {
        block4: {
            $receiver$iv = (PsiElement)$receiver;
            v0 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, KtCallExpression.class);
            if (v0 == null) {
                elements$iv$iv = new KtCallExpression[0];
                v0 = (PsiElement[])elements$iv$iv;
            }
            var4_4 = var3_3 = (Object[])v0;
            for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
                var6_6 = var4_4[var5_5];
                it = (KtCallExpression)var6_6;
                v1 = it.getCalleeExpression();
                if (!Intrinsics.areEqual((Object)(v1 != null ? v1.getText() : null), (Object)name)) ** GOTO lbl-1000
                v2 = (KtValueArgument)CollectionsKt.singleOrNull(it.getValueArguments());
                if ((v2 != null ? v2.getArgumentExpression() : null) instanceof KtLambdaExpression) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                v4 = var6_6;
                break block4;
            }
            v4 = null;
        }
        v5 = (KtCallExpression)v4;
        return v5 != null ? this.getBlock(v5) : null;
    }

    private final KtBlockExpression getBlock(@NotNull KtScriptInitializer $receiver) {
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.findChildOfType((PsiElement)$receiver, KtCallExpression.class);
        return ktCallExpression != null ? this.getBlock(ktCallExpression) : null;
    }

    private final KtBlockExpression getBlock(@NotNull KtCallExpression $receiver) {
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull($receiver.getValueArguments());
        KtExpression ktExpression = ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null;
        if (!(ktExpression instanceof KtLambdaExpression)) {
            ktExpression = null;
        }
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)ktExpression;
        return ktLambdaExpression != null ? ktLambdaExpression.getBodyExpression() : null;
    }

    private final String getCompileDependencySnippet(String groupId, String artifactId, String compileScope, String version) {
        return Intrinsics.areEqual((Object)groupId, (Object)ConfigureKotlinInProjectUtilsKt.getKOTLIN_GROUP_ID()) ? "" + compileScope + '(' + this.getKotlinModuleDependencySnippet(artifactId, version) + ')' : "" + compileScope + "(\"" + groupId + ':' + artifactId + ':' + version + "\")";
    }

    static /* bridge */ /* synthetic */ String getCompileDependencySnippet$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "compile";
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        return kotlinBuildScriptManipulator.getCompileDependencySnippet(string, string2, string3, string4);
    }

    private final String getKotlinModuleDependencySnippet(String artifactId, String version) {
        String string;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                stringBuilder = new StringBuilder().append("kotlinModule(\"").append(StringsKt.removePrefix((String)artifactId, (CharSequence)"kotlin-")).append("\", ");
                string = version;
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder2 = stringBuilder;
                String it = string2;
                String string3 = '\"' + it + '\"';
                stringBuilder = stringBuilder2;
                string = string3;
                if (string != null) break block3;
            }
            string = KotlinBuildScriptManipulator.Companion.getGSK_KOTLIN_VERSION_PROPERTY_NAME();
        }
        return stringBuilder.append(string).append(')').toString();
    }

    static /* bridge */ /* synthetic */ String getKotlinModuleDependencySnippet$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return kotlinBuildScriptManipulator.getKotlinModuleDependencySnippet(string, string2);
    }

    private final String getKotlinStdlibVersion(@NotNull KtFile $receiver) {
        String string;
        KtExpressionImpl ktExpressionImpl;
        KtExpressionImpl it;
        Object object;
        KtExpression expression2;
        KtExpression ktExpression;
        KtExpressionImpl ktExpressionImpl2 = this.findScriptInitializer($receiver, "dependencies");
        return ktExpressionImpl2 != null && (ktExpressionImpl2 = this.getBlock((KtScriptInitializer)ktExpressionImpl2)) != null ? ((ktExpression = (expression2 = (object = this.findCompileStdLib((KtBlockExpression)(it = (ktExpressionImpl = ktExpressionImpl2)))) != null && (object = ((KtCallExpression)object).getValueArguments()) != null && (object = (KtValueArgument)CollectionsKt.firstOrNull((List)object)) != null ? ((KtValueArgument)object).getArgumentExpression() : null)) instanceof KtCallExpression ? StringsKt.trim((String)((KtCallExpression)expression2).getValueArguments().get(1).getText(), (char[])new char[]{'\"'}) : (ktExpression instanceof KtStringTemplateExpression ? ((string = ((KtStringTemplateExpression)expression2).getText()) != null && (string = StringsKt.trim((String)string, (char[])new char[]{'\"'})) != null && (string = StringsKt.substringAfterLast$default((String)string, (String)":", null, (int)2, null)) != null ? StringsKt.removePrefix((String)string, (CharSequence)"$") : null) : null)) : null;
    }

    private final KtCallExpression findCompileStdLib(@NotNull KtBlockExpression $receiver) {
        KtCallExpression ktCallExpression;
        KtCallExpression[] ktCallExpressionArray = (KtCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)$receiver), KtCallExpression.class);
        if (ktCallExpressionArray != null) {
            Object object;
            block3: {
                Object[] objectArray;
                Object[] objectArray2 = objectArray = (Object[])ktCallExpressionArray;
                for (int i = 0; i < objectArray2.length; ++i) {
                    KtElement ktElement;
                    Object object2 = objectArray2[i];
                    KtCallExpression it = (KtCallExpression)object2;
                    KtExpression ktExpression = it.getCalleeExpression();
                    if (!(Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"compile") && ((ktElement = (KtValueArgument)CollectionsKt.firstOrNull(it.getValueArguments())) != null && (ktElement = ktElement.getArgumentExpression()) != null ? this.isKotlinStdLib((KtExpression)ktElement) : false))) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        } else {
            ktCallExpression = null;
        }
        return ktCallExpression;
    }

    private final boolean isKotlinStdLib(@NotNull KtExpression $receiver) {
        boolean bl;
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtCallExpression) {
            Object object;
            KtExpression ktExpression2 = ((KtCallExpression)$receiver).getCalleeExpression();
            bl = Intrinsics.areEqual((Object)(ktExpression2 != null ? ktExpression2.getText() : null), (Object)"kotlinModule") && ((object = (KtValueArgument)CollectionsKt.firstOrNull(((KtCallExpression)$receiver).getValueArguments())) != null && (object = ((KtValueArgument)object).getArgumentExpression()) != null && (object = object.getText()) != null ? StringsKt.startsWith$default((String)object, (String)"\"stdlib", (boolean)false, (int)2, null) : false);
        } else {
            bl = ktExpression instanceof KtStringTemplateExpression ? StringsKt.startsWith$default((String)((KtStringTemplateExpression)$receiver).getText(), (String)('\"' + KotlinBuildScriptManipulator.Companion.getSTDLIB_ARTIFACT_PREFIX()), (boolean)false, (int)2, null) : false;
        }
        return bl;
    }

    private final KtBlockExpression getRepositoriesBlock(@NotNull KtFile $receiver) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "repositories");
        if (ktExpressionImpl == null || (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) == null) {
            ktExpressionImpl = KotlinBuildScriptManipulator.addTopLevelBlock$default(this, $receiver, "repositories", false, 2, null);
        }
        return ktExpressionImpl;
    }

    private final KtBlockExpression getDependenciesBlock(@NotNull KtFile $receiver) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "dependencies");
        if (ktExpressionImpl == null || (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) == null) {
            ktExpressionImpl = KotlinBuildScriptManipulator.addTopLevelBlock$default(this, $receiver, "dependencies", false, 2, null);
        }
        return ktExpressionImpl;
    }

    private final KtBlockExpression createApplyBlock(@NotNull KtFile $receiver) {
        KtScriptInitializer ktScriptInitializer;
        KtScriptInitializer addedElement;
        KtScriptInitializer apply2 = this.createScriptInitializer(this.getPsiFactory((PsiElement)$receiver), "apply {\n}");
        KtScriptInitializer plugins = this.findScriptInitializer($receiver, "plugins");
        KtScriptInitializer ktScriptInitializer2 = plugins;
        if (ktScriptInitializer2 == null || (ktScriptInitializer2 = this.addSibling(ktScriptInitializer2, apply2)) == null) {
            ktScriptInitializer2 = KotlinBuildScriptManipulator.addToScriptBlock$default(this, $receiver, apply2, false, 2, null);
        }
        KtScriptInitializer ktScriptInitializer3 = addedElement = ktScriptInitializer2;
        if (ktScriptInitializer3 != null) {
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this, ktScriptInitializer3, 0, 1, null);
        }
        if (!((ktScriptInitializer = addedElement) instanceof KtScriptInitializer)) {
            ktScriptInitializer = null;
        }
        return ktScriptInitializer != null ? this.getBlock(ktScriptInitializer) : null;
    }

    private final KtBlockExpression getApplyBlock(@NotNull KtFile $receiver) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "apply");
        if (ktExpressionImpl == null || (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) == null) {
            ktExpressionImpl = this.createApplyBlock($receiver);
        }
        return ktExpressionImpl;
    }

    private final KtCallExpression createPluginIfMissing(@NotNull KtBlockExpression $receiver, String pluginName) {
        KtCallExpression ktCallExpression = this.findPlugin($receiver, pluginName);
        if (ktCallExpression == null) {
            KtExpression ktExpression = KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, $receiver, "plugin(\"" + pluginName + "\")", false, 2, null);
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            ktCallExpression = (KtCallExpression)ktExpression;
        }
        return ktCallExpression;
    }

    private final PsiElement changeCoroutineConfiguration(@NotNull KtFile $receiver, String coroutineOption) {
        Object object;
        Object v3;
        Iterable iterable;
        KtExpressionImpl kotlinBlock;
        String snippet;
        block6: {
            String string = coroutineOption;
            StringBuilder stringBuilder = new StringBuilder().append("experimental.coroutines = Coroutines.");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            String string4 = string3;
            snippet = stringBuilder.append(string4).toString();
            KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "kotlin");
            if (ktExpressionImpl == null || (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) == null) {
                ktExpressionImpl = KotlinBuildScriptManipulator.addTopLevelBlock$default(this, $receiver, "kotlin", false, 2, null);
            }
            if (ktExpressionImpl == null) {
                return null;
            }
            kotlinBlock = ktExpressionImpl;
            this.addImportIfMissing($receiver, "org.jetbrains.kotlin.gradle.dsl.Coroutines");
            Iterable iterable2 = iterable = (Iterable)((KtBlockExpression)kotlinBlock).getStatements();
            for (Object t : iterable2) {
                KtExpression it = (KtExpression)t;
                if (!StringsKt.startsWith$default((String)it.getText(), (String)"experimental.coroutines", (boolean)false, (int)2, null)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        KtExpression statement2 = v3;
        if (statement2 != null) {
            object = statement2.replace((PsiElement)this.getPsiFactory((PsiElement)$receiver).createExpression(snippet));
        } else {
            Iterable $receiver2 = iterable = kotlinBlock.add((PsiElement)this.getPsiFactory((PsiElement)$receiver).createExpression(snippet));
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this, (PsiElement)$receiver2, 0, 1, null);
            object = iterable;
        }
        return object;
    }

    private final PsiElement changeKotlinTaskParameter(@NotNull KtFile $receiver, String parameterName, String parameterValue, boolean forTests) {
        PsiElement psiElement2;
        KtBlockExpression optionsBlock;
        String snippet = "" + parameterName + " = \"" + parameterValue + '\"';
        String taskName = forTests ? "compileTestKotlin" : "compileKotlin";
        KtScriptInitializer ktScriptInitializer = this.findScriptInitializer($receiver, "" + taskName + ".kotlinOptions");
        KtBlockExpression ktBlockExpression = optionsBlock = ktScriptInitializer != null ? this.getBlock(ktScriptInitializer) : null;
        if (optionsBlock != null) {
            Object v4;
            block5: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)optionsBlock.getStatements();
                for (Object t : iterable2) {
                    KtExpression ktExpression;
                    KtExpression it = (KtExpression)t;
                    KtExpression ktExpression2 = it;
                    if (!(ktExpression2 instanceof KtBinaryExpression)) {
                        ktExpression2 = null;
                    }
                    if (!Intrinsics.areEqual((Object)((ktExpression = (KtBinaryExpression)ktExpression2) != null && (ktExpression = ktExpression.getLeft()) != null ? ktExpression.getText() : null), (Object)parameterName)) continue;
                    v4 = t;
                    break block5;
                }
                v4 = null;
            }
            KtExpression assignment = v4;
            psiElement2 = assignment != null ? assignment.replace((PsiElement)this.getPsiFactory((PsiElement)$receiver).createExpression(snippet)) : (PsiElement)KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, optionsBlock, snippet, false, 2, null);
        } else {
            this.addImportIfMissing($receiver, "org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
            KtStatementExpression ktStatementExpression = $receiver.getScript();
            if (ktStatementExpression != null && (ktStatementExpression = ktStatementExpression.getBlockExpression()) != null) {
                KotlinBuildScriptManipulator.addDeclarationIfMissing$default(this, (KtBlockExpression)ktStatementExpression, "val " + taskName + ": KotlinCompile by tasks", false, 2, null);
            }
            KtBlockExpression ktBlockExpression2 = KotlinBuildScriptManipulator.addTopLevelBlock$default(this, $receiver, "" + taskName + ".kotlinOptions", false, 2, null);
            psiElement2 = (PsiElement)(ktBlockExpression2 != null ? KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, ktBlockExpression2, snippet, false, 2, null) : null);
        }
        return psiElement2;
    }

    private final KtBlockExpression getBuildScriptBlock(@NotNull KtFile $receiver) {
        KtExpressionImpl ktExpressionImpl = this.findScriptInitializer($receiver, "buildscript");
        if (ktExpressionImpl == null || (ktExpressionImpl = this.getBlock((KtScriptInitializer)ktExpressionImpl)) == null) {
            ktExpressionImpl = this.addTopLevelBlock($receiver, "buildscript", true);
        }
        return ktExpressionImpl;
    }

    private final KtBlockExpression getRepositoriesBlock(@NotNull KtBlockExpression $receiver) {
        KtBlockExpression ktBlockExpression = this.findBlock($receiver, "repositories");
        if (ktBlockExpression == null) {
            ktBlockExpression = this.addBlock($receiver, "repositories");
        }
        return ktBlockExpression;
    }

    private final KtBlockExpression getDependenciesBlock(@NotNull KtBlockExpression $receiver) {
        KtBlockExpression ktBlockExpression = this.findBlock($receiver, "dependencies");
        if (ktBlockExpression == null) {
            ktBlockExpression = this.addBlock($receiver, "dependencies");
        }
        return ktBlockExpression;
    }

    private final KtCallExpression addRepositoryIfMissing(@NotNull KtBlockExpression $receiver, String version) {
        String string;
        RepositoryDescription repository = ConfigureKotlinInProjectUtilsKt.getRepositoryForVersion(version);
        if (repository != null) {
            string = ConfigureKotlinInProjectUtilsKt.toKotlinRepositorySnippet(repository);
        } else {
            String string2 = $receiver.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
            if (!ConfigureKotlinInProjectUtilsKt.isRepositoryConfigured(string2)) {
                string = ConfigureKotlinInProjectUtilsKt.getMAVEN_CENTRAL();
            } else {
                return null;
            }
        }
        String snippet = string;
        KtExpression ktExpression = KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, $receiver, snippet, false, 2, null);
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    private final KtCallExpression addPluginToClassPathIfMissing(@NotNull KtBlockExpression $receiver) {
        KtExpression ktExpression = KotlinBuildScriptManipulator.addExpressionIfMissing$default(this, $receiver, "classpath(" + KotlinBuildScriptManipulator.getKotlinModuleDependencySnippet$default(this, "gradle-plugin", null, 2, null) + ')', false, 2, null);
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtBlockExpression addBlock(@NotNull KtBlockExpression $receiver, String name2) {
        PsiElement psiElement2;
        PsiElement psiElement3 = $receiver.add((PsiElement)this.getPsiFactory((PsiElement)$receiver).createExpression("" + name2 + " {\n}"));
        Object object = psiElement3;
        if (psiElement3 == null) return null;
        PsiElement $receiver2 = psiElement2 = object;
        KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this, $receiver2, 0, 1, null);
        PsiElement psiElement4 = psiElement2;
        object = psiElement4;
        if (psiElement4 == null) return null;
        PsiElement $receiver$iv = object;
        PsiElement psiElement5 = $receiver$iv;
        if (psiElement5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        }
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement5;
        object = ktCallExpression;
        if (ktCallExpression == null) return null;
        KtBlockExpression ktBlockExpression = this.getBlock((KtCallExpression)object);
        return ktBlockExpression;
    }

    private final KtBlockExpression addTopLevelBlock(@NotNull KtFile $receiver, String name2, boolean first) {
        KtScriptInitializer addedElement;
        KtScriptInitializer scriptInitializer = this.createScriptInitializer(this.getPsiFactory((PsiElement)$receiver), "" + name2 + " {\n}");
        PsiElement psiElement2 = this.addToScriptBlock($receiver, scriptInitializer, first);
        if (!(psiElement2 instanceof KtScriptInitializer)) {
            psiElement2 = null;
        }
        KtScriptInitializer ktScriptInitializer = addedElement = (KtScriptInitializer)psiElement2;
        if (ktScriptInitializer != null) {
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this, ktScriptInitializer, 0, 1, null);
        }
        KtScriptInitializer ktScriptInitializer2 = addedElement;
        return ktScriptInitializer2 != null ? this.getBlock(ktScriptInitializer2) : null;
    }

    static /* bridge */ /* synthetic */ KtBlockExpression addTopLevelBlock$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, KtFile ktFile, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinBuildScriptManipulator.addTopLevelBlock(ktFile, string, bl);
    }

    private final PsiElement addSibling(@NotNull PsiElement $receiver, PsiElement element3) {
        PsiElement psiElement2 = $receiver.getParent().addAfter(element3, $receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.addAfter(element, this)");
        return psiElement2;
    }

    private final void addNewLineBefore(@NotNull PsiElement $receiver, int lineBreaks) {
        $receiver.getParent().addBefore(this.getPsiFactory($receiver).createNewLine(lineBreaks), $receiver);
    }

    static /* bridge */ /* synthetic */ void addNewLineBefore$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, PsiElement psiElement2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        kotlinBuildScriptManipulator.addNewLineBefore(psiElement2, n);
    }

    private final void addNewLineAfter(@NotNull PsiElement $receiver, int lineBreaks) {
        $receiver.getParent().addAfter(this.getPsiFactory($receiver).createNewLine(lineBreaks), $receiver);
    }

    static /* bridge */ /* synthetic */ void addNewLineAfter$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, PsiElement psiElement2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        kotlinBuildScriptManipulator.addNewLineAfter(psiElement2, n);
    }

    private final void addNewLinesIfNeeded(@NotNull PsiElement $receiver, int lineBreaks) {
        CharSequence charSequence;
        if ($receiver.getPrevSibling() != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)$receiver.getPrevSibling().getText()))) {
            this.addNewLineBefore($receiver, lineBreaks);
        }
        if ($receiver.getNextSibling() != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)$receiver.getNextSibling().getText()))) {
            this.addNewLineAfter($receiver, lineBreaks);
        }
    }

    static /* bridge */ /* synthetic */ void addNewLinesIfNeeded$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, PsiElement psiElement2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        kotlinBuildScriptManipulator.addNewLinesIfNeeded(psiElement2, n);
    }

    private final PsiElement addToScriptBlock(@NotNull KtFile $receiver, PsiElement element3, boolean first) {
        KtStatementExpression ktStatementExpression;
        KtStatementExpression ktStatementExpression2;
        return first ? ((ktStatementExpression2 = $receiver.getScript()) != null && (ktStatementExpression2 = ktStatementExpression2.getBlockExpression()) != null ? ktStatementExpression2.addAfter(element3, null) : null) : ((ktStatementExpression = $receiver.getScript()) != null && (ktStatementExpression = ktStatementExpression.getBlockExpression()) != null ? ktStatementExpression.add(element3) : null);
    }

    static /* bridge */ /* synthetic */ PsiElement addToScriptBlock$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, KtFile ktFile, PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinBuildScriptManipulator.addToScriptBlock(ktFile, psiElement2, bl);
    }

    private final KtImportDirective addImportIfMissing(@NotNull KtFile $receiver, String path) {
        KtImportDirective ktImportDirective;
        Object v1;
        block3: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)$receiver.getImportDirectives();
            for (Object t : iterable2) {
                KtImportDirective it = (KtImportDirective)t;
                ImportPath importPath = it.getImportPath();
                if (!Intrinsics.areEqual((Object)(importPath != null ? importPath.getPathStr() : null), (Object)path)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if ((ktImportDirective = (KtImportDirective)v1) == null) {
            KtImportList ktImportList = $receiver.getImportList();
            PsiElement psiElement2 = ktImportList != null ? ktImportList.add((PsiElement)this.getPsiFactory((PsiElement)$receiver).createImportDirective(ImportPath.Companion.fromString(path))) : null;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
            }
            ktImportDirective = (KtImportDirective)psiElement2;
        }
        return ktImportDirective;
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression addExpressionAfterIfMissing(@NotNull KtBlockExpression $receiver, String text2, PsiElement after2) {
        Object object;
        Object v0;
        Object object2;
        KotlinBuildScriptManipulator this_$iv;
        block5: {
            void $receiver$iv;
            KtBlockExpression ktBlockExpression = $receiver;
            this_$iv = this;
            object2 = $receiver$iv.getStatements();
            Iterable iterable = object2;
            for (Object t : iterable) {
                KtExpression it$iv = (KtExpression)t;
                if (!Intrinsics.areEqual((Object)it$iv.getText(), (Object)text2)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        KtExpression ktExpression = v0;
        if (ktExpression != null) {
            object2 = ktExpression;
            Object it$iv = object2;
            object = it$iv;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        } else {
            KtExpression ktExpression2;
            String it = text2;
            KtExpression created = ktExpression2 = this.getPsiFactory((PsiElement)$receiver).createExpression(it);
            PsiElement psiElement2 = $receiver.addAfter((PsiElement)created, after2);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"addAfter(created, after)");
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"psiFactory.createExpress\u2026created, after)\n        }");
            Object $receiver$iv = object2 = psiElement2;
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this_$iv, (PsiElement)$receiver$iv, 0, 1, null);
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = (KtExpression)object3;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression addExpressionIfMissing(@NotNull KtBlockExpression $receiver, String text2, boolean first) {
        Object object;
        Object v0;
        Object object2;
        KotlinBuildScriptManipulator this_$iv;
        block7: {
            void $receiver$iv;
            KtBlockExpression ktBlockExpression = $receiver;
            this_$iv = this;
            object2 = $receiver$iv.getStatements();
            Iterable iterable = object2;
            for (Object t : iterable) {
                KtExpression it$iv = (KtExpression)t;
                if (!Intrinsics.areEqual((Object)it$iv.getText(), (Object)text2)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        KtExpression ktExpression = v0;
        if (ktExpression != null) {
            object2 = ktExpression;
            Object it$iv = object2;
            object = it$iv;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        } else {
            PsiElement psiElement2;
            KtExpression ktExpression2;
            String it = text2;
            KtExpression created = ktExpression2 = this.getPsiFactory((PsiElement)$receiver).createExpression(it);
            if (first) {
                PsiElement psiElement3 = $receiver.addAfter((PsiElement)created, null);
                psiElement2 = psiElement3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"addAfter(created, null)");
            } else {
                PsiElement psiElement4 = $receiver.add((PsiElement)created);
                psiElement2 = psiElement4;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"add(created)");
            }
            Object $receiver$iv = object2 = psiElement2;
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this_$iv, (PsiElement)$receiver$iv, 0, 1, null);
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = (KtExpression)object3;
        }
        return object;
    }

    static /* bridge */ /* synthetic */ KtExpression addExpressionIfMissing$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, KtBlockExpression ktBlockExpression, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinBuildScriptManipulator.addExpressionIfMissing(ktBlockExpression, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final KtDeclaration addDeclarationIfMissing(@NotNull KtBlockExpression $receiver, String text2, boolean first) {
        KtDeclaration ktDeclaration;
        Object v0;
        Object object;
        KotlinBuildScriptManipulator this_$iv;
        block7: {
            void $receiver$iv;
            KtBlockExpression ktBlockExpression = $receiver;
            this_$iv = this;
            object = $receiver$iv.getStatements();
            Iterable iterable = object;
            for (Object t : iterable) {
                KtExpression it$iv = (KtExpression)t;
                if (!Intrinsics.areEqual((Object)it$iv.getText(), (Object)text2)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        KtExpression ktExpression = v0;
        if (ktExpression != null) {
            Object it$iv;
            Object object2 = it$iv = (object = ktExpression);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            ktDeclaration = (KtDeclaration)object2;
        } else {
            PsiElement psiElement2;
            Object TDeclaration;
            String it = text2;
            Object created = TDeclaration = this.getPsiFactory((PsiElement)$receiver).createDeclaration(it);
            if (first) {
                PsiElement psiElement3 = $receiver.addAfter((PsiElement)created, null);
                psiElement2 = psiElement3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"addAfter(created, null)");
            } else {
                PsiElement psiElement4 = $receiver.add((PsiElement)created);
                psiElement2 = psiElement4;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"add(created)");
            }
            Object $receiver$iv = object = psiElement2;
            KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this_$iv, (PsiElement)$receiver$iv, 0, 1, null);
            Object object3 = object;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            ktDeclaration = (KtDeclaration)object3;
        }
        return ktDeclaration;
    }

    static /* bridge */ /* synthetic */ KtDeclaration addDeclarationIfMissing$default(KotlinBuildScriptManipulator kotlinBuildScriptManipulator, KtBlockExpression ktBlockExpression, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinBuildScriptManipulator.addDeclarationIfMissing(ktBlockExpression, string, bl);
    }

    private final <T extends PsiElement> T addStatementIfMissing(@NotNull KtBlockExpression $receiver, String text2, Function1<? super String, ? extends PsiElement> factory2) {
        Object v0;
        Object object;
        block2: {
            object = $receiver.getStatements();
            Iterable iterable = object;
            for (Object t : iterable) {
                KtExpression it = (KtExpression)t;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)text2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        KtExpression ktExpression = v0;
        if (ktExpression != null) {
            Object it = object = ktExpression;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)((PsiElement)it);
        }
        object = factory2.invoke((Object)text2);
        PsiElement $receiver2 = (PsiElement)object;
        KotlinBuildScriptManipulator.addNewLinesIfNeeded$default(this, $receiver2, 0, 1, null);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)((PsiElement)object);
    }

    private final KtScriptInitializer createScriptInitializer(@NotNull KtPsiFactory $receiver, String text2) {
        KtStatementExpression ktStatementExpression = $receiver.createFile("dummy.kts", text2).getScript();
        PsiElement psiElement2 = ktStatementExpression != null && (ktStatementExpression = ktStatementExpression.getBlockExpression()) != null ? ktStatementExpression.getFirstChild() : null;
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtScriptInitializer");
        }
        return (KtScriptInitializer)psiElement2;
    }

    private final KtPsiFactory getPsiFactory(@NotNull PsiElement $receiver) {
        return KtPsiFactoryKt.KtPsiFactory$default($receiver, false, 2, null);
    }

    public KotlinBuildScriptManipulator(@NotNull KtFile kotlinScript) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinScript, (String)"kotlinScript");
        this.kotlinScript = kotlinScript;
    }

    static {
        STDLIB_ARTIFACT_PREFIX = STDLIB_ARTIFACT_PREFIX;
        GSK_KOTLIN_VERSION_PROPERTY_NAME = GSK_KOTLIN_VERSION_PROPERTY_NAME;
    }

    public static final /* synthetic */ boolean access$containsApplyKotlinPlugin(KotlinBuildScriptManipulator $this, @NotNull KtFile $receiver, @NotNull String pluginName) {
        return $this.containsApplyKotlinPlugin($receiver, pluginName);
    }

    public static final /* synthetic */ boolean access$containsCompileStdLib(KotlinBuildScriptManipulator $this, @NotNull KtFile $receiver) {
        return $this.containsCompileStdLib($receiver);
    }

    @NotNull
    public static final /* synthetic */ KtFile access$getKotlinScript$p(KotlinBuildScriptManipulator $this) {
        return $this.kotlinScript;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildScriptManipulator$Companion;", "", "()V", "GSK_KOTLIN_VERSION_PROPERTY_NAME", "", "getGSK_KOTLIN_VERSION_PROPERTY_NAME", "()Ljava/lang/String;", "STDLIB_ARTIFACT_PREFIX", "getSTDLIB_ARTIFACT_PREFIX", "idea-gradle"})
    public static final class Companion {
        private final String getSTDLIB_ARTIFACT_PREFIX() {
            return STDLIB_ARTIFACT_PREFIX;
        }

        private final String getGSK_KOTLIN_VERSION_PROPERTY_NAME() {
            return GSK_KOTLIN_VERSION_PROPERTY_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

