/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$WhenMappings;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$isParsedAsFile$;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedJavaCode;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedKotlinCode;
import org.jetbrains.kotlin.idea.conversion.copy.DataForConversion;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.PlainTextPasteImportResolver;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 @2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004@ABCB\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010*\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010,\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010-\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010.\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010/\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u00100\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\bH\u0002JD\u00102\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020!2\f\u00107\u001a\b\u0012\u0004\u0012\u00020'082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0014\u0010:\u001a\u00020;*\u00020<2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010=\u001a\u00020>*\u00020<2\u0006\u0010?\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "pasteContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getPasteContext", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "createCopiedJavaCode", "Lorg/jetbrains/kotlin/idea/conversion/copy/CopiedJavaCode;", "prefix", "", "templateWithoutPrefix", "text", "detectConversionContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "project", "Lcom/intellij/openapi/project/Project;", "detectPasteTarget", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "isParsedAsFile", "", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "isParsedAsJavaCode", "context", "isParsedAsJavaFile", "isParsedAsKotlinCode", "isParsedAsKotlinFile", "parseAsFile", "prepareCopiedJavaCodeByContext", "target", "processTransferableData", "", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "indented", "Lcom/intellij/openapi/util/Ref;", "values", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/DataForConversion;", "tryResolveImports", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "targetFile", "Companion", "JavaContext", "KotlinContext", "MyTransferableData", "idea"})
public final class ConvertTextJavaCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    private final Logger LOG = Logger.getInstance(ConvertTextJavaCopyPasteProcessor.class);
    private static boolean conversionPerformed;
    public static final Companion Companion;

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkParameterIsNotNull((Object)endOffsets, (String)"endOffsets");
        if (file2 instanceof KtFile) {
            String string = ((KtFile)file2).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
            return CollectionsKt.listOf((Object)new CopiedKotlinCode(string, startOffsets, endOffsets));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        try {
            if (content2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (content2.isDataFlavorSupported(CopiedKotlinCode.Companion.getDATA_FLAVOR()) || content2.isDataFlavorSupported(CopiedJavaCode.Companion.getDATA_FLAVOR())) {
                    return CollectionsKt.emptyList();
                }
                Object object = content2.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String text2 = (String)object;
                return CollectionsKt.listOf((Object)new MyTransferableData(text2));
            }
        }
        catch (Throwable e) {
            this.LOG.error(e);
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values) {
        void convertedImportsText;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Intrinsics.checkParameterIsNotNull(indented, (String)"indented");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        if (!KotlinEditorOptions.getInstance().isEnableJavaToKotlinConversion()) {
            return;
        }
        Object object = CollectionsKt.single(values);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor.MyTransferableData");
        }
        String text2 = ((MyTransferableData)object).getText();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(editor.getDocument());
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor.getDocument());
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return;
        }
        KtFile targetFile = ktFile;
        KtElement ktElement = this.detectPasteTarget(targetFile, bounds.getStartOffset(), bounds.getEndOffset());
        if (ktElement == null) {
            return;
        }
        KtElement pasteTarget = ktElement;
        JavaContext javaContext = this.detectConversionContext(this.getPasteContext(pasteTarget), text2, project);
        if (javaContext == null) {
            return;
        }
        JavaContext conversionContext = javaContext;
        if (!ConvertJavaCopyPasteProcessorKt.confirmConvertJavaOnPaste(project, true)) {
            return;
        }
        CopiedJavaCode copiedJavaCode = this.prepareCopiedJavaCodeByContext(text2, conversionContext, pasteTarget);
        DataForConversion dataForConversion = DataForConversion.Companion.prepare(copiedJavaCode, project);
        ElementAndTextList additionalImports = this.tryResolveImports(dataForConversion, targetFile);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin(additionalImports, project).getText();
        String convertedText = this.convertCodeToKotlin(dataForConversion, project).getText();
        TextRange newBounds2 = (TextRange)ApplicationUtilsKt.runWriteAction((Function0)new Function0<TextRange>(targetFile, (Ref.ObjectRef)convertedImportsText, editor, bounds, convertedText){
            final /* synthetic */ KtFile $targetFile;
            final /* synthetic */ Ref.ObjectRef $convertedImportsText;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ RangeMarker $bounds;
            final /* synthetic */ String $convertedText;

            @NotNull
            public final TextRange invoke() {
                CharSequence charSequence;
                int importsInsertOffset;
                KtImportList ktImportList = this.$targetFile.getImportList();
                int n = importsInsertOffset = ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)ktImportList) : 0;
                if (this.$targetFile.getImportDirectives().isEmpty() && importsInsertOffset > 0) {
                    this.$convertedImportsText.element = "\n" + (String)this.$convertedImportsText.element;
                }
                if (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)((String)this.$convertedImportsText.element)))) {
                    this.$editor.getDocument().insertString(importsInsertOffset, (CharSequence)((String)this.$convertedImportsText.element));
                }
                int startOffset = this.$bounds.getStartOffset();
                this.$editor.getDocument().replaceString(startOffset, this.$bounds.getEndOffset(), (CharSequence)this.$convertedText);
                int endOffsetAfterCopy = startOffset + this.$convertedText.length();
                this.$editor.getCaretModel().moveToOffset(endOffsetAfterCopy);
                return new TextRange(startOffset, startOffset + this.$convertedText.length());
            }
            {
                this.$targetFile = ktFile;
                this.$convertedImportsText = objectRef;
                this.$editor = editor;
                this.$bounds = rangeMarker;
                this.$convertedText = string;
                super(0);
            }
        });
        psiDocumentManager.commitAllDocuments();
        new AfterConversionPass(project, new J2kPostProcessor(true)).run(targetFile, newBounds2);
        Companion.setConversionPerformed(true);
    }

    private final ConversionResult convertCodeToKotlin(@NotNull DataForConversion $receiver, Project project) {
        return ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin($receiver.getElementsAndTexts(), project);
    }

    private final KotlinContext getPasteContext(@NotNull KtElement $receiver) {
        KtElement ktElement = $receiver;
        return ktElement instanceof KtFile ? KotlinContext.TOP_LEVEL : (ktElement instanceof KtClassBody ? KotlinContext.CLASS_BODY : (ktElement instanceof KtBlockExpression ? KotlinContext.IN_BLOCK : KotlinContext.EXPRESSION));
    }

    private final KtElement detectPasteTarget(KtFile file2, int startOffset, int endOffset) {
        PsiFile newFile;
        if (ConvertJavaCopyPasteProcessorKt.isNoConversionPosition(file2, startOffset)) {
            return null;
        }
        String fileText = file2.getText();
        String dummyDeclarationText = "fun dummy(){}";
        String string = fileText;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, startOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        string = fileText;
        stringBuilder = stringBuilder.append(string4).append(" ").append(dummyDeclarationText).append("\n");
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(endOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        string4 = string6;
        String newFileText = stringBuilder.append(string4).toString();
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        LanguageFileType languageFileType = kotlinFileType;
        Project project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        PsiFile psiFile = newFile = this.parseAsFile(newFileText, languageFileType, project);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtPsiFactoryKt.setAnalysisContext((KtFile)psiFile, (PsiElement)file2);
        PsiElement psiElement2 = newFile.findElementAt(startOffset + 1);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement funKeyword = psiElement2;
        if (Intrinsics.areEqual((Object)funKeyword.getNode().getElementType(), (Object)((Object)KtTokens.FUN_KEYWORD)) ^ true) {
            return null;
        }
        PsiElement psiElement3 = funKeyword.getParent();
        if (!(psiElement3 instanceof KtFunction)) {
            psiElement3 = null;
        }
        KtFunction ktFunction = (KtFunction)psiElement3;
        if (ktFunction == null) {
            return null;
        }
        KtFunction declaration2 = ktFunction;
        PsiElement psiElement4 = declaration2.getParent();
        if (!(psiElement4 instanceof KtElement)) {
            psiElement4 = null;
        }
        return (KtElement)psiElement4;
    }

    private final JavaContext detectConversionContext(KotlinContext pasteContext, String text2, Project project) {
        if (this.isParsedAsKotlinCode(text2, pasteContext, project)) {
            return null;
        }
        Function1<JavaContext, JavaContext> check$ = new Function1<JavaContext, JavaContext>(this, text2, project){
            final /* synthetic */ ConvertTextJavaCopyPasteProcessor this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ Project $project;

            @Nullable
            public final JavaContext invoke(@NotNull JavaContext $receiver) {
                JavaContext javaContext;
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
                JavaContext it = javaContext = $receiver;
                return ConvertTextJavaCopyPasteProcessor.access$isParsedAsJavaCode(this.this$0, this.$text, it, this.$project) ? javaContext : null;
            }
            {
                this.this$0 = convertTextJavaCopyPasteProcessor;
                this.$text = string;
                this.$project = project;
                super(1);
            }
        };
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$0[pasteContext.ordinal()]) {
            case 1: {
                JavaContext javaContext = check$.invoke(JavaContext.TOP_LEVEL);
                if (javaContext != null) {
                    JavaContext javaContext2;
                    JavaContext it = javaContext2 = javaContext;
                    return it;
                }
                JavaContext javaContext3 = check$.invoke(JavaContext.CLASS_BODY);
                if (javaContext3 != null) {
                    JavaContext javaContext4;
                    JavaContext it = javaContext4 = javaContext3;
                    return it;
                }
                return null;
            }
            case 2: {
                return check$.invoke(JavaContext.CLASS_BODY);
            }
            case 3: {
                return check$.invoke(JavaContext.IN_BLOCK);
            }
            case 4: {
                return check$.invoke(JavaContext.EXPRESSION);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean isParsedAsJavaCode(String text2, JavaContext context, Project project) {
        boolean bl;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$1[context.ordinal()]) {
            case 1: {
                bl = this.isParsedAsJavaFile(text2, project);
                break;
            }
            case 2: {
                bl = this.isParsedAsJavaFile("class Dummy { " + text2 + "\n}", project);
                break;
            }
            case 3: {
                bl = this.isParsedAsJavaFile("class Dummy { void foo() {" + text2 + "\n}\n}", project);
                break;
            }
            case 4: {
                bl = this.isParsedAsJavaFile("class Dummy { Object field = " + text2 + "; }", project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isParsedAsKotlinCode(String text2, KotlinContext context, Project project) {
        boolean bl;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$2[context.ordinal()]) {
            case 1: {
                bl = this.isParsedAsKotlinFile(text2, project);
                break;
            }
            case 2: {
                bl = this.isParsedAsKotlinFile("class Dummy { " + text2 + "\n}", project);
                break;
            }
            case 3: {
                bl = this.isParsedAsKotlinFile("fun foo() {" + text2 + "\n}", project);
                break;
            }
            case 4: {
                bl = this.isParsedAsKotlinFile("val v = " + text2, project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isParsedAsJavaFile(String text2, Project project) {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaFileType, (String)"JavaFileType.INSTANCE");
        return this.isParsedAsFile(text2, (LanguageFileType)javaFileType, project);
    }

    private final boolean isParsedAsKotlinFile(String text2, Project project) {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFileType), (String)"KotlinFileType.INSTANCE");
        return this.isParsedAsFile(text2, kotlinFileType, project);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isParsedAsFile(String text2, LanguageFileType fileType, Project project) {
        void result$iv$iv$iv;
        PsiElement $receiver$iv$iv;
        PsiFile psiFile = this.parseAsFile(text2, fileType, project);
        PsiElement $receiver$iv = (PsiElement)psiFile;
        Function1 predicate$iv = isParsedAsFile$$inlined$anyDescendantOfType$1.INSTANCE;
        PsiElement $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                super.visitElement(element3);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    private final PsiFile parseAsFile(String text2, LanguageFileType fileType, Project project) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy.java", (FileType)fileType, (CharSequence)text2, LocalTimeCounter.currentTime(), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026nter.currentTime(), true)");
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementAndTextList tryResolveImports(@NotNull DataForConversion $receiver, KtFile targetFile) {
        void $receiver$iv$iv;
        void $receiver$iv;
        ElementAndTextList elementAndTextList;
        PlainTextPasteImportResolver importResolver2 = new PlainTextPasteImportResolver($receiver, targetFile);
        importResolver2.addImportsFromTargetFile();
        importResolver2.tryResolveReferences();
        Iterable iterable = importResolver2.getAddedImports();
        ElementAndTextList elementAndTextList2 = elementAndTextList;
        ElementAndTextList elementAndTextList3 = elementAndTextList;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiImportStatementBase it = (PsiImportStatementBase)element$iv$iv;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Object[]{"\n", it});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        elementAndTextList2(CollectionsKt.plus((Collection)list2, (Object)"\n\n"));
        return elementAndTextList3;
    }

    /*
     * WARNING - void declaration
     */
    private final CopiedJavaCode prepareCopiedJavaCodeByContext(String text2, JavaContext context, KtElement target) {
        CopiedJavaCode copiedJavaCode;
        String string;
        Object object;
        StringBuilder stringBuilder;
        PsiFile psiFile = target.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile targetFile = (KtFile)psiFile;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        KtPackageDirective ktPackageDirective = targetFile.getPackageDirective();
        if (ktPackageDirective != null) {
            object = ktPackageDirective;
            Object it = object;
            CharSequence charSequence = it.getText();
            if (charSequence.length() > 0) {
                $receiver.append(it.getText());
                $receiver.append(";\n");
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String prefix = string2;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$3[context.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                PsiClassType[] $receiver2;
                Object[] $receiver$iv;
                Object[] objectArray;
                Object[] objectArray2;
                void $receiver$iv2;
                object = (PsiElement)target;
                boolean strict$iv = false;
                KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtClass.class, (boolean)strict$iv);
                PsiClassType[] lightClass = ktClass2 != null ? LightClassUtilsKt.toLightClass(ktClass2) : null;
                Object $receiver3 = object = new StringBuilder();
                ((StringBuilder)$receiver3).append("class ");
                Object object2 = lightClass;
                if (lightClass == null || (object2 = object2.getName()) == null) {
                    object2 = "Dummy";
                }
                ((StringBuilder)$receiver3).append((String)object2);
                PsiClassType[] psiClassTypeArray = lightClass;
                if (lightClass != null && (psiClassTypeArray = psiClassTypeArray.getExtendsListTypes()) != null && !((objectArray2 = (objectArray = ($receiver$iv = (Object[])psiClassTypeArray))).length == 0)) {
                    $receiver2 = (PsiClassType[])$receiver$iv;
                    StringBuilder cfr_ignored_0 = (StringBuilder)ArraysKt.joinTo$default((Object[])$receiver2, (Appendable)((Appendable)$receiver3), null, (CharSequence)" extends ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.1.1.INSTANCE, (int)58, null);
                }
                PsiClassType[] psiClassTypeArray2 = lightClass;
                if (lightClass != null && (psiClassTypeArray2 = psiClassTypeArray2.getImplementsListTypes()) != null) {
                    $receiver$iv = psiClassTypeArray2;
                    objectArray = $receiver$iv;
                    objectArray2 = objectArray;
                    if (!(objectArray2.length == 0)) {
                        $receiver2 = (PsiClassType[])$receiver$iv;
                        StringBuilder cfr_ignored_1 = (StringBuilder)ArraysKt.joinTo$default((Object[])$receiver2, (Appendable)((Appendable)$receiver3), null, (CharSequence)" implements ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.2.1.INSTANCE, (int)58, null);
                    }
                }
                String string3 = ((StringBuilder)object).toString();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String classDef2 = string;
        switch (ConvertTextJavaCopyPasteProcessor$WhenMappings.$EnumSwitchMapping$4[context.ordinal()]) {
            case 1: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, "$", text2);
                break;
            }
            case 2: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, "" + classDef2 + " {\n$\n}", text2);
                break;
            }
            case 3: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, "" + classDef2 + " {\nvoid foo() {\n$\n}\n}", text2);
                break;
            }
            case 4: {
                copiedJavaCode = this.createCopiedJavaCode(prefix, "" + classDef2 + " {\nObject field = $\n}", text2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return copiedJavaCode;
    }

    private final CopiedJavaCode createCopiedJavaCode(String prefix, String templateWithoutPrefix, String text2) {
        boolean bl;
        String template2 = "" + prefix + "" + templateWithoutPrefix;
        int index2 = StringsKt.indexOf$default((CharSequence)template2, (String)"$", (int)0, (boolean)false, (int)6, null);
        boolean bl2 = bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = template2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        string = template2;
        n = index2 + 1;
        stringBuilder = stringBuilder.append(string4).append(text2);
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        string4 = string6;
        String fileText = stringBuilder.append(string4).toString();
        return new CopiedJavaCode(fileText, new int[]{index2}, new int[]{index2 + text2.length()});
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ boolean access$isParsedAsJavaCode(ConvertTextJavaCopyPasteProcessor $this, @NotNull String text2, @NotNull JavaContext context, @NotNull Project project) {
        return $this.isParsedAsJavaCode(text2, context, project);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getFlavor", "Ljava/awt/datatransfer/DataFlavor;", "getOffsetCount", "", "getOffsets", "offsets", "", "index", "setOffsets", "Companion", "idea"})
    private static final class MyTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final String text;
        @NotNull
        private static final DataFlavor DATA_FLAVOR;
        public static final Companion Companion;

        @NotNull
        public DataFlavor getFlavor() {
            return Companion.getDATA_FLAVOR();
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(@Nullable int[] offsets, int index2) {
            return index2;
        }

        public int setOffsets(@Nullable int[] offsets, int index2) {
            return index2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public MyTransferableData(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            this.text = text2;
        }

        static {
            Companion = new Companion(null);
            DATA_FLAVOR = new DataFlavor(ConvertTextJavaCopyPasteProcessor.class, "class: ConvertTextJavaCopyPasteProcessor");
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData$Companion;", "", "()V", "DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getDATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "idea"})
        public static final class Companion {
            @NotNull
            public final DataFlavor getDATA_FLAVOR() {
                return DATA_FLAVOR;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "idea"})
    private static final class KotlinContext
    extends Enum<KotlinContext> {
        public static final /* enum */ KotlinContext TOP_LEVEL;
        public static final /* enum */ KotlinContext CLASS_BODY;
        public static final /* enum */ KotlinContext IN_BLOCK;
        public static final /* enum */ KotlinContext EXPRESSION;
        private static final /* synthetic */ KotlinContext[] $VALUES;

        static {
            KotlinContext[] kotlinContextArray = new KotlinContext[4];
            KotlinContext[] kotlinContextArray2 = kotlinContextArray;
            kotlinContextArray[0] = TOP_LEVEL = new KotlinContext();
            kotlinContextArray[1] = CLASS_BODY = new KotlinContext();
            kotlinContextArray[2] = IN_BLOCK = new KotlinContext();
            kotlinContextArray[3] = EXPRESSION = new KotlinContext();
            $VALUES = kotlinContextArray;
        }

        public static KotlinContext[] values() {
            return (KotlinContext[])$VALUES.clone();
        }

        public static KotlinContext valueOf(String string) {
            return Enum.valueOf(KotlinContext.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "idea"})
    private static final class JavaContext
    extends Enum<JavaContext> {
        public static final /* enum */ JavaContext TOP_LEVEL;
        public static final /* enum */ JavaContext CLASS_BODY;
        public static final /* enum */ JavaContext IN_BLOCK;
        public static final /* enum */ JavaContext EXPRESSION;
        private static final /* synthetic */ JavaContext[] $VALUES;

        static {
            JavaContext[] javaContextArray = new JavaContext[4];
            JavaContext[] javaContextArray2 = javaContextArray;
            javaContextArray[0] = TOP_LEVEL = new JavaContext();
            javaContextArray[1] = CLASS_BODY = new JavaContext();
            javaContextArray[2] = IN_BLOCK = new JavaContext();
            javaContextArray[3] = EXPRESSION = new JavaContext();
            $VALUES = javaContextArray;
        }

        public static JavaContext[] values() {
            return (JavaContext[])$VALUES.clone();
        }

        public static JavaContext valueOf(String string) {
            return Enum.valueOf(JavaContext.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$Companion;", "", "()V", "conversionPerformed", "", "getConversionPerformed", "()Z", "setConversionPerformed", "(Z)V", "idea"})
    public static final class Companion {
        public final boolean getConversionPerformed() {
            return conversionPerformed;
        }

        public final void setConversionPerformed(boolean bl) {
            conversionPerformed = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

