/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001f\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J0\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005JD\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J(\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010J\"\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010JF\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J>\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010!\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0005J4\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\"\u001a\u00020\u00192\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0005J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010&\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010J\"\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010J8\u0010*\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0002J0\u0010-\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J:\u0010.\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J0\u0010/\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\b\u0010!\u001a\u0004\u0018\u00010\u00172\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J.\u00100\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010\"\u001a\u00020\u00192\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J8\u00101\u001a\u00020+*\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010!\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/core/KotlinNameSuggester;", "", "()V", "ACCESSOR_PREFIXES", "", "", "[Ljava/lang/String;", "COMMON_TYPE_PARAMETER_NAMES", "", "MAX_NUMBER_OF_SUGGESTED_NAME_CHECKS", "", "extractIdentifiers", "s", "getCamelNames", "name", "validator", "Lkotlin/Function1;", "", "startLowerCase", "isIdentifier", "suggestIterationVariableNames", "", "collection", "Lorg/jetbrains/kotlin/psi/KtExpression;", "elementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "defaultName", "suggestNameByMultipleNames", "names", "suggestNameByName", "suggestNamesByExpressionAndType", "expression", "type", "suggestNamesByExpressionOnly", "suggestNamesByType", "suggestNamesForTypeParameters", "count", "suggestTypeAliasNameByPsi", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "addCamelNames", "", "", "addName", "addNamesByExpression", "addNamesByExpressionPSI", "addNamesByType", "addNamesByValueArgument", "idea-core"})
public final class KotlinNameSuggester {
    private static final List<String> COMMON_TYPE_PARAMETER_NAMES;
    private static final int MAX_NUMBER_OF_SUGGESTED_NAME_CHECKS = 1000;
    private static final String[] ACCESSOR_PREFIXES;
    public static final KotlinNameSuggester INSTANCE;

    @NotNull
    public final Collection<String> suggestNamesByExpressionAndType(@NotNull KtExpression expression2, @Nullable KotlinType type2, @Nullable BindingContext bindingContext2, @NotNull Function1<? super String, Boolean> validator2, @Nullable String defaultName) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        LinkedHashSet result2 = new LinkedHashSet();
        this.addNamesByExpression(result2, expression2, bindingContext2, validator2);
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            BindingContext bindingContext3 = bindingContext2;
            kotlinType = bindingContext3 != null ? bindingContext3.getType(expression2) : null;
        }
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            INSTANCE.addNamesByType(result2, it, validator2);
        }
        if (result2.isEmpty()) {
            this.addName(result2, defaultName, validator2);
        }
        return result2;
    }

    @NotNull
    public final List<String> suggestNamesByType(@NotNull KotlinType type2, @NotNull Function1<? super String, Boolean> validator2, @Nullable String defaultName) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ArrayList result2 = new ArrayList();
        this.addNamesByType(result2, type2, validator2);
        if (result2.isEmpty()) {
            this.addName(result2, defaultName, validator2);
        }
        return result2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List suggestNamesByType$default(KotlinNameSuggester kotlinNameSuggester, KotlinType kotlinType, Function1 function1, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return kotlinNameSuggester.suggestNamesByType(kotlinType, (Function1<? super String, Boolean>)function1, string);
    }

    @NotNull
    public final List<String> suggestNamesByExpressionOnly(@NotNull KtExpression expression2, @Nullable BindingContext bindingContext2, @NotNull Function1<? super String, Boolean> validator2, @Nullable String defaultName) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ArrayList result2 = new ArrayList();
        this.addNamesByExpression(result2, expression2, bindingContext2, validator2);
        if (result2.isEmpty()) {
            this.addName(result2, defaultName, validator2);
        }
        return result2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List suggestNamesByExpressionOnly$default(KotlinNameSuggester kotlinNameSuggester, KtExpression ktExpression, BindingContext bindingContext2, Function1 function1, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return kotlinNameSuggester.suggestNamesByExpressionOnly(ktExpression, bindingContext2, (Function1<? super String, Boolean>)function1, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> suggestIterationVariableNames(@NotNull KtExpression collection, @NotNull KotlinType elementType, @Nullable BindingContext bindingContext2, @NotNull Function1<? super String, Boolean> validator2, @Nullable String defaultName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        LinkedHashSet result2 = new LinkedHashSet();
        Iterable iterable = KotlinNameSuggester.suggestNamesByExpressionOnly$default(this, collection, bindingContext2, suggestIterationVariableNames.1.INSTANCE, null, 8, null);
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        String $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator3 = $receiver$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            String string;
            Object element$iv$iv$iv = iterator3.next();
            Object element$iv$iv = element$iv$iv$iv;
            String it = (String)element$iv$iv;
            if (StringUtil.unpluralize((String)it) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object item$iv : $receiver$iv) {
            void it;
            $receiver$iv$iv$iv = (String)item$iv;
            Collection collection2 = result2;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            String string = INSTANCE.suggestNameByName((String)v0, validator2);
            collection2.add(string);
        }
        this.addNamesByType(result2, elementType, validator2);
        if (result2.isEmpty()) {
            this.addName(result2, defaultName, validator2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> suggestNamesForTypeParameters(int count, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ArrayList<String> result2 = new ArrayList<String>();
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                void i;
                result2.add(this.suggestNameByMultipleNames((Collection<String>)COMMON_TYPE_PARAMETER_NAMES, validator2));
                if (i == n2) break;
                ++i;
            }
        }
        return result2;
    }

    @NotNull
    public final String suggestTypeAliasNameByPsi(@NotNull KtTypeElement typeElement, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkParameterIsNotNull((Object)typeElement, (String)"typeElement");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        suggestTypeAliasNameByPsi.1 render$ = suggestTypeAliasNameByPsi.1.INSTANCE;
        return this.suggestNameByName(render$.invoke(typeElement), validator2);
    }

    @NotNull
    public final String suggestNameByName(@NotNull String name2, @NotNull Function1<? super String, Boolean> validator2) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        if (((Boolean)validator2.invoke((Object)name2)).booleanValue()) {
            return name2;
        }
        for (i = 1; i <= MAX_NUMBER_OF_SUGGESTED_NAME_CHECKS && !((Boolean)validator2.invoke((Object)(name2 + i))).booleanValue(); ++i) {
        }
        return name2 + i;
    }

    @NotNull
    public final String suggestNameByMultipleNames(@NotNull Collection<String> names, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        int i = 0;
        while (true) {
            for (String name2 : names) {
                String candidate = i > 0 ? name2 + i : name2;
                if (!((Boolean)validator2.invoke((Object)candidate)).booleanValue()) continue;
                return candidate;
            }
            ++i;
        }
    }

    private final void addNamesByType(@NotNull Collection<String> $receiver, KotlinType type2, Function1<? super String, Boolean> validator2) {
        KotlinType type3 = TypeUtils.makeNotNullable(type2);
        KotlinBuiltIns builtIns = TypeUtilsKt.getBuiltIns(type3);
        KotlinTypeChecker typeChecker2 = KotlinTypeChecker.DEFAULT;
        if (ErrorUtils.containsErrorType(type3)) {
            return;
        }
        if (typeChecker2.equalTypes(builtIns.getBooleanType(), type3)) {
            this.addName($receiver, "b", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getIntType(), type3)) {
            this.addName($receiver, "i", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getByteType(), type3)) {
            this.addName($receiver, "byte", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getLongType(), type3)) {
            this.addName($receiver, "l", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getFloatType(), type3)) {
            this.addName($receiver, "fl", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getDoubleType(), type3)) {
            this.addName($receiver, "d", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getShortType(), type3)) {
            this.addName($receiver, "sh", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getCharType(), type3)) {
            this.addName($receiver, "c", validator2);
        } else if (typeChecker2.equalTypes(builtIns.getStringType(), type3)) {
            this.addName($receiver, "s", validator2);
        } else if (KotlinBuiltIns.isArray(type3) || KotlinBuiltIns.isPrimitiveArray(type3)) {
            KotlinType elementType = builtIns.getArrayElementType(type3);
            if (typeChecker2.equalTypes(builtIns.getBooleanType(), elementType)) {
                this.addName($receiver, "booleans", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getIntType(), elementType)) {
                this.addName($receiver, "ints", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getByteType(), elementType)) {
                this.addName($receiver, "bytes", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getLongType(), elementType)) {
                this.addName($receiver, "longs", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getFloatType(), elementType)) {
                this.addName($receiver, "floats", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getDoubleType(), elementType)) {
                this.addName($receiver, "doubles", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getShortType(), elementType)) {
                this.addName($receiver, "shorts", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getCharType(), elementType)) {
                this.addName($receiver, "chars", validator2);
            } else if (typeChecker2.equalTypes(builtIns.getStringType(), elementType)) {
                this.addName($receiver, "strings", validator2);
            } else {
                ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(elementType);
                if (classDescriptor != null) {
                    Name className2 = classDescriptor.getName();
                    this.addName($receiver, "arrayOf" + StringUtil.capitalize((String)className2.asString()) + "s", validator2);
                }
            }
        } else if (FunctionTypesKt.isFunctionType(type3)) {
            this.addName($receiver, "function", validator2);
        } else {
            Name className3;
            ClassifierDescriptor descriptor2 = type3.getConstructor().getDeclarationDescriptor();
            if (descriptor2 != null && !(className3 = descriptor2.getName()).isSpecial()) {
                String string = className3.asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.asString()");
                KotlinNameSuggester.addCamelNames$default(this, $receiver, string, validator2, false, 4, null);
            }
        }
    }

    @NotNull
    public final List<String> getCamelNames(@NotNull String name2, @NotNull Function1<? super String, Boolean> validator2, boolean startLowerCase) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(validator2, (String)"validator");
        ArrayList result2 = new ArrayList();
        this.addCamelNames(result2, name2, validator2, startLowerCase);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addCamelNames(@NotNull Collection<String> $receiver, String name2, Function1<? super String, Boolean> validator2, boolean startLowerCase) {
        int n;
        if (name2 == "") {
            return;
        }
        String s = this.extractIdentifiers(name2);
        String[] stringArray = ACCESSOR_PREFIXES;
        for (n = 0; n < stringArray.length; ++n) {
            String string;
            int len;
            String prefix = stringArray[n];
            if (!StringsKt.startsWith$default((String)s, (String)prefix, (boolean)false, (int)2, null) || (len = prefix.length()) >= s.length() || !Character.isUpperCase(s.charAt(len))) continue;
            String string2 = string = s;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(len);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            s = string3;
            break;
        }
        boolean upperCaseLetterBefore = false;
        n = 0;
        int n2 = s.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                char c = s.charAt((int)i);
                boolean upperCaseLetter = Character.isUpperCase(c);
                if (i == false) {
                    this.addName($receiver, startLowerCase ? CapitalizeDecapitalizeKt.decapitalizeSmart$default(s, false, 1, null) : s, validator2);
                } else if (upperCaseLetter && !upperCaseLetterBefore) {
                    String substring;
                    String string;
                    String string4 = string = s;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring((int)i), (String)"(this as java.lang.String).substring(startIndex)");
                    this.addName($receiver, startLowerCase ? CapitalizeDecapitalizeKt.decapitalizeSmart$default(substring, false, 1, null) : substring, validator2);
                }
                upperCaseLetterBefore = upperCaseLetter;
                if (i == n2) break;
                ++i;
            }
        }
    }

    static /* bridge */ /* synthetic */ void addCamelNames$default(KotlinNameSuggester kotlinNameSuggester, Collection collection, String string, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        kotlinNameSuggester.addCamelNames(collection, string, (Function1<? super String, Boolean>)function1, bl);
    }

    private final String extractIdentifiers(String s) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(s);
        while (lexer.getTokenType() != null) {
            if (Intrinsics.areEqual((Object)lexer.getTokenType(), (Object)((Object)KtTokens.IDENTIFIER))) {
                $receiver.append(lexer.getTokenText());
            }
            lexer.advance();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void addNamesByExpressionPSI(@NotNull Collection<String> $receiver, KtExpression expression2, Function1<? super String, Boolean> validator2) {
        if (expression2 == null) {
            return;
        }
        KtExpression deparenthesized = KtPsiUtil.safeDeparenthesize(expression2);
        KtExpression ktExpression = deparenthesized;
        if (ktExpression instanceof KtSimpleNameExpression) {
            KotlinNameSuggester.addCamelNames$default(this, $receiver, ((KtSimpleNameExpression)deparenthesized).getReferencedName(), validator2, false, 4, null);
        } else if (ktExpression instanceof KtQualifiedExpression) {
            this.addNamesByExpressionPSI($receiver, ((KtQualifiedExpression)deparenthesized).getSelectorExpression(), validator2);
        } else if (ktExpression instanceof KtCallExpression) {
            this.addNamesByExpressionPSI($receiver, ((KtCallExpression)deparenthesized).getCalleeExpression(), validator2);
        } else if (ktExpression instanceof KtPostfixExpression) {
            this.addNamesByExpressionPSI($receiver, ((KtPostfixExpression)deparenthesized).getBaseExpression(), validator2);
        }
    }

    private final void addNamesByExpression(@NotNull Collection<String> $receiver, KtExpression expression2, BindingContext bindingContext2, Function1<? super String, Boolean> validator2) {
        if (expression2 == null) {
            return;
        }
        this.addNamesByValueArgument($receiver, expression2, bindingContext2, validator2);
        this.addNamesByExpressionPSI($receiver, expression2, validator2);
    }

    private final void addNamesByValueArgument(@NotNull Collection<String> $receiver, KtExpression expression2, BindingContext bindingContext2, Function1<? super String, Boolean> validator2) {
        if (bindingContext2 == null) {
            return;
        }
        KtExpression argumentExpression = KtPsiUtilKt.getOutermostParenthesizerOrThis(expression2);
        PsiElement psiElement2 = argumentExpression.getParent();
        if (!(psiElement2 instanceof KtValueArgument)) {
            psiElement2 = null;
        }
        KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
        if (ktValueArgument == null) {
            return;
        }
        KtValueArgument valueArgument = ktValueArgument;
        ResolvedCall resolvedCall2 = CallUtilKt.getParentResolvedCall$default(argumentExpression, bindingContext2, false, 2, null);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(valueArgument);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        if (argumentMatch == null) {
            return;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        ValueParameterDescriptor parameter = argumentMatch2.getValueParameter();
        if (parameter.getContainingDeclaration().hasStableParameterNames()) {
            this.addName($receiver, parameter.getName().asString(), validator2);
        }
    }

    private final void addName(@NotNull Collection<String> $receiver, String name2, Function1<? super String, Boolean> validator2) {
        String string;
        if (name2 == null) {
            return;
        }
        if (this.isIdentifier(name2)) {
            string = name2;
        } else if (Intrinsics.areEqual((Object)name2, (Object)"class")) {
            string = "clazz";
        } else {
            return;
        }
        String correctedName = string;
        $receiver.add(this.suggestNameByName(correctedName, validator2));
    }

    public final boolean isIdentifier(@Nullable String name2) {
        CharSequence charSequence;
        if (name2 == null || (charSequence = (CharSequence)name2).length() == 0) {
            return false;
        }
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(name2, 0, name2.length());
        if (lexer.getTokenType() != KtTokens.IDENTIFIER) {
            return false;
        }
        lexer.advance();
        return lexer.getTokenType() == null;
    }

    /*
     * WARNING - void declaration
     */
    private KotlinNameSuggester() {
        void var1_1;
        INSTANCE = this;
        COMMON_TYPE_PARAMETER_NAMES = CollectionsKt.listOf((Object[])new String[]{"T", "U", "V", "W", "X", "Y", "Z"});
        MAX_NUMBER_OF_SUGGESTED_NAME_CHECKS = 1000;
        Object[] elements$iv = new String[]{"get", "is", "set"};
        ACCESSOR_PREFIXES = (String[])var1_1;
    }

    static {
        new KotlinNameSuggester();
    }
}

