/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidDexer;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J(\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0004\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "()V", "dex", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "wrapToByteBuffer", "Lcom/sun/jdi/ObjectReference;", "bytes", "Lcom/sun/jdi/ArrayReference;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "tryLoadClass", "Lcom/sun/jdi/ReferenceType;", "fqName", "", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "idea"})
public abstract class AbstractAndroidClassLoadingAdapter
implements ClassLoadingAdapter {
    @Nullable
    protected final byte[] dex(@NotNull EvaluationContextImpl context, @NotNull Collection<ClassToLoad> classes2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
        Project project = context.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
        return ((AndroidDexer)CollectionsKt.single(AndroidDexer.Companion.getInstances(project))).dex(classes2);
    }

    @NotNull
    protected final ObjectReference wrapToByteBuffer(@NotNull ArrayReference bytes2, @NotNull EvaluationContext context, @NotNull DebugProcessImpl process2) {
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        ReferenceType referenceType = process2.findClass(context, "java.nio.ByteBuffer", context.getClassLoader());
        if (referenceType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        ClassType byteBufferClass = (ClassType)referenceType;
        Method method = byteBufferClass.concreteMethodByName("wrap", "([B)Ljava/nio/ByteBuffer;");
        if (method == null) {
            String string = "'wrap' method not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Method wrapMethod = method;
        Value value2 = process2.invokeMethod(context, byteBufferClass, wrapMethod, CollectionsKt.listOf((Object)bytes2));
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        return (ObjectReference)value2;
    }

    @Nullable
    protected final ReferenceType tryLoadClass(@NotNull DebugProcessImpl $receiver, @NotNull EvaluationContextImpl context, @NotNull String fqName2, @Nullable ClassLoaderReference classLoader) {
        ReferenceType referenceType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        try {
            referenceType = $receiver.loadClass(context, fqName2, classLoader);
        }
        catch (Throwable e) {
            referenceType = null;
        }
        return referenceType;
    }

    @Override
    @NotNull
    public ArrayReference mirrorOfByteArray(@NotNull byte[] bytes2, @NotNull EvaluationContextImpl context, @NotNull DebugProcessImpl process2) {
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        return ClassLoadingAdapter.DefaultImpls.mirrorOfByteArray(this, bytes2, context, process2);
    }
}

