/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.IsKotlinBinary;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/IsKotlinBinary;", "kotlin.jvm.PlatformType", "getKEY", "()Lcom/intellij/openapi/util/Key;", "KOTLIN_COMPILED_FILE_ATTRIBUTE", "", "getKOTLIN_COMPILED_FILE_ATTRIBUTE", "()Ljava/lang/String;", "findMultifileClassParts", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "header", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "isKotlinInternalCompiledFile", "", "fileContent", "", "isKotlinWithCompatibleAbiVersion", "idea-analysis"})
public final class ClassFileDecompilerUtilKt {
    @NotNull
    private static final String KOTLIN_COMPILED_FILE_ATTRIBUTE;
    @NotNull
    private static final Key<IsKotlinBinary> KEY;

    @NotNull
    public static final String getKOTLIN_COMPILED_FILE_ATTRIBUTE() {
        return KOTLIN_COMPILED_FILE_ATTRIBUTE;
    }

    @NotNull
    public static final Key<IsKotlinBinary> getKEY() {
        return KEY;
    }

    public static final boolean isKotlinWithCompatibleAbiVersion(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!IDEKotlinBinaryClassCache.isKotlinJvmCompiledFile$default(IDEKotlinBinaryClassCache.INSTANCE, file2, null, 2, null)) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinClass = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, file2, null, 2, null);
        return kotlinClass != null && kotlinClass.getClassHeader().getMetadataVersion().isCompatible();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        void header;
        boolean innerClass;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!IDEKotlinBinaryClassCache.INSTANCE.isKotlinJvmCompiledFile(file2, fileContent)) {
            return false;
        }
        boolean bl = innerClass = fileContent == null ? ClassFileViewProvider.isInnerClass((VirtualFile)file2) : ClassFileViewProvider.isInnerClass((VirtualFile)file2, (byte[])fileContent);
        if (innerClass) {
            return true;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData = IDEKotlinBinaryClassCache.INSTANCE.getKotlinBinaryClassHeaderData(file2, fileContent);
        if (kotlinBinaryHeaderData == null) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData2 = kotlinBinaryHeaderData;
        KotlinClassHeader kotlinClassHeader = kotlinBinaryHeaderData2.component1();
        ClassId classId = kotlinBinaryHeaderData2.component2();
        if (classId.isLocal()) {
            return true;
        }
        return Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS)) || Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.MULTIFILE_CLASS_PART));
    }

    public static /* bridge */ /* synthetic */ boolean isKotlinInternalCompiledFile$default(VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile2, byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file2, @NotNull ClassId classId, @NotNull KotlinClassHeader header) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        FqName packageFqName = classId.getPackageFqName();
        VirtualFile virtualFile2 = file2.getParent();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile2, fqName2);
        String[] stringArray = header.getData();
        if (stringArray == null) {
            return CollectionsKt.emptyList();
        }
        String[] partNames = stringArray;
        Object[] objectArray = $receiver$iv = (Object[])partNames;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass;
            void element$iv$iv$iv = $receiver$iv$iv$iv[i];
            void element$iv$iv = element$iv$iv$iv;
            String it = (String)element$iv$iv;
            if (partsFinder.findKotlinClass(new ClassId(packageFqName, Name.identifier(StringsKt.substringAfterLast$default((String)it, (char)'/', null, (int)2, null)))) == null) continue;
            KotlinJvmBinaryClass it$iv$iv = kotlinJvmBinaryClass;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        String string;
        String $receiver = string = "kotlin-compiled-file";
        FileAttributeService fileAttributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
        if (fileAttributeService != null) {
            FileAttributeService.DefaultImpls.register$default(fileAttributeService, $receiver, 1, false, 4, null);
        }
        KOTLIN_COMPILED_FILE_ATTRIBUTE = string;
        KEY = Key.create((String)KOTLIN_COMPILED_FILE_ATTRIBUTE);
    }
}

