/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinMissingForOrWhileBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "isValidLoopCondition", "", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "idea"})
public final class KotlinMissingForOrWhileBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!(element3 instanceof KtForExpression) && !(element3 instanceof KtWhileExpression)) {
            return;
        }
        KtLoopExpression loopExpression = (KtLoopExpression)element3;
        Document doc = editor.getDocument();
        KtExpression body2 = loopExpression.getBody();
        if (body2 instanceof KtBlockExpression) {
            return;
        }
        if (!this.isValidLoopCondition(loopExpression)) {
            return;
        }
        if (body2 != null) {
            PsiElement psiElement2 = (PsiElement)body2;
            Document document = doc;
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"doc");
            if (FixersUtilKt.startLine(psiElement2, document) == FixersUtilKt.startLine((PsiElement)loopExpression, doc)) {
                return;
            }
        }
        PsiElement psiElement3 = loopExpression.getRightParenthesis();
        if (psiElement3 == null) {
            return;
        }
        PsiElement rParen = psiElement3;
        doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{}");
    }

    private final boolean isValidLoopCondition(@NotNull KtLoopExpression $receiver) {
        return $receiver.getLeftParenthesis() != null && $receiver.getRightParenthesis() != null;
    }
}

