/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinIndentOptionsEditor;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$WhenMappings;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$10;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$11;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$12;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$13;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$14;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$2;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$3;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$4;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$5;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$6;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$7;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$8;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider$customizeSettings$9;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "()V", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getCodeSample", "", "getDefaultCommonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "getLanguage", "Lorg/jetbrains/kotlin/idea/KotlinLanguage;", "kotlin.jvm.PlatformType", "getLanguageName", "idea"})
public final class KotlinLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public KotlinLanguage getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)settingsType, (String)"settingsType");
        switch (KotlinLanguageCodeStyleSettingsProvider$WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                string = StringsKt.trimIndent((String)"\n               @Deprecated(\"Foo\") public class ThisIsASampleClass : Comparable<*>, Appendable {\n                   val test =\n                       12\n\n                   @Deprecated(\"Foo\") fun foo1(i1: Int, i2: Int, i3: Int) : Int {\n                       when (i1) {\n                           is Number -> 0\n                           else -> 1\n                       }\n                       return 0\n                   }\n                   private fun foo2():Int {\n               // todo: something\n                       try {            return foo1(12, 13, 14)\n                       }        catch (e: Exception) {            return 0        }        finally {           if (true) {               return 1           }           else {               return 2           }        }    }\n                   private val f = {(a: Int)->a*2}\n\n                   fun longMethod(@Named(\"param1\") param1: Int,\n                    param2: String) {\n                       @Deprecated val foo = 1\n                   }\n               }\n\n               @Deprecated val bar = 1\n\n               enum class Enumeration {\n                   A, B\n               }\n            ");
                break;
            }
            case 2: {
                string = StringsKt.trimIndent((String)"\n                class Foo {\n                   private var field1: Int = 1\n                   private val field2: String? = null\n\n\n                   init {\n                       field1 = 2;\n                   }\n\n                   fun foo1() {\n                       run {\n\n\n\n                           field1\n                       }\n\n                       when(field1) {\n                           1 -> println(\"1\")\n                           2 -> println(\"2\")\n                           3 ->\n                                println(\"3\" +\n                                     \"4\")\n                       }\n\n                       when(field2) {\n                           1 -> {\n                               println(\"1\")\n                           }\n\n                           2 -> {\n                               println(\"2\")\n                           }\n                       }\n                   }\n\n\n                   class InnerClass {\n                   }\n               }\n\n\n\n               class AnotherClass {\n               }\n\n               interface TestInterface {\n               }\n               fun run(f: () -> Unit) {\n                   f()\n               }");
                break;
            }
            default: {
                string = StringsKt.trimIndent((String)"open class Some {\n                       private val f: (Int)->Int = { (a: Int) -> a * 2 }\n                       fun foo(): Int {\n                           val test: Int = 12\n                           for (i in 10..42) {\n                               println (when {\n                                   i < test -> -1\n                                   i > test -> 1\n                                   else -> 0\n                               })\n                           }\n                           if (true) { }\n                           while (true) { break }\n                           try {\n                               when (test) {\n                                   12 -> println(\"foo\")\n                                   else -> println(\"bar\")\n                               }\n                           } catch (e: Exception) {\n                           } finally {\n                           }\n                           return test\n                       }\n                       private fun <T>foo2(): Int where T : List<T> {\n                           return 0\n                       }\n\n                       fun multilineMethod(\n                           foo: String,\n                           bar: String\n                       ) {\n                           foo\n                               .length\n                       }\n\n                       fun expressionBodyMethod() =\n                               \"abc\"\n                   }\n                   class AnotherClass<T : Any> : Some()\n                   ");
            }
        }
        return string;
    }

    @NotNull
    public String getLanguageName() {
        return "Kotlin";
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkParameterIsNotNull((Object)consumer2, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)settingsType, (String)"settingsType");
        Function3 showCustomOption$ = new Function3<KProperty<?>, String, String, Unit>(consumer2){
            final /* synthetic */ CodeStyleSettingsCustomizable $consumer;

            public final void invoke(@NotNull KProperty<?> field2, @NotNull String title, @Nullable String groupName) {
                Intrinsics.checkParameterIsNotNull(field2, (String)"field");
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                this.$consumer.showCustomOption(KotlinCodeStyleSettings.class, field2.getName(), title, groupName, new Object[0]);
            }

            public static /* bridge */ /* synthetic */ void invoke$default(customizeSettings.1 var0, KProperty kProperty, String string, String string2, int n, Object object) {
                if ((n & 4) != 0) {
                    string2 = null;
                }
                var0.invoke(kProperty, string, string2);
            }
            {
                this.$consumer = codeStyleSettingsCustomizable;
                super(3);
            }
        };
        switch (KotlinLanguageCodeStyleSettingsProvider$WhenMappings.$EnumSwitchMapping$1[settingsType.ordinal()]) {
            case 1: {
                consumer2.showStandardOptions(new String[]{"SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES"});
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$2.INSTANCE, "Range operator (..)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$3.INSTANCE, "Before colon, after declaration name", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$4.INSTANCE, "After colon, before declaration type", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$5.INSTANCE, "Before colon in new type definition", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$6.INSTANCE, "After colon in new type definition", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$7.INSTANCE, "In simple one line methods", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$8.INSTANCE, "Around arrow in function types", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$9.INSTANCE, "Around arrow in \"when\" clause", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$10.INSTANCE, "Before lambda arrow", CodeStyleSettingsCustomizable.SPACES_OTHER);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$11.INSTANCE, "'when' parentheses", CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES);
                break;
            }
            case 2: {
                consumer2.showStandardOptions(new String[]{"KEEP_FIRST_COLUMN_COMMENT", "KEEP_LINE_BREAKS", "ALIGN_MULTILINE_EXTENDS_LIST", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_METHOD_BRACKETS", "ALIGN_MULTILINE_BINARY_OPERATION", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "CALL_PARAMETERS_WRAP", "METHOD_PARAMETERS_WRAP", "EXTENDS_LIST_WRAP", "METHOD_ANNOTATION_WRAP", "CLASS_ANNOTATION_WRAP", "PARAMETER_ANNOTATION_WRAP", "VARIABLE_ANNOTATION_WRAP", "FIELD_ANNOTATION_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ENUM_CONSTANTS_WRAP"});
                consumer2.renameStandardOption(CodeStyleSettingsCustomizable.WRAPPING_SWITCH_STATEMENT, "'when' statements");
                consumer2.renameStandardOption("FIELD_ANNOTATION_WRAP", "Property annotations");
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$12.INSTANCE, "Align 'when' branches in columns", CodeStyleSettingsCustomizable.WRAPPING_SWITCH_STATEMENT);
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$13.INSTANCE, "Put left brace on new line", CodeStyleSettingsCustomizable.WRAPPING_BRACES);
                break;
            }
            case 3: {
                consumer2.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_AFTER_CLASS_HEADER"});
                showCustomOption$.invoke((KProperty)KotlinLanguageCodeStyleSettingsProvider$customizeSettings$14.INSTANCE, "Around 'when' branches with {}", CodeStyleSettingsCustomizable.BLANK_LINES);
                break;
            }
            default: {
                consumer2.showStandardOptions(new String[0]);
            }
        }
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new KotlinIndentOptionsEditor();
    }

    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings;
        CommonCodeStyleSettings $receiver = commonCodeStyleSettings = new CommonCodeStyleSettings((Language)this.getLanguage());
        $receiver.initIndentOptions();
        return commonCodeStyleSettings;
    }
}

