/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUIUtils {
    private FileUIUtils() {
    }

    @Nullable
    public static File copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull String destinationFolder, @NotNull File file2) {
        if (messagesTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagesTitle", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "copyWithOverwriteDialog"));
        }
        if (destinationFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destinationFolder", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "copyWithOverwriteDialog"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "copyWithOverwriteDialog"));
        }
        Map<File, File> copiedFiles = FileUIUtils.copyWithOverwriteDialog(messagesTitle, (Map<File, String>)ImmutableMap.of((Object)file2, (Object)destinationFolder));
        if (copiedFiles == null) {
            return null;
        }
        File copy = copiedFiles.get(file2);
        assert (copy != null);
        return copy;
    }

    @Nullable
    public static Map<File, File> copyWithOverwriteDialog(@NotNull String messagesTitle, @NotNull Map<File, String> filesWithDestinations) {
        String destinationPath;
        if (messagesTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagesTitle", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "copyWithOverwriteDialog"));
        }
        if (filesWithDestinations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesWithDestinations", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "copyWithOverwriteDialog"));
        }
        HashSet<String> fileNames = new HashSet<String>();
        LinkedHashMap<File, File> targetFiles = new LinkedHashMap<File, File>(filesWithDestinations.size());
        for (Map.Entry<File, String> sourceToDestination : filesWithDestinations.entrySet()) {
            File file2 = sourceToDestination.getKey();
            destinationPath = sourceToDestination.getValue();
            String fileName = file2.getName();
            if (!fileNames.add(fileName)) {
                throw new IllegalArgumentException("There are several files with the same name: " + fileName);
            }
            targetFiles.put(file2, new File(destinationPath, fileName));
        }
        List existentFiles = CollectionsKt.filter(targetFiles.entrySet(), sourceToTarget -> ((File)sourceToTarget.getValue()).exists());
        if (!existentFiles.isEmpty()) {
            String message2;
            if (existentFiles.size() == 1) {
                File conflictingFile = (File)((Map.Entry)existentFiles.iterator().next()).getValue();
                message2 = String.format("File \"%s\" already exists in %s.\nDo you want to overwrite it?", conflictingFile.getName(), conflictingFile.getParentFile().getAbsolutePath());
            } else {
                List conflictFiles = CollectionsKt.map((Iterable)existentFiles, Map.Entry::getValue);
                message2 = String.format("Files already exist:\n%s\nDo you want to overwrite them?", StringUtil.join((Iterable)conflictFiles, (String)"\n"));
            }
            int replaceIfExist = Messages.showYesNoDialog(null, (String)message2, (String)(messagesTitle + ". Replace File"), (String)"Overwrite", (String)"Cancel", (Icon)Messages.getWarningIcon());
            if (replaceIfExist != 0) {
                return null;
            }
        }
        for (Map.Entry sourceToTarget2 : targetFiles.entrySet()) {
            try {
                destinationPath = ((File)sourceToTarget2.getValue()).getParentFile().getAbsolutePath();
                if (!ProjectWizardUtil.createDirectoryIfNotExists((String)"Destination folder", (String)destinationPath, (boolean)false)) {
                    Messages.showErrorDialog((String)String.format("Error during folder creating '%s'", destinationPath), (String)(messagesTitle + ". Error"));
                    return null;
                }
                FileUtil.copy((File)((File)sourceToTarget2.getKey()), (File)((File)sourceToTarget2.getValue()));
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile((File)sourceToTarget2.getValue());
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)("Error with copy file " + ((File)sourceToTarget2.getKey()).getName()), (String)(messagesTitle + ". Error"));
                return null;
            }
        }
        return targetFiles;
    }

    @NotNull
    public static String createRelativePath(@Nullable Project project, @Nullable VirtualFile contextDirectory, String relativePath) {
        String path = null;
        if (contextDirectory != null) {
            path = PathUtil.getLocalPath((VirtualFile)contextDirectory);
        } else if (project != null) {
            path = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
        }
        path = path != null ? new File(path, relativePath).getAbsolutePath() : "";
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/FileUIUtils", "createRelativePath"));
        }
        return string;
    }
}

