/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

public abstract class CalleeReferenceVisitorBase
extends KtTreeVisitorVoid {
    private final BindingContext bindingContext;
    private final boolean deepTraversal;

    protected CalleeReferenceVisitorBase(BindingContext bindingContext2, boolean deepTraversal) {
        this.bindingContext = bindingContext2;
        this.deepTraversal = deepTraversal;
    }

    protected abstract void processDeclaration(@NotNull KtSimpleNameExpression var1, @NotNull PsiElement var2);

    @Override
    public void visitKtElement(@NotNull KtElement element3) {
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/CalleeReferenceVisitorBase", "visitKtElement"));
        }
        if (this.deepTraversal || !(element3 instanceof KtClassOrObject) && !(element3 instanceof KtNamedFunction)) {
            super.visitKtElement(element3);
        }
    }

    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/hierarchy/calls/CalleeReferenceVisitorBase", "visitSimpleNameExpression"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (descriptor2 == null) {
            return;
        }
        PsiElement declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declaration2 == null) {
            return;
        }
        if (CalleeReferenceVisitorBase.isProperty(descriptor2, declaration2) || CalleeReferenceVisitorBase.isCallable(descriptor2, declaration2, expression2)) {
            this.processDeclaration(expression2, declaration2);
        }
    }

    private static boolean isCallable(DeclarationDescriptor descriptor2, PsiElement declaration2, KtSimpleNameExpression reference2) {
        KtCallElement callElement2 = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)reference2, KtCallElement.class);
        if (callElement2 == null || !PsiTreeUtil.isAncestor((PsiElement)callElement2.getCalleeExpression(), (PsiElement)reference2, (boolean)false)) {
            return false;
        }
        return descriptor2 instanceof FunctionDescriptor && (declaration2 instanceof KtClassOrObject || declaration2 instanceof KtNamedFunction || declaration2 instanceof PsiMethod);
    }

    private static boolean isProperty(DeclarationDescriptor descriptor2, PsiElement declaration2) {
        return descriptor2 instanceof PropertyDescriptor && declaration2 instanceof KtProperty;
    }
}

