/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.actions.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeToolWindow;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl;", "Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerService;", "()V", "bytecodeMapForExistingClassfile", "", "Ljava/io/File;", "Lkotlin/Function0;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "bytecodeMapForSourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "decompile", "", "KotlinResultSaver", "idea-jvm"})
public final class KotlinDecompilerServiceImpl
implements KotlinDecompilerService {
    @Override
    @Nullable
    public String decompile(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        try {
            Map<File, Function0<byte[]>> map2;
            if (DecompileKotlinToJavaActionKt.canBeDecompiledToJava(file2)) {
                VirtualFile virtualFile2 = file2.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
                map2 = this.bytecodeMapForExistingClassfile(virtualFile2);
            } else if (!file2.isCompiled()) {
                map2 = this.bytecodeMapForSourceFile(file2);
            } else {
                return null;
            }
            Map<File, Function0<byte[]>> bytecodeMap = map2;
            KotlinResultSaver resultSaver = new KotlinResultSaver();
            HashMap options2 = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"rbr", (Object)"0")});
            IBytecodeProvider bytecodeProvider2 = new IBytecodeProvider(bytecodeMap){
                final /* synthetic */ Map $bytecodeMap;

                @Nullable
                public final byte[] getBytecode(String externalPath, String $noName_1) {
                    File path = new File(FileUtil.toSystemIndependentName((String)externalPath));
                    Function0 function0 = (Function0)this.$bytecodeMap.get(path);
                    return (byte[])(function0 != null ? (byte[])function0.invoke() : null);
                }
                {
                    this.$bytecodeMap = map2;
                }
            };
            BaseDecompiler decompiler = new BaseDecompiler(bytecodeProvider2, (IResultSaver)resultSaver, (Map)options2, (IFernflowerLogger)new IdeaLogger());
            for (File path : bytecodeMap.keySet()) {
                decompiler.addSpace(path, true);
            }
            decompiler.decompileContext();
            return resultSaver.getResultText();
        }
        catch (IdeaLogger.InternalException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            throw (Throwable)new DecompileFailedException(string, ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForExistingClassfile(VirtualFile file2) {
        void $receiver$iv$iv;
        VirtualFile it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        String mask = "" + file2.getNameWithoutExtension() + '$';
        Object[] objectArray = file2.getParent().getChildren();
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)file2.getPath(), (Object)file2));
        void var5_5 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
            void element$iv$iv = $receiver$iv$iv2[i];
            it = (VirtualFile)element$iv$iv;
            if (!(StringsKt.startsWith$default((String)it.getNameWithoutExtension(), (String)mask, (boolean)false, (int)2, null) && it.getFileType() == StdFileTypes.CLASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Pair> collection = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            Pair pair2 = TuplesKt.to((Object)it.getPath(), (Object)it);
            collection.add(pair2);
        }
        collection = (List)destination$iv$iv;
        Map files2 = MapsKt.plus((Map)map2, (Iterable)collection);
        $receiver$iv = files2.entrySet();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map3 = destination$iv$iv2;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            Pair pair3 = new Pair((Object)new File((String)it2.getKey()), (Object)new Function0<byte[]>(it2){
                final /* synthetic */ Map.Entry $it;

                @NotNull
                public final byte[] invoke() {
                    return ((VirtualFile)this.$it.getValue()).contentsToByteArray(false);
                }
                {
                    this.$it = entry;
                    super(0);
                }
            });
            map3.put(pair3.getFirst(), pair3.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForSourceFile(KtFile file2) {
        void $receiver$iv$iv;
        CompilerConfiguration compilerConfiguration;
        CompilerConfiguration $receiver = compilerConfiguration = new CompilerConfiguration();
        CommonConfigurationKeysKt.setLanguageVersionSettings($receiver, PlatformKt.getLanguageVersionSettings(file2));
        CompilerConfiguration configuration2 = compilerConfiguration;
        GenerationState generationState = KotlinBytecodeToolWindow.compileSingleFile(file2, configuration2);
        HashMap bytecodeMap = new HashMap();
        Iterable $receiver$iv = generationState.getFactory().asList();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            OutputFile it = (OutputFile)element$iv$iv;
            if (!FileUtilRt.extensionEquals((String)it.getRelativePath(), (String)"class")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            File file3;
            OutputFile it = (OutputFile)element$iv;
            Map map2 = bytecodeMap;
            Intrinsics.checkExpressionValueIsNotNull((Object)new File('/' + it.getRelativePath()).getAbsoluteFile(), (String)"File(\"/${it.relativePath}\").absoluteFile");
            Function0<byte[]> function0 = new Function0<byte[]>(it){
                final /* synthetic */ OutputFile $it;

                @NotNull
                public final byte[] invoke() {
                    return this.$it.asByteArray();
                }
                {
                    this.$it = outputFile;
                    super(0);
                }
            };
            map2.put(file3, function0);
        }
        return bytecodeMap;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J0\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0010\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J:\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J:\u0010\u0018\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl$KotlinResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "decompiledText", "", "", "resultText", "getResultText", "()Ljava/lang/String;", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "", "saveDirEntry", "saveFolder", "idea-jvm"})
    public static final class KotlinResultSaver
    implements IResultSaver {
        private final Map<String, String> decompiledText;

        @NotNull
        public final String getResultText() {
            StringBuilder stringBuilder;
            String string = (String)CollectionsKt.singleOrNull((Iterable)this.decompiledText.values());
            if (string != null) {
                String string2;
                String it = string2 = string;
                return it;
            }
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            Map<String, String> $i$a$1$let = this.decompiledText;
            for (Map.Entry<String, String> entry : $i$a$1$let.entrySet()) {
                Object object = entry;
                String filename = object.getKey();
                object = entry;
                String content2 = object.getValue();
                object = $receiver;
                String string3 = "// " + filename;
                StringsKt.appendln((StringBuilder)((StringBuilder)object).append(string3));
                $receiver.append(content2);
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            return string4;
        }

        public void saveFolder(@Nullable String path) {
        }

        public void closeArchive(@Nullable String path, @Nullable String archiveName) {
        }

        public void copyEntry(@Nullable String source, @Nullable String path, @Nullable String archiveName, @Nullable String entry) {
        }

        public void createArchive(@Nullable String path, @Nullable String archiveName, @Nullable Manifest manifest) {
        }

        public void saveClassFile(@Nullable String path, @Nullable String qualifiedName2, @Nullable String entryName, @Nullable String content2, @Nullable int[] mapping2) {
            if (entryName != null && content2 != null) {
                Map<String, String> map2 = this.decompiledText;
                String string = content2;
                map2.put(entryName, string);
            }
        }

        public void copyFile(@Nullable String source, @Nullable String path, @Nullable String entryName) {
        }

        public void saveClassEntry(@Nullable String path, @Nullable String archiveName, @Nullable String qualifiedName2, @Nullable String entryName, @Nullable String content2) {
        }

        public void saveDirEntry(@Nullable String path, @Nullable String archiveName, @Nullable String entryName) {
        }

        public KotlinResultSaver() {
            Map map2;
            KotlinResultSaver kotlinResultSaver = this;
            kotlinResultSaver.decompiledText = map2 = (Map)new LinkedHashMap();
        }
    }
}

