/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "expression", "operation", "", "notNullNeeded", "", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Ljava/lang/String;Z)V", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "idea"})
public abstract class ReplaceCallFix
extends KotlinQuickFixAction<KtQualifiedExpression> {
    private final String operation;
    private final boolean notNullNeeded;

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)this.getElement();
        if (ktQualifiedExpression == null) {
            return false;
        }
        KtQualifiedExpression element3 = ktQualifiedExpression;
        return super.isAvailable(project, editor, file2) && element3.getSelectorExpression() != null;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)this.getElement();
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression element3 = ktQualifiedExpression;
        String elvis2 = ReplaceCallFixUtilsKt.elvisOrEmpty(this.notNullNeeded);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        String string = "$0" + this.operation + "$1" + elvis2;
        Object[] objectArray = new Object[2];
        objectArray[0] = element3.getReceiverExpression();
        KtExpression ktExpression = element3.getSelectorExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        objectArray[1] = ktExpression;
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, string, objectArray, false, 4, null);
        PsiElement replacement = element3.replace((PsiElement)newExpression2);
        if (this.notNullNeeded) {
            ReplaceCallFixUtilsKt.moveCaretToEnd(replacement, editor, project);
        }
    }

    public ReplaceCallFix(@NotNull KtQualifiedExpression expression2, @NotNull String operation, boolean notNullNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        super((PsiElement)expression2);
        this.operation = operation;
        this.notNullNeeded = notNullNeeded;
    }

    public /* synthetic */ ReplaceCallFix(KtQualifiedExpression ktQualifiedExpression, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(ktQualifiedExpression, string, bl);
    }
}

