/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J9\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0004H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinParameterProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "isToSearchInComments", "psiElement", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchInComments", "enabled", "idea"})
public final class RenameKotlinParameterProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtParameter && ((KtParameter)element3).getOwnerFunction() instanceof KtFunction;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    public void findCollisions(@NotNull PsiElement element3, @Nullable String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (newName2 == null) {
            return;
        }
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement(element3);
        if (!(psiNamedElement instanceof KtNamedDeclaration)) {
            psiNamedElement = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiNamedElement;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor$default(declaration2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        }
        VariableDescriptor descriptor2 = (VariableDescriptor)declarationDescriptor;
        SmartList collisions = new SmartList();
        RenameConflictUtilsKt.checkRedeclarations(descriptor2, newName2, collisions);
        RenameConflictUtilsKt.checkOriginalUsagesRetargeting(declaration2, newName2, result2, collisions);
        RenameConflictUtilsKt.checkNewNameUsagesRetargeting(declaration2, newName2, collisions);
        Collection collection = result2;
        CollectionsKt.addAll((Collection)collection, (Iterable)collisions);
    }

    public void renameElement(@NotNull PsiElement element3, @Nullable String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        super.renameElement(element3, newName2, usages2, listener2);
        Object[] $receiver$iv = usages2;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            UsageInfo it = (UsageInfo)element$iv;
            UsageInfo usageInfo = it;
            if (!(usageInfo instanceof KtResolvableCollisionUsageInfo)) {
                usageInfo = null;
            }
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = (KtResolvableCollisionUsageInfo)usageInfo;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }
}

