/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.util;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsNode;

public final class AstUtil {
    private AstUtil() {
    }

    @Nullable
    public static <T extends JsNode> T deepCopy(@Nullable T node) {
        if (node == null) {
            return null;
        }
        return (T)node.deepCopy();
    }

    @NotNull
    public static <T extends JsNode> List<T> deepCopy(@Nullable List<T> nodes) {
        if (nodes == null) {
            SmartList smartList = new SmartList();
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/util/AstUtil", "deepCopy"));
            }
            return smartList;
        }
        ArrayList<JsNode> nodesCopy = new ArrayList<JsNode>(nodes.size());
        for (JsNode node : nodes) {
            nodesCopy.add(AstUtil.deepCopy(node));
        }
        ArrayList<JsNode> arrayList = nodesCopy;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/util/AstUtil", "deepCopy"));
        }
        return arrayList;
    }
}

