/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtModifierListOwnerStub<T extends StubElement<?>>
extends KtElementImplStub<T>
implements KtModifierListOwner {
    public KtModifierListOwnerStub(ASTNode node) {
        super(node);
    }

    public KtModifierListOwnerStub(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public KtModifierList getModifierList() {
        return (KtModifierList)this.getStubOrPsiChild(KtStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "hasModifier"));
        }
        KtModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(modifier);
    }

    @Override
    public void addModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "addModifier"));
        }
        AddRemoveModifierKt.addModifier(this, modifier);
    }

    @Override
    public void removeModifier(@NotNull KtModifierKeywordToken modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "removeModifier"));
        }
        AddRemoveModifierKt.removeModifier(this, modifier);
    }

    @Override
    @NotNull
    public KtAnnotationEntry addAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2) {
        if (annotationEntry2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "addAnnotationEntry"));
        }
        KtAnnotationEntry ktAnnotationEntry = AddRemoveModifierKt.addAnnotationEntry(this, annotationEntry2);
        if (ktAnnotationEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "addAnnotationEntry"));
        }
        return ktAnnotationEntry;
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getAnnotationEntries() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<KtAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "getAnnotationEntries"));
            }
            return list2;
        }
        List<KtAnnotationEntry> list3 = modifierList.getAnnotationEntries();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "getAnnotationEntries"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<KtAnnotation> getAnnotations() {
        KtModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            List<KtAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "getAnnotations"));
            }
            return list2;
        }
        List<KtAnnotation> list3 = modifierList.getAnnotations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtModifierListOwnerStub", "getAnnotations"));
        }
        return list3;
    }
}

