/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.ir.SourceManager;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0014\u0010\u0012\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ModuleGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "createEmptyIrFile", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFileImpl;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "generateFiles", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ktFiles", "", "generateModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "generateModuleFragmentWithoutDependencies", "generateSingleFile", "irDeclarationGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "generateUnboundSymbolsAsDependencies", "", "irModule", "ir.psi2ir"})
public final class ModuleGenerator
implements Generator {
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final IrModuleFragment generateModuleFragment(@NotNull Collection<? extends KtFile> ktFiles2) {
        IrModuleFragment irModuleFragment;
        Intrinsics.checkParameterIsNotNull(ktFiles2, (String)"ktFiles");
        IrModuleFragment irModule = irModuleFragment = this.generateModuleFragmentWithoutDependencies(ktFiles2);
        this.generateUnboundSymbolsAsDependencies(irModule);
        return irModuleFragment;
    }

    @NotNull
    public final IrModuleFragment generateModuleFragmentWithoutDependencies(@NotNull Collection<? extends KtFile> ktFiles2) {
        IrModuleFragmentImpl irModuleFragmentImpl;
        Intrinsics.checkParameterIsNotNull(ktFiles2, (String)"ktFiles");
        IrModuleFragmentImpl irModule = irModuleFragmentImpl = new IrModuleFragmentImpl(this.getContext().getModuleDescriptor(), this.getContext().getIrBuiltIns());
        irModule.getFiles().addAll((Collection<IrFile>)this.generateFiles(ktFiles2));
        return irModuleFragmentImpl;
    }

    private final void generateUnboundSymbolsAsDependencies(IrModuleFragment irModule) {
        new ExternalDependenciesGenerator(this.getContext().getSymbolTable(), this.getContext().getIrBuiltIns()).generateUnboundSymbolsAsDependencies(irModule);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrFile> generateFiles(Collection<? extends KtFile> ktFiles2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        DeclarationGenerator irDeclarationGenerator = new DeclarationGenerator(this.getContext());
        Iterable iterable = $receiver$iv = (Iterable)ktFiles2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void ktFile;
            KtFile ktFile2 = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            IrFileImpl irFileImpl = this.generateSingleFile(irDeclarationGenerator, (KtFile)ktFile);
            collection.add(irFileImpl);
        }
        return (List)destination$iv$iv;
    }

    private final IrFileImpl generateSingleFile(DeclarationGenerator irDeclarationGenerator, KtFile ktFile) {
        IrFileImpl irFile = this.createEmptyIrFile(ktFile);
        for (KtAnnotationEntry ktAnnotationEntry : ktFile.getAnnotationEntries()) {
            List<AnnotationDescriptor> list2 = irFile.getFileAnnotations();
            WritableSlice<KtAnnotationEntry, AnnotationDescriptor> writableSlice = BindingContext.ANNOTATION;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.ANNOTATION");
            Object v = GeneratorKt.getOrFail(this, writableSlice, ktAnnotationEntry);
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"getOrFail(BindingContext\u2026ATION, ktAnnotationEntry)");
            list2.add((AnnotationDescriptor)v);
        }
        for (KtDeclaration ktDeclaration : ktFile.getDeclarations()) {
            irFile.getDeclarations().add(irDeclarationGenerator.generateMemberDeclaration(ktDeclaration));
        }
        return irFile;
    }

    private final IrFileImpl createEmptyIrFile(KtFile ktFile) {
        PsiSourceManager.PsiFileEntry fileEntry = this.getContext().getSourceManager().getOrCreateFileEntry(ktFile);
        WritableSlice<KtFile, PackageFragmentDescriptor> writableSlice = BindingContext.FILE_TO_PACKAGE_FRAGMENT;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.FILE_TO_PACKAGE_FRAGMENT");
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktFile);
        SourceManager.FileEntry fileEntry2 = fileEntry;
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)packageFragmentDescriptor2, (String)"packageFragmentDescriptor");
        IrFileImpl irFile = new IrFileImpl(fileEntry2, packageFragmentDescriptor2);
        this.getContext().getSourceManager().putFileEntry(irFile, fileEntry);
        return irFile;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public ModuleGenerator(@NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

