/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.types.KotlinType;

public class TracingStrategyForInvoke
extends AbstractTracingStrategy {
    private final KotlinType calleeType;

    public TracingStrategyForInvoke(@NotNull KtExpression reference2, @NotNull Call call2, @NotNull KotlinType calleeType) {
        if (reference2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        if (calleeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeType", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "<init>"));
        }
        super(reference2, call2);
        this.calleeType = calleeType;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindCall"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindCall"));
        }
        if (this.reference instanceof KtSimpleNameExpression) {
            return;
        }
        trace.record(BindingContext.CALL, this.reference, call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindReference"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindReference"));
        }
        KtElement callElement2 = this.call.getCallElement();
        if (callElement2 instanceof KtReferenceExpression) {
            trace.record(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)callElement2, resolvedCall2.getCandidateDescriptor());
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindResolvedCall"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "bindResolvedCall"));
        }
        if (this.reference instanceof KtSimpleNameExpression) {
            return;
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReference"));
        }
        this.functionExpectedOrNoReceiverAllowed(trace);
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReferenceWrongReceiver"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke", "unresolvedReferenceWrongReceiver"));
        }
        this.functionExpectedOrNoReceiverAllowed(trace);
    }

    private void functionExpectedOrNoReceiverAllowed(BindingTrace trace) {
        if (FunctionTypesKt.isNonExtensionFunctionType(this.calleeType)) {
            trace.report(Errors.NO_RECEIVER_ALLOWED.on(this.reference));
        } else {
            trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, this.calleeType));
        }
    }
}

