/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class TracingStrategyImpl
extends AbstractTracingStrategy {
    private final KtReferenceExpression reference;

    private TracingStrategyImpl(@NotNull KtReferenceExpression reference2, @NotNull Call call2) {
        if (reference2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "<init>"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "<init>"));
        }
        super(reference2, call2);
        this.reference = reference2;
    }

    @NotNull
    public static TracingStrategy create(@NotNull KtReferenceExpression reference2, @NotNull Call call2) {
        if (reference2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        TracingStrategyImpl tracingStrategyImpl = new TracingStrategyImpl(reference2, call2);
        if (tracingStrategyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        return tracingStrategyImpl;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindCall"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindCall"));
        }
        trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        DeclarationDescriptor storedReference;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindReference"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindReference"));
        }
        Object descriptor2 = resolvedCall2.getCandidateDescriptor();
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            descriptor2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCandidateDescriptor();
        }
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            FakeCallableDescriptorForObject fakeCallableDescriptorForObject = (FakeCallableDescriptorForObject)descriptor2;
            descriptor2 = fakeCallableDescriptorForObject.getReferencedDescriptor();
            if (fakeCallableDescriptorForObject.getClassDescriptor().getCompanionObjectDescriptor() != null) {
                trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, this.reference, fakeCallableDescriptorForObject.getClassDescriptor());
            }
        }
        if ((storedReference = trace.get(BindingContext.REFERENCE_TARGET, this.reference)) == null || !ErrorUtils.isError(descriptor2)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.reference, descriptor2);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindResolvedCall"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "bindResolvedCall"));
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReference"));
        }
        trace.report(Errors.UNRESOLVED_REFERENCE.on(this.reference, this.reference));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReferenceWrongReceiver"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReferenceWrongReceiver"));
        }
        VariableDescriptor variableDescriptor = TracingStrategyImpl.isFunctionExpectedError(candidates2);
        if (variableDescriptor != null) {
            trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, variableDescriptor.getType()));
        } else {
            trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on((PsiElement)this.reference, candidates2));
        }
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor isFunctionExpectedError(@NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "isFunctionExpectedError"));
        }
        List variables = CollectionsKt.map(candidates2, TracingStrategyImpl::variableIfFunctionExpectedError);
        List distinctVariables = CollectionsKt.distinct((Iterable)variables);
        return (VariableDescriptor)CollectionsKt.singleOrNull((List)distinctVariables);
    }

    @Nullable
    private static <D extends CallableDescriptor> VariableDescriptor variableIfFunctionExpectedError(@NotNull ResolvedCall<D> candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyImpl", "variableIfFunctionExpectedError"));
        }
        if (!(candidate instanceof VariableAsFunctionResolvedCall)) {
            return null;
        }
        ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)candidate)).getVariableCall();
        ResolvedCall<FunctionDescriptor> functionCall = ((VariableAsFunctionResolvedCall)((Object)candidate)).getFunctionCall();
        KotlinType type2 = variableCall.getCandidateDescriptor().getType();
        boolean nonFunctionalVar = variableCall.getStatus().isSuccess() && !FunctionTypesKt.isFunctionType(type2);
        Call functionPsiCall = functionCall.getCall();
        if (nonFunctionalVar && CallResolverUtilKt.isInvokeCallOnVariable(functionPsiCall) && functionPsiCall.getValueArguments().isEmpty()) {
            return variableCall.getCandidateDescriptor();
        }
        return null;
    }
}

