/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

public class FileBasedDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, @NotNull Collection<KtFile> files2) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        super(storageManager);
        this.storageManager = storageManager;
        this.index = storageManager.createLazyValue(() -> {
            if (files2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "lambda$new$0"));
            }
            return FileBasedDeclarationProviderFactory.computeFilesByPackage(files2);
        });
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<KtFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        Index index2 = new Index();
        for (KtFile file2 : files2) {
            FqName packageFqName = file2.getPackageFqName();
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, packageFqName);
            index2.filesByPackage.put((Object)packageFqName, (Object)file2);
        }
        Index index3 = index2;
        if (index3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        return index3;
    }

    private static void addMeAndParentPackages(@NotNull Index index2, @NotNull FqName name2) {
        if (index2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        index2.declaredPackages.add(name2);
        if (!name2.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, name2.parent());
        }
    }

    private boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "isPackageDeclaredExplicitly"));
        }
        return ((Index)this.index.invoke()).declaredPackages.contains(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(@NotNull FqName parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getAllDeclaredSubPackagesOf"));
        }
        return CollectionsKt.filter((Iterable)((Index)this.index.invoke()).declaredPackages, fqName2 -> {
            if (parent2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "lambda$getAllDeclaredSubPackagesOf$1"));
            }
            return !fqName2.isRoot() && fqName2.parent().equals(parent2);
        });
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "createPackageMemberDeclarationProvider"));
        }
        if (this.isPackageDeclaredExplicitly(packageFqName)) {
            return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, ((Index)this.index.invoke()).filesByPackage.get((Object)packageFqName));
        }
        return null;
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        if (!((Index)this.index.invoke()).filesByPackage.containsKey((Object)classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        PsiBasedClassMemberDeclarationProvider psiBasedClassMemberDeclarationProvider = new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
        if (psiBasedClassMemberDeclarationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        return psiBasedClassMemberDeclarationProvider;
    }

    private static class Index {
        private final Multimap<FqName, KtFile> filesByPackage = LinkedHashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

