/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

public class ExtensionReceiver
extends AbstractReceiverValue
implements ImplicitReceiver {
    private final CallableDescriptor descriptor;

    public ExtensionReceiver(@NotNull CallableDescriptor callableDescriptor, @NotNull KotlinType receiverType2) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver", "<init>"));
        }
        if (receiverType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver", "<init>"));
        }
        super(receiverType2);
        this.descriptor = callableDescriptor;
    }

    @Override
    @NotNull
    public CallableDescriptor getDeclarationDescriptor() {
        CallableDescriptor callableDescriptor = this.descriptor;
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver", "getDeclarationDescriptor"));
        }
        return callableDescriptor;
    }

    @Override
    @NotNull
    public ReceiverValue replaceType(@NotNull KotlinType newType) {
        if (newType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newType", "org/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver", "replaceType"));
        }
        ExtensionReceiver extensionReceiver = new ExtensionReceiver(this.descriptor, newType);
        if (extensionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/scopes/receivers/ExtensionReceiver", "replaceType"));
        }
        return extensionReceiver;
    }

    public String toString() {
        return this.getType() + ": Ext {" + this.descriptor + "}";
    }
}

