/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001>B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eH\u0002J(\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002J0\u0010#\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J8\u0010%\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010*\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J8\u0010-\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000702H\u0002J4\u00103\u001a\u0002042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u00105\u001a\u0004\u0018\u00010\u000f2\u0006\u00106\u001a\u00020\u00182\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00108\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u00109\u001a\u0002042\u0006\u0010\b\u001a\u00020:2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0018\u0010;\u001a\u0002042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010;\u001a\u0002042\u0006\u0010\b\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000b2\b\b\u0001\u0010<\u001a\u00020\u0018J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u0016022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "analyzeConditionsInWhenEntries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "contextAfterSubject", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "subjectDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "analyzeWhenEntryConditions", "Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$ConditionalDataFlowInfo;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "context", "subjectExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkSmartCastToExpectedTypeInSubject", "", "contextBeforeSubject", "expectedType", "checkSmartCastsInSubjectIfRequired", "", "possibleTypesForSubject", "", "checkTypeCompatibility", "type", "reportErrorOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkTypeForExpressionCondition", "conditionExpected", "checkTypeForIs", "isCheck", "negated", "typeReferenceAfterIs", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkWhenCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "detectRedundantIs", "targetType", "inferTypeForWhenExpression", "contextWithExpectedType", "dataFlowInfoForEntries", "", "joinWhenExpressionBranches", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "resultType", "jumpOutPossibleInSubject", "whenResultValue", "noChange", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitWhenExpression", "isStatement", "wrapWhenEntryExpressionsAsSpecialCallArguments", "ConditionalDataFlowInfo", "frontend"})
public final class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)contextWithExpectedType, (String)"contextWithExpectedType");
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftHandSide = expression2.getLeftHandSide();
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, context);
        KotlinType knownType = typeInfo.getType();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (typeReference != null && knownType != null) {
            KtExpression ktExpression = leftHandSide;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"leftHandSide");
            ExpressionTypingContext expressionTypingContext = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"context");
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(ktExpression, knownType, expressionTypingContext);
            DataFlowInfo conditionInfo = this.checkTypeForIs(context, expression2, expression2.isNegated(), knownType, typeReference, dataFlowValue).getThenInfo();
            DataFlowInfo newDataFlowInfo = conditionInfo.and(typeInfo.getDataFlowInfo());
            context.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2, newDataFlowInfo);
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getBooleanType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        if (typeReference != null) {
            KotlinType rhsType = (KotlinType)context.trace.get(BindingContext.TYPE, typeReference);
            KtExpression ktExpression = leftHandSide;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"leftHandSide");
            RttiExpressionInformation rttiInformation = new RttiExpressionInformation(ktExpression, knownType, rhsType, expression2.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
            Iterable<RttiExpressionChecker> $receiver$iv = this.components.rttiExpressionCheckers;
            Iterator<RttiExpressionChecker> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                RttiExpressionChecker element$iv;
                RttiExpressionChecker it = element$iv = iterator2.next();
                PsiElement psiElement2 = (PsiElement)expression2;
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
                it.check(rttiInformation, psiElement2, bindingTrace);
            }
        }
        KotlinTypeInfo kotlinTypeInfo = resultTypeInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo, (String)"resultTypeInfo");
        return kotlinTypeInfo;
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.visitWhenExpression(expression2, context, false);
    }

    @NotNull
    public final KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        DataFlowInfo resultDataFlowInfo;
        DataFlowInfo dataFlowInfo;
        DataFlowValue dataFlowValue;
        KotlinType whenReturnType;
        Set<KotlinType> set2;
        Object subjectDataFlowValue;
        boolean jumpOutPossibleInSubject;
        Object subjectType;
        Object contextAfterSubject;
        KotlinTypeInfo subjectTypeInfo;
        ExpressionTypingContext contextBeforeSubject;
        BindingTrace trace;
        block15: {
            Object object;
            block14: {
                KtExpression ktExpression;
                KtExpression it;
                Object object2;
                KtExpression it2;
                Object object3;
                KotlinTypeInfo kotlinTypeInfo;
                KtExpression it3;
                KtExpression subjectExpression;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)contextWithExpectedType, (String)"contextWithExpectedType");
                BindingTrace bindingTrace = trace = contextWithExpectedType.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"trace");
                WhenChecker.INSTANCE.checkDeprecatedWhenSyntax(bindingTrace, expression2);
                WhenChecker.INSTANCE.checkReservedPrefix(trace, expression2);
                this.components.dataFlowAnalyzer.recordExpectedType(trace, expression2, contextWithExpectedType.expectedType);
                contextBeforeSubject = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
                KtExpression ktExpression2 = subjectExpression = expression2.getSubjectExpression();
                if (ktExpression2 != null) {
                    KtExpression ktExpression3;
                    it3 = ktExpression3 = ktExpression2;
                    kotlinTypeInfo = this.facade.getTypeInfo(it3, contextBeforeSubject);
                } else {
                    kotlinTypeInfo = null;
                }
                if ((object3 = (subjectTypeInfo = kotlinTypeInfo)) == null || (object3 = (ExpressionTypingContext)contextBeforeSubject.replaceDataFlowInfo(((KotlinTypeInfo)((Object)(it2 = (it3 = object3)))).getDataFlowInfo())) == null) {
                    object3 = contextAfterSubject = contextBeforeSubject;
                }
                if ((object2 = subjectTypeInfo) == null || (object2 = ((KotlinTypeInfo)object2).getType()) == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("Unknown type");
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorType(\"Unknown type\")");
                    object2 = simpleType2;
                }
                subjectType = object2;
                KotlinTypeInfo kotlinTypeInfo2 = subjectTypeInfo;
                jumpOutPossibleInSubject = kotlinTypeInfo2 != null ? kotlinTypeInfo2.getJumpOutPossible() : false;
                object = subjectExpression;
                if (object == null) break block14;
                KtExpression ktExpression4 = it = (ktExpression = object);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"it");
                Object object4 = contextAfterSubject;
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"contextAfterSubject");
                object = DataFlowValueFactory.createDataFlowValue(ktExpression4, (KotlinType)subjectType, (ResolutionContext)object4);
                if (object != null) break block15;
            }
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuiltIns, (String)"components.builtIns");
            object = subjectDataFlowValue = DataFlowValue.Companion.nullValue(kotlinBuiltIns);
        }
        if ((set2 = subjectTypeInfo) == null || (set2 = ((KotlinTypeInfo)((Object)set2)).getDataFlowInfo()) == null || (set2 = set2.getStableTypes((DataFlowValue)subjectDataFlowValue)) == null) {
            set2 = SetsKt.emptySet();
        }
        Set<KotlinType> possibleTypesForSubject = set2;
        ExpressionTypingContext expressionTypingContext = contextBeforeSubject;
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"contextBeforeSubject");
        this.checkSmartCastsInSubjectIfRequired(expression2, expressionTypingContext, (KotlinType)subjectType, possibleTypesForSubject);
        Object object = contextAfterSubject;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"contextAfterSubject");
        ArrayList<DataFlowInfo> dataFlowInfoForEntries = this.analyzeConditionsInWhenEntries(expression2, (ExpressionTypingContext)object, (DataFlowValue)subjectDataFlowValue, (KotlinType)subjectType);
        KotlinType kotlinType = whenReturnType = this.inferTypeForWhenExpression(expression2, contextWithExpectedType, (ExpressionTypingContext)contextAfterSubject, (List<? extends DataFlowInfo>)dataFlowInfoForEntries);
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, it, (ResolutionContext)contextAfterSubject);
        } else {
            dataFlowValue = null;
        }
        DataFlowValue whenResultValue = dataFlowValue;
        KotlinTypeInfo branchesTypeInfo = this.joinWhenExpressionBranches(expression2, (ExpressionTypingContext)contextAfterSubject, whenReturnType, jumpOutPossibleInSubject, whenResultValue);
        boolean isExhaustive = WhenChecker.isWhenExhaustive(expression2, trace);
        DataFlowInfo branchesDataFlowInfo = branchesTypeInfo.getDataFlowInfo();
        if (expression2.getElseExpression() == null && !isExhaustive) {
            DataFlowInfo dataFlowInfo2 = ((ExpressionTypingContext)contextAfterSubject).dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo2, (String)"contextAfterSubject.dataFlowInfo");
            dataFlowInfo = branchesDataFlowInfo.or(dataFlowInfo2);
        } else {
            dataFlowInfo = resultDataFlowInfo = branchesDataFlowInfo;
        }
        if (whenReturnType != null && isExhaustive && expression2.getElseExpression() == null && KotlinBuiltIns.isNothing(whenReturnType)) {
            trace.record(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, expression2);
        }
        KotlinType kotlinType3 = branchesTypeInfo.getType();
        if (kotlinType3 == null) {
            return TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo);
        }
        KotlinType branchesType = kotlinType3;
        KotlinType resultType = this.components.dataFlowAnalyzer.checkType(branchesType, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
        boolean bl = branchesTypeInfo.getJumpOutPossible();
        DataFlowInfo dataFlowInfo3 = contextWithExpectedType.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo3, (String)"contextWithExpectedType.dataFlowInfo");
        return TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, bl, dataFlowInfo3);
    }

    private final KotlinType inferTypeForWhenExpression(KtWhenExpression expression2, ExpressionTypingContext contextWithExpectedType, ExpressionTypingContext contextAfterSubject, List<? extends DataFlowInfo> dataFlowInfoForEntries) {
        boolean bl;
        block4: {
            Iterable $receiver$iv = expression2.getEntries();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    if (it.getExpression() == null) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return this.components.builtIns.getUnitType();
        }
        List<KtExpression> wrappedArgumentExpressions = this.wrapWhenEntryExpressionsAsSpecialCallArguments(expression2);
        Call callForWhen = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2, wrappedArgumentExpressions);
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsOfWhenCall(callForWhen, contextAfterSubject.dataFlowInfo, dataFlowInfoForEntries);
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForWhen, ControlStructureTypingUtils.ResolveConstruct.WHEN, (List<String>)new AbstractList<String>(wrappedArgumentExpressions){
            final /* synthetic */ List $wrappedArgumentExpressions;

            @NotNull
            public String get(int index2) {
                return "entry" + index2;
            }

            public int getSize() {
                return this.$wrappedArgumentExpressions.size();
            }
            {
                this.$wrappedArgumentExpressions = $captured_local_variable$0;
            }
        }, Collections.nCopies(wrappedArgumentExpressions.size(), false), contextWithExpectedType, dataFlowInfoForArguments);
        return resolvedCall2.getResultingDescriptor().getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> wrapWhenEntryExpressionsAsSpecialCallArguments(KtWhenExpression expression2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
        Iterable iterable = $receiver$iv = (Iterable)expression2.getEntries();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtBlockExpression ktBlockExpression;
            KtBlockExpression ktBlockExpression2;
            Object element$iv$iv = element$iv$iv$iv;
            KtWhenEntry whenEntry = (KtWhenEntry)element$iv$iv;
            if (whenEntry.getExpression() != null) {
                KtExpression ktExpression;
                KtExpression it;
                KtExpression ktExpression2 = it = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"it");
                ktBlockExpression2 = psiFactory.wrapInABlockWrapper(ktExpression2);
            } else {
                ktBlockExpression2 = null;
            }
            if (ktBlockExpression2 == null) continue;
            KtBlockExpression it$iv$iv = ktBlockExpression = ktBlockExpression2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ArrayList<DataFlowInfo> analyzeConditionsInWhenEntries(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, DataFlowValue subjectDataFlowValue, KotlinType subjectType) {
        KtExpression subjectExpression = expression2.getSubjectExpression();
        ArrayList<DataFlowInfo> argumentDataFlowInfos = new ArrayList<DataFlowInfo>();
        DataFlowInfo inputDataFlowInfo = contextAfterSubject.dataFlowInfo;
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenEntry whenEntry;
            KtWhenEntry ktWhenEntry = whenEntry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"whenEntry");
            Object Context2 = contextAfterSubject.replaceDataFlowInfo(inputDataFlowInfo);
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"contextAfterSubject.repl\u2026owInfo(inputDataFlowInfo)");
            ConditionalDataFlowInfo conditionsInfo = this.analyzeWhenEntryConditions(ktWhenEntry, (ExpressionTypingContext)Context2, subjectExpression, subjectType, subjectDataFlowValue);
            inputDataFlowInfo = inputDataFlowInfo.and(conditionsInfo.getElseInfo());
            if (whenEntry.getExpression() == null) continue;
            argumentDataFlowInfos.add(conditionsInfo.getThenInfo());
        }
        return argumentDataFlowInfos;
    }

    private final KotlinTypeInfo joinWhenExpressionBranches(KtWhenExpression expression2, ExpressionTypingContext contextAfterSubject, KotlinType resultType, boolean jumpOutPossibleInSubject, DataFlowValue whenResultValue) {
        BindingContext bindingContext2 = contextAfterSubject.trace.getBindingContext();
        DataFlowInfo currentDataFlowInfo = null;
        boolean jumpOutPossible = jumpOutPossibleInSubject;
        boolean errorTypeExistInBranch = false;
        for (KtWhenEntry whenEntry : expression2.getEntries()) {
            DataFlowInfo entryDataFlowInfo;
            DataFlowInfo dataFlowInfo;
            KotlinTypeInfo entryTypeInfo;
            KtExpression entryExpression;
            if (whenEntry.getExpression() == null) {
                continue;
            }
            if (BindingContextUtils.getRecordedTypeInfo(entryExpression, bindingContext2) == null) {
                continue;
            }
            KotlinType entryType = entryTypeInfo.getType();
            if (entryType == null) {
                errorTypeExistInBranch = true;
            }
            if (whenResultValue != null && entryType != null) {
                KtExpression ktExpression = entryExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"entryExpression");
                DataFlowValue entryValue = DataFlowValueFactory.createDataFlowValue(ktExpression, entryType, contextAfterSubject);
                DataFlowInfo dataFlowInfo2 = entryTypeInfo.getDataFlowInfo();
                LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
                Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"components.languageVersionSettings");
                dataFlowInfo = dataFlowInfo2.assign(whenResultValue, entryValue, languageVersionSettings);
            } else {
                dataFlowInfo = entryDataFlowInfo = entryTypeInfo.getDataFlowInfo();
            }
            currentDataFlowInfo = entryType != null && KotlinBuiltIns.isNothing(entryType) ? currentDataFlowInfo : (currentDataFlowInfo != null ? currentDataFlowInfo.or(entryDataFlowInfo) : entryDataFlowInfo);
            jumpOutPossible |= entryTypeInfo.getJumpOutPossible();
        }
        DataFlowInfo dataFlowInfo = currentDataFlowInfo;
        if (dataFlowInfo == null) {
            DataFlowInfo dataFlowInfo3 = contextAfterSubject.dataFlowInfo;
            dataFlowInfo = dataFlowInfo3;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo3, (String)"contextAfterSubject.dataFlowInfo");
        }
        DataFlowInfo resultDataFlowInfo = dataFlowInfo;
        return resultType == null || errorTypeExistInBranch && KotlinBuiltIns.isNothing(resultType) ? TypeInfoFactoryKt.noTypeInfo(resultDataFlowInfo) : TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, jumpOutPossible, resultDataFlowInfo);
    }

    private final void checkSmartCastsInSubjectIfRequired(KtWhenExpression expression2, ExpressionTypingContext contextBeforeSubject, KotlinType subjectType, Set<? extends KotlinType> possibleTypesForSubject) {
        KtExpression ktExpression = expression2.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subjectExpression = ktExpression;
        for (KotlinType kotlinType : possibleTypesForSubject) {
            ClassDescriptor possibleCastClass;
            ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)possibleCastClass.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) && !Intrinsics.areEqual((Object)((Object)possibleCastClass.getModality()), (Object)((Object)Modality.SEALED))) continue;
            KtExpression ktExpression2 = subjectExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"subjectExpression");
            if (!this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, ktExpression2, subjectType, kotlinType)) continue;
            return;
        }
        boolean bl = TypeUtils.isNullableType(subjectType);
        BindingContext bindingContext2 = contextBeforeSubject.trace.getBindingContext();
        if (bl) {
            BindingContext bindingContext3 = bindingContext2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"bindingContext");
            if (!WhenChecker.INSTANCE.containsNullCase(expression2, bindingContext3)) {
                KotlinType notNullableType = TypeUtils.makeNotNullable(subjectType);
                KtExpression ktExpression3 = subjectExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"subjectExpression");
                KotlinType kotlinType = notNullableType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"notNullableType");
                if (this.checkSmartCastToExpectedTypeInSubject(contextBeforeSubject, ktExpression3, subjectType, kotlinType)) {
                    return;
                }
            }
        }
    }

    private final boolean checkSmartCastToExpectedTypeInSubject(ExpressionTypingContext contextBeforeSubject, KtExpression subjectExpression, KotlinType subjectType, KotlinType expectedType2) {
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(contextBeforeSubject.trace, "Temporary trace for when subject nullability");
        ExpressionTypingContext subjectContext = (ExpressionTypingContext)((ExpressionTypingContext)contextBeforeSubject.replaceExpectedType(expectedType2)).replaceBindingTrace(trace);
        SmartCastResult castResult = DataFlowAnalyzer.checkPossibleCast(subjectType, KtPsiUtil.safeDeparenthesize(subjectExpression), subjectContext);
        if (castResult != null && castResult.isCorrect()) {
            trace.commit();
            return true;
        }
        return false;
    }

    private final ConditionalDataFlowInfo analyzeWhenEntryConditions(KtWhenEntry whenEntry, ExpressionTypingContext context, KtExpression subjectExpression, KotlinType subjectType, DataFlowValue subjectDataFlowValue) {
        if (whenEntry.isElse()) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        ConditionalDataFlowInfo entryInfo = null;
        ExpressionTypingContext contextForCondition = context;
        KtWhenCondition[] ktWhenConditionArray = whenEntry.getConditions();
        for (int i = 0; i < ktWhenConditionArray.length; ++i) {
            ConditionalDataFlowInfo conditionalDataFlowInfo;
            KtWhenCondition condition2;
            KtWhenCondition ktWhenCondition = condition2 = ktWhenConditionArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenCondition, (String)"condition");
            ConditionalDataFlowInfo conditionInfo = this.checkWhenCondition(subjectExpression, subjectType, ktWhenCondition, contextForCondition, subjectDataFlowValue);
            if (entryInfo != null) {
                ConditionalDataFlowInfo conditionalDataFlowInfo2;
                ConditionalDataFlowInfo it = conditionalDataFlowInfo2;
                conditionalDataFlowInfo = new ConditionalDataFlowInfo(it.getThenInfo().or(conditionInfo.getThenInfo()), it.getElseInfo().and(conditionInfo.getElseInfo()));
            } else {
                conditionalDataFlowInfo = conditionInfo;
            }
            entryInfo = conditionalDataFlowInfo;
            Object Context2 = contextForCondition.replaceDataFlowInfo(conditionInfo.getElseInfo());
            Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"contextForCondition.repl\u2026o(conditionInfo.elseInfo)");
            contextForCondition = (ExpressionTypingContext)Context2;
        }
        ConditionalDataFlowInfo conditionalDataFlowInfo = entryInfo;
        if (conditionalDataFlowInfo == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            conditionalDataFlowInfo = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
        }
        return conditionalDataFlowInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final ConditionalDataFlowInfo checkWhenCondition(KtExpression subjectExpression, KotlinType subjectType, KtWhenCondition condition2, ExpressionTypingContext context, DataFlowValue subjectDataFlowValue) {
        void newDataFlowInfo;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.noChange(context);
        condition2.accept(new KtVisitorVoid(this, subjectExpression, context, (Ref.ObjectRef)newDataFlowInfo, subjectType, subjectDataFlowValue){
            final /* synthetic */ PatternMatchingTypingVisitor this$0;
            final /* synthetic */ KtExpression $subjectExpression;
            final /* synthetic */ ExpressionTypingContext $context;
            final /* synthetic */ Ref.ObjectRef $newDataFlowInfo;
            final /* synthetic */ KotlinType $subjectType;
            final /* synthetic */ DataFlowValue $subjectDataFlowValue;

            public void visitWhenConditionInRange(@NotNull KtWhenConditionInRange condition2) {
                Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                KtExpression ktExpression = condition2.getRangeExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression rangeExpression = ktExpression;
                if (this.$subjectExpression == null) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition2)));
                    DataFlowInfo dataFlowInfo = this.this$0.facade.getTypeInfo(rangeExpression, this.$context).getDataFlowInfo();
                    this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                    return;
                }
                ValueArgument argumentForSubject = CallMaker.makeExternalValueArgument(this.$subjectExpression);
                KotlinTypeInfo typeInfo = this.this$0.facade.checkInExpression(condition2, condition2.getOperationReference(), argumentForSubject, rangeExpression, this.$context);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                this.$newDataFlowInfo.element = new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
                KotlinType type2 = typeInfo.getType();
                if (type2 == null || !KotlinBuiltIns.isBoolean(type2)) {
                    this.$context.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on((KtWhenConditionInRange)((PsiElement)condition2)));
                }
            }

            public void visitWhenConditionIsPattern(@NotNull KtWhenConditionIsPattern condition2) {
                KtTypeReference typeReference;
                Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                if (this.$subjectExpression == null) {
                    this.$context.trace.report(Errors.EXPECTED_CONDITION.on((KtWhenCondition)((PsiElement)condition2)));
                }
                if ((typeReference = condition2.getTypeReference()) != null) {
                    ConditionalDataFlowInfo result2 = PatternMatchingTypingVisitor.access$checkTypeForIs(this.this$0, this.$context, condition2, condition2.isNegated(), this.$subjectType, typeReference, this.$subjectDataFlowValue);
                    this.$newDataFlowInfo.element = condition2.isNegated() ? new ConditionalDataFlowInfo(result2.getElseInfo(), result2.getThenInfo()) : result2;
                    KotlinType rhsType = (KotlinType)this.$context.trace.get(BindingContext.TYPE, typeReference);
                    if (this.$subjectExpression != null) {
                        RttiExpressionInformation rttiInformation = new RttiExpressionInformation(this.$subjectExpression, this.$subjectType, rhsType, condition2.isNegated() ? RttiOperation.NOT_IS : RttiOperation.IS);
                        Iterable<RttiExpressionChecker> $receiver$iv = this.this$0.components.rttiExpressionCheckers;
                        Iterator<RttiExpressionChecker> iterator2 = $receiver$iv.iterator();
                        while (iterator2.hasNext()) {
                            RttiExpressionChecker element$iv;
                            RttiExpressionChecker it = element$iv = iterator2.next();
                            PsiElement psiElement2 = (PsiElement)condition2;
                            BindingTrace bindingTrace = this.$context.trace;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
                            it.check(rttiInformation, psiElement2, bindingTrace);
                        }
                    }
                }
            }

            public void visitWhenConditionWithExpression(@NotNull KtWhenConditionWithExpression condition2) {
                Intrinsics.checkParameterIsNotNull((Object)condition2, (String)"condition");
                KtExpression expression2 = condition2.getExpression();
                if (expression2 != null) {
                    this.$newDataFlowInfo.element = PatternMatchingTypingVisitor.access$checkTypeForExpressionCondition(this.this$0, this.$context, expression2, this.$subjectType, this.$subjectExpression == null, this.$subjectDataFlowValue);
                }
            }

            public void visitKtElement(@NotNull KtElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                this.$context.trace.report(Errors.UNSUPPORTED.on((PsiElement)element3, ((Object)((Object)this)).getClass().getCanonicalName()));
            }
            {
                this.this$0 = $outer;
                this.$subjectExpression = $captured_local_variable$1;
                this.$context = $captured_local_variable$2;
                this.$newDataFlowInfo = $captured_local_variable$3;
                this.$subjectType = $captured_local_variable$4;
                this.$subjectDataFlowValue = $captured_local_variable$5;
            }
        });
        return (ConditionalDataFlowInfo)newDataFlowInfo.element;
    }

    private final ConditionalDataFlowInfo checkTypeForExpressionCondition(ExpressionTypingContext context, KtExpression expression2, KotlinType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        ExpressionTypingContext newContext = context;
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(expression2, newContext);
        KotlinType kotlinType = typeInfo.getType();
        if (kotlinType == null) {
            return this.noChange(newContext);
        }
        KotlinType type2 = kotlinType;
        Object Context2 = newContext.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"newContext.replaceDataFl\u2026fo(typeInfo.dataFlowInfo)");
        newContext = (ExpressionTypingContext)Context2;
        if (conditionExpected) {
            SimpleType booleanType = this.components.builtIns.getBooleanType();
            KotlinTypeInfo checkedTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo, expression2, (ResolutionContext)newContext.replaceExpectedType(booleanType));
            KotlinType kotlinType2 = booleanType;
            KotlinType kotlinType3 = checkedTypeInfo.getType();
            if (kotlinType3 == null) {
                kotlinType3 = type2;
            }
            if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinType2, kotlinType3)) {
                DataFlowInfo ifInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, true, newContext);
                DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(expression2, false, newContext);
                DataFlowInfo dataFlowInfo = ifInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"ifInfo");
                DataFlowInfo dataFlowInfo2 = elseInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo2, (String)"elseInfo");
                return new ConditionalDataFlowInfo(dataFlowInfo, dataFlowInfo2);
            }
            return this.noChange(newContext);
        }
        this.checkTypeCompatibility(newContext, type2, subjectType, expression2);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, newContext);
        ConditionalDataFlowInfo result2 = this.noChange(newContext);
        DataFlowInfo dataFlowInfo = result2.getThenInfo();
        boolean bl = DataFlowAnalyzer.typeHasEqualsFromAny(subjectType, expression2);
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"components.languageVersionSettings");
        DataFlowInfo dataFlowInfo3 = dataFlowInfo.equate(subjectDataFlowValue, expressionDataFlowValue, bl, languageVersionSettings);
        DataFlowInfo dataFlowInfo4 = result2.getElseInfo();
        LanguageVersionSettings languageVersionSettings2 = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings2, (String)"components.languageVersionSettings");
        return new ConditionalDataFlowInfo(dataFlowInfo3, dataFlowInfo4.disequate(subjectDataFlowValue, expressionDataFlowValue, languageVersionSettings2));
    }

    private final ConditionalDataFlowInfo checkTypeForIs(ExpressionTypingContext context, KtElement isCheck, boolean negated, KotlinType subjectType, KtTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        DataFlowInfo dataFlowInfo;
        ClassDescriptor targetDescriptor;
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context.scope, context.trace, true, true, context.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context.trace, this.components.builtIns);
        if (DynamicTypesKt.isDynamic(targetType)) {
            context.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if ((targetDescriptor = TypeUtils.getClassDescriptor(targetType)) != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
            context.trace.report(Errors.IS_ENUM_ENTRY.on((KtTypeReference)((PsiElement)typeReferenceAfterIs)));
        }
        if (!TypeUtilsKt.containsError(subjectType) && !TypeUtils.isNullableType(subjectType) && targetType.isMarkedNullable()) {
            KtTypeElement element3 = typeReferenceAfterIs.getTypeElement();
            boolean bl = element3 instanceof KtNullableType;
            if (_Assertions.ENABLED && !bl) {
                String string = "element must be instance of " + KtNullableType.class.getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtTypeElement ktTypeElement = element3;
            if (ktTypeElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNullableType");
            }
            context.trace.report(Errors.USELESS_NULLABLE_CHECK.on((KtNullableType)((PsiElement)((KtNullableType)ktTypeElement))));
        }
        KotlinType kotlinType = targetType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"targetType");
        this.checkTypeCompatibility(context, kotlinType, subjectType, typeReferenceAfterIs);
        this.detectRedundantIs(context, subjectType, targetType, isCheck, negated, subjectDataFlowValue);
        KotlinTypeChecker kotlinTypeChecker = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeChecker, (String)"KotlinTypeChecker.DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, kotlinTypeChecker)) {
            context.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on((KtElement)((PsiElement)typeReferenceAfterIs), targetType));
        }
        DataFlowInfo it = dataFlowInfo = context.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageVersionSettings, (String)"components.languageVersionSettings");
        DataFlowInfo dataFlowInfo2 = it.establishSubtyping(subjectDataFlowValue, targetType, languageVersionSettings);
        DataFlowInfo dataFlowInfo3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo3, (String)"it");
        return new ConditionalDataFlowInfo(dataFlowInfo2, dataFlowInfo3);
    }

    private final void detectRedundantIs(ExpressionTypingContext context, KotlinType subjectType, KotlinType targetType, KtElement isCheck, boolean negated, DataFlowValue subjectDataFlowValue) {
        Collection<KotlinType> possibleTypes;
        if (TypeUtilsKt.containsError(subjectType) || TypeUtilsKt.containsError(targetType)) {
            return;
        }
        Collection<KotlinType> collection = possibleTypes = DataFlowAnalyzer.getAllPossibleTypes(subjectType, context, subjectDataFlowValue);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"possibleTypes");
        if (CastDiagnosticsUtil.INSTANCE.isRefinementUseless(collection, targetType, false)) {
            context.trace.report(Errors.USELESS_IS_CHECK.on((KtElement)((PsiElement)isCheck), !negated));
        }
    }

    private final ConditionalDataFlowInfo noChange(ExpressionTypingContext context) {
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        return new ConditionalDataFlowInfo(dataFlowInfo, null, 2, null);
    }

    private final void checkTypeCompatibility(ExpressionTypingContext context, KotlinType type2, KotlinType subjectType, KtElement reportErrorOn) {
        if (TypeIntersector.isIntersectionEmpty(type2, subjectType)) {
            context.trace.report(Errors.INCOMPATIBLE_TYPES.on((KtElement)((PsiElement)reportErrorOn), type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on((KtElement)((PsiElement)reportErrorOn)));
        }
    }

    public PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForIs(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KtElement isCheck, boolean negated, @NotNull KotlinType subjectType, @NotNull KtTypeReference typeReferenceAfterIs, @NotNull DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForIs(context, isCheck, negated, subjectType, typeReferenceAfterIs, subjectDataFlowValue);
    }

    @NotNull
    public static final /* synthetic */ ConditionalDataFlowInfo access$checkTypeForExpressionCondition(PatternMatchingTypingVisitor $this, @NotNull ExpressionTypingContext context, @NotNull KtExpression expression2, @NotNull KotlinType subjectType, boolean conditionExpected, @NotNull DataFlowValue subjectDataFlowValue) {
        return $this.checkTypeForExpressionCondition(context, expression2, subjectType, conditionExpected, subjectDataFlowValue);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$ConditionalDataFlowInfo;", "", "thenInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "elseInfo", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getElseInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getThenInfo", "frontend"})
    private static final class ConditionalDataFlowInfo {
        @NotNull
        private final DataFlowInfo thenInfo;
        @NotNull
        private final DataFlowInfo elseInfo;

        @NotNull
        public final DataFlowInfo getThenInfo() {
            return this.thenInfo;
        }

        @NotNull
        public final DataFlowInfo getElseInfo() {
            return this.elseInfo;
        }

        public ConditionalDataFlowInfo(@NotNull DataFlowInfo thenInfo, @NotNull DataFlowInfo elseInfo) {
            Intrinsics.checkParameterIsNotNull((Object)thenInfo, (String)"thenInfo");
            Intrinsics.checkParameterIsNotNull((Object)elseInfo, (String)"elseInfo");
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }

        public /* synthetic */ ConditionalDataFlowInfo(DataFlowInfo dataFlowInfo, DataFlowInfo dataFlowInfo2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                dataFlowInfo2 = dataFlowInfo;
            }
            this(dataFlowInfo, dataFlowInfo2);
        }
    }
}

