/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppLinksAnalyticsProvider
implements AnalyticsProvider {
    private static final Map<String, AppLinksAssistantEvent.EventSource> mySidePanelActionButtonMap = ImmutableMap.of((Object)"url_assistant.url_mapper", (Object)AppLinksAssistantEvent.EventSource.URL_MAPPING_PANEL, (Object)"url_assistant.dal_generator", (Object)AppLinksAssistantEvent.EventSource.DAL_PANEL, (Object)"url_assistant.insert_app_link_handling_code", (Object)AppLinksAssistantEvent.EventSource.CODE_INSERT_DIALOG, (Object)"url_assistant.launch_app_via_app_link", (Object)AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL);

    public void trackPanelOpened(@NotNull Project project) {
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.ASSISTANT_SIDE_PANEL, AppLinksAssistantEvent.EventState.OPENED, project);
    }

    public static void trackActionButtonClick(@NotNull String actionId, @NotNull Project project) {
        if (mySidePanelActionButtonMap.containsKey(actionId)) {
            AppLinksAnalyticsProvider.trackEvent(mySidePanelActionButtonMap.get(actionId), AppLinksAssistantEvent.EventState.OPENED, project);
        } else {
            Logger.getInstance(AppLinksAnalyticsProvider.class).warn("\"No metric event registry found for button: \\\"\" + actionId + \"\\\".\"");
        }
    }

    public static void trackEvent(@NotNull AppLinksAssistantEvent.EventSource source, @NotNull AppLinksAssistantEvent.EventState state, @NotNull Project project) {
        AppLinksAssistantEvent.Builder eventDetails = AppLinksAssistantEvent.newBuilder().setEventSource(source).setEventState(state);
        String appId = ProjectStructureUsageTracker.getApplicationId((Project)project);
        if (appId != null) {
            eventDetails.setAppId(AnonymizerUtil.anonymizeUtf8((String)appId));
        }
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_LINKS_ASSISTANT_STATS).setAppLinksAssistantEvent(eventDetails);
        UsageTracker.getInstance().log(event);
    }
}

