/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.AppLinksAnalyticsProvider;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.UrlAssistColors;
import com.google.urlassistant.UrlAssistantTableRenderer;
import com.google.urlassistant.editor.UrlAssistantWindowBase;
import com.google.urlassistant.ui.AddUrlDialog;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import groovy.swing.impl.DefaultAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class UrlAssistantWindow
extends JPanel
implements UrlAssistantWindowBase {
    private JBTable myJTable;
    private JPanel myRootPanel;
    private JPanel myToolbarPanel;
    private JPanel myLowerPanel;
    private JPanel myUpperPanel;
    private JPanel myContentPanel;
    private JPanel myManifestJPanel;
    private JBTextField myTestUrlTextField;
    private JTextPane myCheckMappingResultTextPane;
    private JButton myOpenAndroidManifestButton;
    private JTextPane myPanelDescriptionLabel;
    private JBLabel myPreviewTitleLabel;
    private JTextPane myPreviewInstructionTextPane;
    private JBLabel mySmallTitleLabel;
    private JButton myAddAsTestUrlButton;
    private JBLabel myTestUrlAddedLabel;
    private JPanel myTestUrlPanel;
    private DeepLinksTableModel myTableModel;
    private Project myProject;
    private XmlFile myManifestPsiFile;
    private ActivityData myCheckMappingResultActivity;
    private Editor myEditor;
    private CardLayout myLowerPanelCardLayout;
    private UrlAssistantTableRenderer myRenderer;
    private int myRefactorAnswer = -1;
    private boolean myShowOrder = false;
    private boolean myIsSelected = false;
    public static final int COLUMN_URL = 0;
    public static final int COLUMN_PATH = 1;
    public static final int COLUMN_ACTIVITY = 2;
    public static final int COLUMN_ORDER = 3;
    public static final String PORT = "port";
    public static final String MIMETYPE = "mimeType";
    private static final int TABLE_HEADER_HEIGHT = 22;
    private static final int TABLE_ROW_HEIGHT = 24;
    private static final String[] COLUMN_NAMES_WITH_ORDER = new String[]{"Host", "Path values", "Activity", "Order"};
    private static final String[] COLUMN_NAMES = new String[]{"Host", "Path values", "Activity"};

    public UrlAssistantWindow(@NotNull Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myRenderer = new UrlAssistantTableRenderer();
        this.myShowOrder = Order.isSupportedFor(this.myProject);
        this.setUpListeners();
        this.myJTable = new JBTable();
        this.setUpTable();
        this.myLowerPanel.setVisible(false);
        this.myRootPanel.setBackground(this.myContentPanel.getBackground());
        this.myPanelDescriptionLabel.setBackground(this.myContentPanel.getBackground());
        this.myCheckMappingResultTextPane.setBackground(this.myContentPanel.getBackground());
        this.myPreviewInstructionTextPane.setBackground(this.myContentPanel.getBackground());
        this.myPanelDescriptionLabel.setText(UrlAssistantBundle.message("url.assistant.panel.description", new Object[0]));
        this.myPreviewInstructionTextPane.setText(UrlAssistantBundle.message("url.assistant.preview.instruction", new Object[0]));
        this.myTestUrlTextField.getEmptyText().setText(UrlAssistantBundle.message("check.url.mapping.instruction", new Object[0]));
        this.myLowerPanelCardLayout = (CardLayout)this.myLowerPanel.getLayout();
        this.myLowerPanelCardLayout.last(this.myLowerPanel);
        this.mySmallTitleLabel.setForeground((Color)UrlAssistColors.SUBTITLE_TEXT_COLOR);
        this.add(this.myRootPanel);
        this.myContentPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    @NotNull
    public JBTable getTable() {
        return this.myJTable;
    }

    private void setUpListeners() {
        this.myTestUrlTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String resultMessage;
                try {
                    UrlAssistantWindow.this.myCheckMappingResultActivity = UrlAssistUtils.findAssociatedActivity(UrlAssistantWindow.this.myTableModel.getDeepLinkData(), UrlAssistantWindow.this.myTestUrlTextField.getText());
                    resultMessage = UrlAssistantWindow.this.myCheckMappingResultActivity == null ? UrlAssistantBundle.message("check.url.mapping.fail", new Object[0]) : UrlAssistantBundle.message("check.url.mapping.result", UrlAssistantWindow.this.myCheckMappingResultActivity.getActivityAndModuleName());
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_CHECK_MAPPING_BUTTON, AppLinksAssistantEvent.EventState.OPENED, UrlAssistantWindow.this.myProject);
                }
                catch (MalformedURLException e) {
                    UrlAssistantWindow.this.myCheckMappingResultActivity = null;
                    resultMessage = UrlAssistantBundle.message("check.url.mapping.malformed", new Object[0]);
                }
                UrlAssistantWindow.this.myTestUrlPanel.setVisible(UrlAssistantWindow.this.myCheckMappingResultActivity != null);
                if (UrlAssistantWindow.this.myCheckMappingResultActivity != null) {
                    if (ManifestUtils.isTestUrlAdded(UrlAssistantWindow.this.myCheckMappingResultActivity, UrlAssistantWindow.this.myTestUrlTextField.getText())) {
                        UrlAssistantWindow.this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.test.url.added", new Object[0]));
                        UrlAssistantWindow.this.myTestUrlAddedLabel.setForeground((Color)JBColor.GRAY);
                        ((CardLayout)UrlAssistantWindow.this.myTestUrlPanel.getLayout()).show(UrlAssistantWindow.this.myTestUrlPanel, "labelCard");
                    } else {
                        ((CardLayout)UrlAssistantWindow.this.myTestUrlPanel.getLayout()).show(UrlAssistantWindow.this.myTestUrlPanel, "buttonCard");
                    }
                }
                UrlAssistantWindow.this.myCheckMappingResultTextPane.setText(resultMessage);
            }
        });
        this.myAddAsTestUrlButton.addActionListener(e -> new WriteCommandAction<PsiClass>(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.OPENED, UrlAssistantWindow.this.myProject);
                XmlTag validationTag = ManifestUtils.addTestUrl(UrlAssistantWindow.this.myCheckMappingResultActivity, UrlAssistantWindow.this.myTestUrlTextField.getText());
                if (validationTag != null) {
                    UrlAssistantWindow.this.createEditorAndShowManifestIfNeeded(UrlAssistantWindow.this.myCheckMappingResultActivity);
                    UrlAssistantWindow.this.updateAndroidManifestPreview(UrlAssistantWindow.this.myCheckMappingResultActivity.getModule());
                    UrlAssistantWindow.this.setXmlTagSelected(validationTag);
                    UrlAssistantWindow.this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.test.url.added", new Object[0]));
                    UrlAssistantWindow.this.myTestUrlAddedLabel.setForeground((Color)JBColor.GRAY);
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, UrlAssistantWindow.this.myProject);
                } else {
                    UrlAssistantWindow.this.myTestUrlAddedLabel.setText(UrlAssistantBundle.message("check.url.mapping.add.test.url.fail", new Object[0]));
                    UrlAssistantWindow.this.myTestUrlAddedLabel.setForeground((Color)JBColor.RED);
                    AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_ADD_TEST_URL_BUTTON, AppLinksAssistantEvent.EventState.FAILED, UrlAssistantWindow.this.myProject);
                }
                ((CardLayout)UrlAssistantWindow.this.myTestUrlPanel.getLayout()).next(UrlAssistantWindow.this.myTestUrlPanel);
            }
        }.execute());
        this.myCheckMappingResultTextPane.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                UrlAssistUtils.openActivityFile(this.myProject, this.myCheckMappingResultActivity);
            }
        });
        this.myOpenAndroidManifestButton.addActionListener(e -> {
            if (this.myManifestPsiFile != null) {
                UrlAssistUtils.openVirtualFile(this.myProject, this.myManifestPsiFile.getVirtualFile());
                AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_OPEN_ANDROID_MANIFEST_BUTTON, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
            }
        });
    }

    public void updateAndroidManifestPreview(@NotNull Module module) {
        XmlFile androidManifestFile = ManifestUtils.getAndroidManifestPsi(module);
        if (androidManifestFile == null) {
            return;
        }
        AccessToken writeToken = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)androidManifestFile);
        if (this.myEditor != null) {
            this.myEditor.getDocument().setText((CharSequence)androidManifestFile.getText());
        }
        writeToken.finish();
    }

    private void setRendererAndColumnWidth() {
        this.myJTable.getColumnModel().getColumn(1).setCellRenderer(this.myRenderer);
        this.myJTable.getColumnModel().getColumn(0).setCellRenderer(this.myRenderer);
        this.myJTable.getColumnModel().getColumn(2).setCellRenderer(this.myRenderer);
        if (this.myShowOrder) {
            this.myJTable.getColumnModel().getColumn(3).setCellRenderer(this.myRenderer);
            this.myJTable.getColumnModel().getColumn(0).setPreferredWidth(300);
            this.myJTable.getColumnModel().getColumn(1).setPreferredWidth(80);
            this.myJTable.getColumnModel().getColumn(2).setPreferredWidth(250);
            this.myJTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        }
    }

    private void setUpTable() {
        this.myTableModel = new DeepLinksTableModel(this.myShowOrder);
        this.myJTable.setModel((TableModel)this.myTableModel);
        this.myJTable.setRowHeight(24);
        this.myJTable.setFillsViewportHeight(true);
        this.myJTable.setShowGrid(false);
        this.myJTable.setSelectionMode(2);
        this.myJTable.setIntercellSpacing(new Dimension(0, 0));
        this.setRendererAndColumnWidth();
        this.myTableModel.addTableModelListener(e -> {
            this.myPreviewTitleLabel.setText(this.myJTable.isEmpty() ? " " : UrlAssistantBundle.message("url.assistant.preview.title", new Object[0]));
            this.myLowerPanel.setVisible(!this.myJTable.isEmpty());
        });
        this.myJTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.handleTableSelection();
            }
        });
        this.myJTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int clickedRow;
                boolean isFromKeyboard = e.getButton() == 0;
                JTable table = (JTable)e.getSource();
                Point p = e.getPoint();
                int n = !isFromKeyboard ? table.rowAtPoint(p) : (clickedRow = UrlAssistantWindow.this.myJTable.getSelectedRowCount() == 1 ? UrlAssistantWindow.this.myJTable.getSelectedRow() : -1);
                if (!isFromKeyboard && e.getClickCount() == 1) {
                    if (clickedRow == -1) {
                        UrlAssistantWindow.this.deselectAllRows();
                        UrlAssistantWindow.this.myLowerPanelCardLayout.last(UrlAssistantWindow.this.myLowerPanel);
                    } else if (e.isPopupTrigger()) {
                        UrlAssistantWindow.this.myJTable.setRowSelectionInterval(clickedRow, clickedRow);
                    }
                }
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    UrlAssistantWindow.this.openEditDialog(clickedRow);
                }
                if (e.isPopupTrigger() && clickedRow >= 0) {
                    JBPopupMenu popup = new JBPopupMenu();
                    JBMenuItem createUrlItem = new JBMenuItem(UrlAssistantBundle.message("add.url.from.this.url", new Object[0]));
                    JBMenuItem editRunConfigItem = new JBMenuItem(UrlAssistantBundle.message("url.assistant.edit.run.configuration", new Object[0]));
                    popup.add((JMenuItem)createUrlItem);
                    createUrlItem.addActionListener(e1 -> {
                        AddUrlDialog dialog = new AddUrlDialog(UrlAssistantWindow.this.myProject, UrlAssistantWindow.this);
                        Order order = UrlAssistantWindow.this.myShowOrder ? (Order)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 3) : Order.DEFAULT_INSTANCE;
                        FullUrl fullUrl = (FullUrl)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 0);
                        PathData pathData = (PathData)UrlAssistantWindow.this.myJTable.getValueAt(clickedRow, 1);
                        dialog.setValue(order, fullUrl, pathData, null, -1);
                        UrlAssistantWindow.this.showAndTrack(dialog);
                    });
                    popup.add((JMenuItem)editRunConfigItem);
                    editRunConfigItem.addActionListener(e12 -> {
                        if (UrlAssistantWindow.this.myProject.isDisposed()) {
                            return;
                        }
                        EditConfigurationsDialog dialog = new EditConfigurationsDialog(UrlAssistantWindow.this.myProject);
                        dialog.show();
                    });
                    popup.setBorder((Border)new BevelBorder(0));
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        if (SystemInfo.isMac) {
            this.myJTable.getInputMap().put(KeyStroke.getKeyStroke("BACK_SPACE"), "Delete URL");
        }
        this.myJTable.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "Delete URL");
        this.myJTable.getActionMap().put("Delete URL", (Action)new DefaultAction(){

            public void actionPerformed(ActionEvent event) {
                UrlAssistantWindow.this.deleteSelectedUrl();
            }
        });
        JTableHeader header = this.myJTable.getTableHeader();
        header.setDefaultRenderer(new HeaderRenderer());
        header.setResizingAllowed(true);
        header.setReorderingAllowed(false);
        header.setBackground((Color)JBColor.WHITE);
        header.setPreferredSize(new Dimension(0, 22));
        this.createToolbarButtons();
    }

    public void handleTableSelection() {
        if (this.myJTable.getSelectedRowCount() > 1 || this.myJTable.getSelectedRow() < 0) {
            this.myLowerPanelCardLayout.last(this.myLowerPanel);
            return;
        }
        this.createEditorAndShowManifestIfNeeded((ActivityData)this.myJTable.getValueAt(this.myJTable.getSelectedRow(), 2));
    }

    private void createEditorAndShowManifestIfNeeded(@NotNull ActivityData activityData) {
        this.myLowerPanel.setVisible(true);
        this.myLowerPanelCardLayout.first(this.myLowerPanel);
        XmlFile newManifestFile = ManifestUtils.getAndroidManifestPsi(activityData.getModule());
        if (newManifestFile != null) {
            if (this.myEditor == null || this.myEditor.isDisposed()) {
                EditorFactory editorFactory = EditorFactory.getInstance();
                this.myEditor = editorFactory.createEditor(editorFactory.createDocument((CharSequence)""), this.myProject, (FileType)XmlFileType.INSTANCE, true);
                this.myEditor.getSettings().setLineNumbersShown(false);
                this.myEditor.getSettings().setLineMarkerAreaShown(false);
                this.myEditor.getSettings().setRightMarginShown(false);
                this.myEditor.getSettings().setLineCursorWidth(0);
                this.myManifestJPanel.add((Component)this.myEditor.getComponent(), "Center");
            }
            if (this.myManifestPsiFile == null || !this.myManifestPsiFile.equals(newManifestFile)) {
                this.myManifestPsiFile = newManifestFile;
                AccessToken writeToken = ApplicationManager.getApplication().acquireWriteActionLock(this.getClass());
                this.myEditor.getDocument().setText((CharSequence)this.myManifestPsiFile.getText());
                this.myManifestJPanel.validate();
                writeToken.finish();
            }
            if (activityData.getIntentFilterTag() != null) {
                this.setXmlTagSelected(activityData.getIntentFilterTag());
            }
        }
    }

    private void setXmlTagSelected(@NotNull XmlTag xmlTag) {
        int startOffset = xmlTag.getTextOffset();
        this.myEditor.getSelectionModel().setSelection(startOffset, startOffset + xmlTag.getTextLength());
        this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(startOffset), ScrollType.CENTER_UP);
    }

    private void deselectAllRows() {
        if (this.myJTable.getRowCount() > 0) {
            this.myJTable.getSelectionModel().removeSelectionInterval(0, this.myJTable.getRowCount() - 1);
        }
        this.myLowerPanelCardLayout.last(this.myLowerPanel);
    }

    private void openEditDialog() {
        this.openEditDialog(this.myJTable.getSelectedRow());
    }

    private void openEditDialog(int selectedRow) {
        if (selectedRow < 0) {
            return;
        }
        AddUrlDialog dialog = new AddUrlDialog(this.myProject, this);
        dialog.setValue(this.myTableModel.getRowAt(selectedRow), selectedRow);
        dialog.show();
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_EDIT_DIALOG, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
    }

    private void openAddUrlDialog() {
        AddUrlDialog dialog = new AddUrlDialog(this.myProject, this);
        this.showAndTrack(dialog);
    }

    private void showAndTrack(@NotNull DialogWrapper dialog) {
        dialog.show();
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_ADD_DIALOG, AppLinksAssistantEvent.EventState.OPENED, this.myProject);
    }

    private void createToolbarButtons() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myJTable).disableUpDownActions();
        decorator.setToolbarPosition(ActionToolbarPosition.BOTTOM);
        decorator.setRemoveAction(anActionButton -> this.deleteSelectedUrl());
        decorator.setAddAction(anActionButton -> this.openAddUrlDialog());
        decorator.setEditAction(anActionButton -> this.openEditDialog());
        this.myToolbarPanel.add(decorator.createPanel());
    }

    public void deleteSelectedUrl() {
        new WriteCommandAction<PsiClass>(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                int[] selectedRows = UrlAssistantWindow.this.getTable().getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    UrlAssistantWindow.this.removeIntentFilter(selectedRows[i]);
                    UrlAssistantWindow.this.removeRowFromTable(selectedRows[i]);
                }
            }
        }.execute();
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.URL_MAPPING_APP_LINK_DELETE_BUTTON, AppLinksAssistantEvent.EventState.COMPLETED, this.myProject);
    }

    private void removeIntentFilter(int selectedRow) {
        ActivityData activityData = this.myTableModel.getRowAt(selectedRow).getActivityData();
        if (activityData.getIntentFilterTag() != null) {
            activityData.getIntentFilterTag().delete();
        }
        this.updateAndroidManifestPreview(activityData.getModule());
    }

    private void removeRowFromTable(int selectedRow) {
        this.myTableModel.removeRow(selectedRow);
        this.deselectAllRows();
    }

    @NotNull
    public DeepLinksTableModel getTableModel() {
        return this.myTableModel;
    }

    public void showDeepLinksFromManifest() {
        Module[] modules;
        this.myTableModel.setColumnCount(this.myShowOrder ? COLUMN_NAMES_WITH_ORDER.length : COLUMN_NAMES.length);
        this.setRendererAndColumnWidth();
        int[] selectedRows = this.myJTable.getSelectedRows();
        this.myTableModel.clear();
        DeepLinks deepLinks = new DeepLinks();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            DeepLinkUtils.loadDeepLinks(module, deepLinks, this);
        }
        this.myTableModel.setDeepLinksData(deepLinks);
        this.myManifestPsiFile = null;
        for (int selectedRow : selectedRows) {
            if (selectedRow < 0 || selectedRow >= this.myJTable.getRowCount()) continue;
            this.myJTable.addRowSelectionInterval(selectedRow, selectedRow);
        }
        this.handleTableSelection();
    }

    public boolean refactorIntentFilters(final @NotNull Order order, final @NotNull ActivityData activityData, final @NotNull XmlTag activityTag, final @NotNull List<FullUrl> urlList, final @NotNull Set<PathData> pathDataSet, final @NotNull List<DeepLinks.DeepLink> deepLinkList) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myRefactorAnswer != 0 && !this.myIsSelected) {
            this.myRefactorAnswer = Messages.showYesNoDialog((String)UrlAssistantBundle.message("manifest.need.refactor", new Object[0]), (String)UrlAssistantBundle.message("manifest.need.refactor.title", new Object[0]), null);
        }
        if (this.myRefactorAnswer == 1) {
            return false;
        }
        new WriteCommandAction<PsiClass>(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                urlList.forEach(fullUrl -> pathDataSet.forEach(pathData -> deepLinkList.add(new DeepLinks.DeepLink(order, new ActivityData(activityData.getModule(), activityData.getActivityName(), UrlAssistUtils.createDeepLinkIntentFilter(order, activityTag, fullUrl, pathData), null), (FullUrl)fullUrl, (PathData)pathData))));
            }
        }.execute();
        return true;
    }

    @Override
    public void selectNotify() {
        if (!this.myIsSelected) {
            this.myShowOrder = Order.isSupportedFor(this.myProject);
            this.showDeepLinksFromManifest();
            this.myIsSelected = true;
        }
    }

    @Override
    public void deselectNotify() {
        this.myIsSelected = false;
    }

    @Override
    @NotNull
    public JComponent asPanel() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myTableModel.clear();
            this.myManifestJPanel.removeAll();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JButton jButton2;
        JBLabel jBLabel2;
        JPanel jPanel3;
        JBLabel jBLabel3;
        JTextPane jTextPane2;
        JBTextField jBTextField;
        JTextPane jTextPane3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setFocusCycleRoot(false);
        jPanel7.setFocusable(true);
        jPanel7.setMinimumSize(new Dimension(900, 870));
        jPanel7.setAutoscrolls(false);
        ((Component)jPanel7).setBackground(new Color(-1513240));
        jPanel7.setRequestFocusEnabled(true);
        jPanel7.setPreferredSize(new Dimension(900, 870));
        jPanel7.setFocusTraversalPolicyProvider(false);
        this.myContentPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(20, 30, 0, 30), -1, -1, false, false));
        jPanel6.setFocusCycleRoot(true);
        jPanel6.setFocusable(true);
        jPanel6.setFocusTraversalPolicyProvider(true);
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myUpperPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(15, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setFocusable(true);
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        Font font = jBLabel4.getFont();
        if (font != null) {
            jBLabel4.setFont(new Font(font.getName(), font.getStyle(), 14));
        }
        jBLabel4.setFocusable(false);
        jBLabel4.setText("URL Mapping");
        jPanel5.add((Component)jBLabel4, new GridConstraints(7, 0, 1, 3, 8, 0, 1, 0, null, null, null));
        this.myToolbarPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel4.setFocusable(false);
        ((Component)jPanel4).setBackground(new Color(-1513240));
        jPanel5.add((Component)jPanel4, new GridConstraints(9, 0, 1, 3, 0, 3, 7, 0, new Dimension(-1, 150), new Dimension(-1, 230), null));
        this.myPanelDescriptionLabel = jTextPane3 = new JTextPane();
        ((Component)jTextPane3).setFont(UIManager.getFont("Label.font"));
        jTextPane3.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        jTextPane3.setFocusCycleRoot(false);
        jTextPane3.setEditable(false);
        ((Component)jTextPane3).setBackground(new Color(-1513240));
        jTextPane3.setFocusable(false);
        jTextPane3.setContentType("text/html");
        jTextPane3.putClientProperty("html.disable", Boolean.TRUE);
        jTextPane3.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.FALSE);
        jTextPane3.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel5.add((Component)jTextPane3, new GridConstraints(3, 0, 1, 3, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        Font font2 = jBLabel5.getFont();
        if (font2 != null) {
            jBLabel5.setFont(new Font(font2.getName(), font2.getStyle(), 14));
        }
        jBLabel5.setFocusable(false);
        jBLabel5.setText("Check URL Mapping");
        jPanel5.add((Component)jBLabel5, new GridConstraints(11, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myTestUrlTextField = jBTextField = new JBTextField();
        jBTextField.setToolTipText("Please input your URL here including the scheme");
        jPanel5.add((Component)jBTextField, new GridConstraints(12, 0, 1, 3, 0, 1, 7, 3, new Dimension(200, -1), null, null));
        this.myCheckMappingResultTextPane = jTextPane2 = new JTextPane();
        ((Component)jTextPane2).setFont(UIManager.getFont("Label.font"));
        jTextPane2.setAlignmentX(0.5f);
        jTextPane2.setMargin(new Insets(0, 0, 0, 0));
        jTextPane2.setFocusCycleRoot(false);
        jTextPane2.setAlignmentY(0.0f);
        jTextPane2.setEditable(false);
        ((Component)jTextPane2).setBackground(new Color(-1513240));
        jTextPane2.setFocusable(false);
        jTextPane2.setContentType("text/html");
        jTextPane2.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel5.add((Component)jTextPane2, new GridConstraints(13, 0, 1, 3, 0, 3, 6, 1, new Dimension(-1, 15), null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(6, 0, 1, 3, 0, 3, 1, 6, null, new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(10, 0, 1, 3, 0, 3, 1, 0, null, new Dimension(-1, 15), new Dimension(-1, 15)));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setIconTextGap(6);
        jBLabel6.setIcon(new ImageIcon(this.getClass().getResource("/url_assistant/step_one.png")));
        jBLabel6.setFocusable(false);
        jPanel5.add((Component)jBLabel6, new GridConstraints(0, 0, 2, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySmallTitleLabel = jBLabel3 = new JBLabel();
        jBLabel3.setAlignmentX(1.0f);
        jBLabel3.setAlignmentY(0.0f);
        jBLabel3.setVerticalTextPosition(3);
        jBLabel3.setForeground(new Color(-11513776));
        jBLabel3.setVerticalAlignment(3);
        Font font3 = jBLabel3.getFont();
        if (font3 != null) {
            jBLabel3.setFont(new Font(font3.getName(), font3.getStyle(), 12));
        }
        jBLabel3.setFocusable(false);
        jBLabel3.setText("Android App Links Support");
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 10, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setAlignmentY(0.0f);
        jBLabel7.setVerticalTextPosition(1);
        jBLabel7.setVerticalAlignment(1);
        Font font4 = jBLabel7.getFont();
        if (font4 != null) {
            jBLabel7.setFont(new Font(font4.getName(), font4.getStyle(), 22));
        }
        jBLabel7.setFocusable(false);
        jBLabel7.setText("URL-to-Activity mappings");
        jPanel5.add((Component)jBLabel7, new GridConstraints(1, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        Font font5 = jSeparator.getFont();
        if (font5 != null) {
            jSeparator.setFont(new Font(font5.getName(), 1, font5.getSize()));
        }
        jPanel5.add((Component)jSeparator, new GridConstraints(5, 0, 1, 3, 0, 1, 6, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), null));
        Spacer spacer6 = new Spacer();
        jPanel5.add((Component)spacer6, new GridConstraints(8, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 2), null));
        this.myTestUrlPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        ((Component)jPanel3).setVisible(false);
        jPanel5.add((Component)jPanel3, new GridConstraints(14, 0, 1, 3, 9, 0, 3, 1, null, null, null));
        this.myTestUrlAddedLabel = jBLabel2 = new JBLabel();
        jBLabel2.setForeground(new Color(-11513776));
        jBLabel2.setFocusable(false);
        jBLabel2.setText("The URL was already added as a test URL.");
        jPanel3.add((Component)jBLabel2, "labelCard");
        this.myAddAsTestUrlButton = jButton2 = new JButton();
        jButton2.setPreferredSize(new Dimension(30, 31));
        jButton2.setMaximumSize(new Dimension(30, 31));
        jButton2.setMinimumSize(new Dimension(30, 31));
        jButton2.setText("Add as a test URL");
        ((Component)jButton2).setVisible(false);
        jPanel3.add((Component)jButton2, "buttonCard");
        this.myPreviewTitleLabel = jBLabel = new JBLabel();
        Font font6 = jBLabel.getFont();
        if (font6 != null) {
            jBLabel.setFont(new Font(font6.getName(), font6.getStyle(), 14));
        }
        jBLabel.setFocusable(false);
        jBLabel.setText("");
        jPanel6.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLowerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, "Card1");
        this.myManifestJPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setFocusable(false);
        jPanel.setToolTipText("This is the preview of the AndroidManifest file");
        jPanel8.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, new Dimension(-1, 230), new Dimension(-1, 230), null));
        this.myOpenAndroidManifestButton = jButton = new JButton();
        jButton.setDoubleBuffered(true);
        jButton.setText("Open AndroidManfest.xml");
        jPanel8.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.setFocusable(false);
        jPanel2.add((Component)jPanel9, "Card2");
        this.myPreviewInstructionTextPane = jTextPane = new JTextPane();
        ((Component)jTextPane).setFont(UIManager.getFont("Label.font"));
        jTextPane.setText("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n");
        jTextPane.setFocusCycleRoot(false);
        jTextPane.setEditable(false);
        jTextPane.setFocusable(false);
        jTextPane.setContentType("text/html");
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel9.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel6.add((Component)spacer7, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        Spacer spacer8 = new Spacer();
        jPanel6.add((Component)spacer8, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 7), new Dimension(-1, 7)));
        jButton.setNextFocusableComponent((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    protected static class DeepLinksTableModel
    extends DefaultTableModel {
        private DeepLinks myDeepLinksData = new DeepLinks();

        public DeepLinksTableModel(boolean showOrder) {
            super(showOrder ? COLUMN_NAMES_WITH_ORDER : COLUMN_NAMES, 0);
        }

        @Override
        public Object getValueAt(int row, int column) {
            DeepLinks.DeepLink data = (DeepLinks.DeepLink)this.myDeepLinksData.getDeepLinkList().get(row);
            switch (column) {
                case 0: {
                    return data.getUrl();
                }
                case 1: {
                    return data.getPath();
                }
                case 2: {
                    return data.getActivityData();
                }
                case 3: {
                    return data.getOrder();
                }
            }
            throw new ArrayIndexOutOfBoundsException("column:" + column + "is invalid.");
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRowCount() {
            if (this.myDeepLinksData == null) {
                return 0;
            }
            return this.myDeepLinksData.getDeepLinkList().size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @NotNull
        public DeepLinks.DeepLink getRowAt(int row) {
            return (DeepLinks.DeepLink)this.myDeepLinksData.getDeepLinkList().get(row);
        }

        public int addRow(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData path, @NotNull ActivityData activity, boolean supportOrder) {
            int index = this.myDeepLinksData.addLink(order, url, path, activity, supportOrder);
            this.fireTableDataChanged();
            return index;
        }

        @Override
        public void removeRow(int row) {
            this.myDeepLinksData.removeLinkAt(row);
            this.fireTableRowsDeleted(row, row);
        }

        public int updateRow(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData path, @NotNull ActivityData activity, boolean supportOrder, int row) {
            int index = this.myDeepLinksData.updateLink(order, url, path, activity, supportOrder, row);
            this.fireTableDataChanged();
            return index;
        }

        public void setDeepLinksData(@NotNull DeepLinks deepLinks) {
            this.myDeepLinksData = deepLinks;
            this.fireTableDataChanged();
        }

        public void clear() {
            this.myDeepLinksData.clear();
            this.fireTableDataChanged();
        }

        @NotNull
        public ImmutableList<DeepLinks.DeepLink> getDeepLinkData() {
            return this.myDeepLinksData.getDeepLinkList();
        }
    }

    private static class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final int LEFT_MARGIN = 6;

        private HeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value.toString());
            EmptyBorder margin = new EmptyBorder(0, 6, 0, 0);
            this.setBorder(new CompoundBorder(null, margin));
            return this;
        }
    }
}

