/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.builder.model.SigningConfig;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DalUtils {
    private static final String ASSET_STATEMENTS = "asset_statements";
    private static final String STRING_ASSET_STATEMENTS = "@string/asset_statements";
    private static final String RESOURCE = "resource";
    private static final String AUTO_VERIFY = "autoVerify";
    private static final String DAL_HANDLE_URL_STATEMENT = "{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%1$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%2$s\"]\n  }\n}";
    private static final String DAL_SMART_LOCK_STATEMENT = ",\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"web\",\n    \"site\": \"%1$s\"\n  }\n},\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%2$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%3$s\"]\n  }\n}";
    private static final String DAL_STRING_RES = "[{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"web\",\n    \"site\": \"%1$s\",\n  }\n}]";

    private static Logger getLog() {
        return Logger.getInstance(DalUtils.class);
    }

    @NotNull
    public static FullUrl getFullUrlWithHttps(@NotNull String domain) throws MalformedURLException {
        FullUrl fullUrl = new FullUrl(domain.contains("://") ? domain : "https://" + domain);
        fullUrl.setScheme("https");
        return fullUrl;
    }

    @NotNull
    public static String getDalFileText(@NotNull String packageId, @NotNull String keystoreFingerprint, @Nullable String signInUrl) {
        String res = String.format(DAL_HANDLE_URL_STATEMENT, packageId, keystoreFingerprint);
        if (signInUrl != null) {
            res = res + String.format(DAL_SMART_LOCK_STATEMENT, signInUrl, packageId, keystoreFingerprint);
        }
        return "[" + res + "]";
    }

    @NotNull
    public static String getDalStringResText(@NotNull String domain) {
        return String.format(DAL_STRING_RES, domain);
    }

    @Nullable
    public static VirtualFile addDalStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        try {
            ResourceItem resourceItem;
            List itemList;
            Project project = facet.getModule().getProject();
            Module baseModule = InstantApps.findBaseFeature((Project)project);
            if (baseModule != null) {
                facet = AndroidFacet.getInstance((Module)baseModule);
            }
            if ((itemList = AppResourceRepository.getOrCreateInstance((AndroidFacet)facet).getResourceItem(ResourceType.STRING, ASSET_STATEMENTS)) == null || itemList.isEmpty()) {
                resourceItem = StringsWriteUtils.createItem((AndroidFacet)facet, (VirtualFile)facet.getPrimaryResourceDir(), null, (String)ASSET_STATEMENTS, (String)statementText, (boolean)false);
            } else {
                for (ResourceItem item : itemList) {
                    StringsWriteUtils.setItemText((Project)project, (ResourceItem)item, (String)statementText);
                }
                resourceItem = (ResourceItem)itemList.get(0);
            }
            if (resourceItem == null) {
                return null;
            }
            return StorageUtilKt.getOrCreateVirtualFile(null, (Path)resourceItem.getFile().toPath());
        }
        catch (Exception e) {
            DalUtils.getLog().warn("Couldn't find string res file when adding asset statements", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String loadSigningConfigsFromGradle(@NotNull Module module, @NotNull List<SigningConfig> result) {
        AndroidModel androidModel;
        result.clear();
        String packageId = "";
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get((Module)module);
        if (androidModuleModel == null) {
            return packageId;
        }
        Collection signingConfigCollection = androidModuleModel.getAndroidProject().getSigningConfigs();
        result.addAll(signingConfigCollection);
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null && (androidModel = androidFacet.getAndroidModel()) != null) {
            packageId = androidModel.getApplicationId();
        }
        return packageId;
    }

    @NotNull
    public static List<AndroidFacet> addMetaDataToAndroidManifest(@NotNull AndroidFacet facet) {
        ArrayList<AndroidFacet> resultFacets = new ArrayList<AndroidFacet>();
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        List<Object> facetList = baseModule == null ? new ArrayList<AndroidFacet>(Arrays.asList(facet)) : UrlAssistUtils.getFacets(project);
        Map<AndroidFacet, Manifest> facetManifestMap = facetList.stream().filter(f -> f.getMainIdeaSourceProvider().getManifestFile() != null).collect(Collectors.toMap(f -> f, AndroidFacet::getManifest));
        facetList = facetList.stream().filter(facetManifestMap::containsKey).collect(Collectors.toList());
        for (AndroidFacet androidFacet : facetList) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(facetManifestMap.get(androidFacet).getXmlTag(), "application");
            if (applications.size() <= 0 || !DalUtils.setAttributeOnTag(applications.get(0))) continue;
            resultFacets.add(androidFacet);
        }
        return resultFacets;
    }

    private static boolean setAttributeOnTag(@NotNull XmlTag applicationTag) {
        List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
        try {
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
                subTag.setAttribute(RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
                return true;
            }
            String prefix = applicationTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            XmlTag metaData = applicationTag.createChildTag("meta-data", null, null, false);
            if (metaData == null) {
                return false;
            }
            metaData.setAttribute(prefix + ":" + "name", "http://schemas.android.com/apk/res/android", ASSET_STATEMENTS);
            metaData.setAttribute(prefix + ":" + RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
            applicationTag.addSubTag(metaData, true);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public static boolean addAutoVerifyToAppLinks(@NotNull AndroidFacet facet) {
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return false;
        }
        List activityList = application.getActivities();
        for (Activity activity : activityList) {
            for (IntentFilter intentFilter : activity.getIntentFilters()) {
                if (!ManifestUtils.isValidAppLink(intentFilter.getXmlTag())) continue;
                XmlTag xmlTag = intentFilter.getXmlTag();
                xmlTag.setAttribute(AUTO_VERIFY, "http://schemas.android.com/apk/res/android", "true");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getDalJsonFileUrl(@NotNull String domain) {
        return domain + "/.well-known/assetlinks.json";
    }

    public static class SigningConfigComboBoxModel
    implements ComboBoxModel<String> {
        private List<SigningConfig> configList;
        private int selectedIndex = 0;

        public SigningConfigComboBoxModel(@NotNull List<SigningConfig> list) {
            this.configList = list;
        }

        @Nullable
        public SigningConfig getSelectedSigningConfig() {
            try {
                return this.configList.get(this.selectedIndex);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.configList.size(); ++i) {
                if (!this.configList.get(i).getName().equals(anItem)) continue;
                this.selectedIndex = i;
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                return this.configList.get(this.selectedIndex).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this.configList != null ? this.configList.size() : 0;
        }

        @Override
        public String getElementAt(int index) {
            try {
                return this.configList.get(index).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

