/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.DalUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DalVerifier {
    private HttpConfigurable myHttpConfigurable = HttpConfigurable.getInstance();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ErrorMessage validateAssetLinksFile(@NotNull String packageName, @NotNull String domain, @NotNull String fingerPrints, boolean forSmartLock) {
        InputStream is;
        String Url = "https://digitalassetlinks.googleapis.com/v1/assetlinks:check?source.web.site=" + domain + "&relation=delegate_permission/" + (forSmartLock ? "common.get_login_creds" : "common.handle_all_urls") + "&target.android_app.package_name=" + packageName + "&target.android_app.certificate.sha256_fingerprint=" + fingerPrints;
        String jsonFileUrl = DalUtils.getDalJsonFileUrl(domain);
        try {
            URLConnection urlConnection = this.myHttpConfigurable.openConnection(Url);
            urlConnection.connect();
            is = urlConnection.getInputStream();
        }
        catch (IOException e) {
            return new ErrorMessage(ErrorCode.ERROR_CODE_NETWORK_ERROR).setJsonFileUrl(jsonFileUrl);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            JSONObject jsonObject = new JSONObject(response.toString());
            if (jsonObject.optBoolean("linked", false)) {
                ErrorMessage errorMessage = new ErrorMessage(ErrorCode.SUCCESS).setJsonFileUrl(jsonFileUrl);
                return errorMessage;
            }
            JSONArray errorCodeArray = jsonObject.optJSONArray("errorCode");
            if (errorCodeArray == null) {
                ErrorMessage errorMessage = new ErrorMessage(ErrorCode.ERROR_CODE_NOT_ASSOCIATED).setJsonFileUrl(jsonFileUrl);
                return errorMessage;
            }
            String errorCodeString = errorCodeArray.optString(0);
            ErrorMessage errorMessage = new ErrorMessage(ErrorCode.valueOf(errorCodeString)).setJsonFileUrl(jsonFileUrl);
            return errorMessage;
        }
        catch (IOException | IllegalArgumentException | JSONException e) {
            return new ErrorMessage(ErrorCode.ERROR_CODE_SERVER_ERROR).setJsonFileUrl(jsonFileUrl);
        }
    }

    public static final class ErrorMessage {
        private ErrorCode myErrorCode;
        private String myJsonFileUrl;

        public ErrorMessage(@NotNull ErrorCode errorCode) {
            this.myErrorCode = errorCode;
        }

        @NotNull
        public ErrorMessage setJsonFileUrl(@NotNull String jsonFileUrl) {
            this.myJsonFileUrl = jsonFileUrl;
            return this;
        }

        @NotNull
        public ErrorCode getErrorCode() {
            return this.myErrorCode;
        }

        @NotNull
        public String toMessage() {
            return UrlAssistantBundle.message(this.myErrorCode.getMessageKey(), this.myJsonFileUrl);
        }
    }

    public static enum ErrorCode {
        SUCCESS("dal.verify.success"),
        ERROR_CODE_NOT_ASSOCIATED("dal.verify.error.not.associated"),
        ERROR_CODE_UNSPECIFIED("dal.verify.error.invalid.query"),
        ERROR_CODE_INVALID_QUERY("dal.verify.error.invalid.query"),
        ERROR_CODE_FETCH_ERROR("dal.verify.error.fetch.error"),
        ERROR_CODE_FAILED_SSL_VALIDATION("dal.verify.error.failed.ssl.validation"),
        ERROR_CODE_REDIRECT("dal.verify.error.fetch.error"),
        ERROR_CODE_TOO_LARGE("dal.verify.error.too.large"),
        ERROR_CODE_MALFORMED_HTTP_RESPONSE("dal.verify.error.malformed.http.response"),
        ERROR_CODE_WRONG_CONTENT_TYPE("dal.verify.error.wrong.content.type"),
        ERROR_CODE_MALFORMED_CONTENT("dal.verify.error.malformed.content"),
        ERROR_CODE_SECURE_ASSET_INCLUDES_INSECURE("dal.verify.error.secure.include.insecure"),
        ERROR_CODE_NETWORK_ERROR("dal.verify.error.network.error"),
        ERROR_CODE_SERVER_ERROR("dal.verify.error.invalid.query");

        private String myMessageKey;

        private ErrorCode(String messageKey) {
            this.myMessageKey = messageKey;
        }

        @NotNull
        public String getMessageKey() {
            return this.myMessageKey;
        }
    }
}

