/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="HgGlobalSettings", storages={@Storage(value="hg.xml", roamingType=RoamingType.PER_OS), @Storage(value="vcs.xml", deprecated=true)})
public class HgGlobalSettings
implements PersistentStateComponent<State> {
    @NonNls
    private static final String[] DEFAULT_WINDOWS_PATHS = new String[]{"C:\\Program Files\\Mercurial", "C:\\Program Files (x86)\\Mercurial", "C:\\cygwin\\bin"};
    @NonNls
    private static final String[] DEFAULT_UNIX_PATHS = new String[]{"/usr/local/bin", "/usr/bin", "/opt/local/bin", "/opt/bin", "/usr/local/mercurial"};
    @NonNls
    private static final String DEFAULT_WINDOWS_HG = "hg.exe";
    @NonNls
    private static final String DEFAULT_UNIX_HG = "hg";
    private static final int FIVE_MINUTES = 300;
    private State myState = new State();
    private String myDetectedHgExecutable;

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    @NotNull
    public String defaultHgExecutable() {
        String hgExecutable = this.myState.myHgExecutable;
        if (hgExecutable != null) {
            return hgExecutable;
        }
        if (this.myDetectedHgExecutable == null) {
            String[] paths;
            String programName;
            if (SystemInfo.isWindows) {
                programName = DEFAULT_WINDOWS_HG;
                paths = DEFAULT_WINDOWS_PATHS;
            } else {
                programName = DEFAULT_UNIX_HG;
                paths = DEFAULT_UNIX_PATHS;
            }
            for (String p : paths) {
                File f = new File(p, programName);
                if (!f.exists()) continue;
                this.myDetectedHgExecutable = f.getAbsolutePath();
                break;
            }
            if (this.myDetectedHgExecutable == null) {
                this.myDetectedHgExecutable = programName;
            }
        }
        return this.myDetectedHgExecutable;
    }

    @Nullable
    public String getRememberedUserName(@NotNull String stringUrl) {
        return this.myState.myRememberedUserNames.get(stringUrl);
    }

    public void addRememberedUrl(@Nullable String stringUrl, @Nullable String username) {
        if (StringUtil.isEmptyOrSpaces((String)stringUrl)) {
            return;
        }
        if (username == null) {
            username = "";
        }
        this.myState.myRememberedUserNames.put(stringUrl, username);
    }

    @NotNull
    public String getHgExecutable() {
        return this.myState.myHgExecutable == null ? this.defaultHgExecutable() : this.myState.myHgExecutable;
    }

    public void setHgExecutable(String hgExecutable) {
        this.myState.myHgExecutable = hgExecutable;
    }

    public static int getIncomingCheckIntervalSeconds() {
        return 300;
    }

    public static class State {
        public String myHgExecutable = null;
        public Map<String, String> myRememberedUserNames = new HashMap();
    }
}

