/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.status.ui.HgHideableWidget;
import org.zmlx.hg4idea.ui.HgConfigurationProjectPanel;

public class HgProjectConfigurable
implements SearchableConfigurable {
    public static final String DISPLAY_NAME = HgVcsMessages.message("hg4idea.mercurial", new Object[0]);
    private final HgConfigurationProjectPanel myPanel;
    @NotNull
    private final Project myProject;

    public HgProjectConfigurable(@NotNull Project project, HgProjectSettings projectSettings) {
        this.myProject = project;
        this.myPanel = new HgConfigurationProjectPanel(projectSettings, this.myProject);
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.Mercurial";
    }

    public JComponent createComponent() {
        return this.myPanel.getPanel();
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.saveSettings();
        if (this.myPanel.getProjectSettings().isCheckIncomingOutgoing()) {
            ((HgHideableWidget)this.myProject.getMessageBus().syncPublisher(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC)).show();
        } else {
            ((HgHideableWidget)this.myProject.getMessageBus().syncPublisher(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC)).hide();
        }
    }

    public void reset() {
        this.myPanel.loadSettings();
    }

    public void disposeUIResources() {
    }

    @NotNull
    public String getId() {
        return "Mercurial.Project";
    }
}

