/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgCommonBranchActions
extends BranchActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected String myBranchName;
    @NotNull
    List<HgRepository> myRepositories;

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRepositories = repositories;
        this.getTemplatePresentation().setText(this.myBranchName, false);
        this.getTemplatePresentation().setIcon(null);
        this.getTemplatePresentation().setHoveredIcon(null);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return new AnAction[]{new UpdateAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName)};
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        public UpdateAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, "Update", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            HgUpdateCommand.updateTo(this.myBranchName, this.myRepositories, null);
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        public MergeAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, "Merge", repositories, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            UpdatedFiles updatedFiles = UpdatedFiles.create();
            for (HgRepository repository : this.myRepositories) {
                HgMergeCommand.mergeWith(repository, this.myBranchName, updatedFiles);
            }
        }
    }
}

