/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.command.HgRemoteChangesetsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgRemoteCommandExecutor;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgOutgoingCommand
extends HgRemoteChangesetsCommand {
    public HgOutgoingCommand(Project project) {
        super(project, "outgoing");
    }

    @Override
    @Nullable
    protected String getRepositoryUrl(VirtualFile root) {
        return HgUtil.getRepositoryDefaultPushPath(this.project, root);
    }

    @Nullable
    public HgCommandResult execute(@NotNull VirtualFile repo, @NotNull String template, @NotNull String source, @NotNull String destination, boolean doNotShowAuthorizationRequest) {
        LinkedList<String> arguments = new LinkedList<String>();
        arguments.add("-n");
        arguments.add("--template");
        arguments.add(template);
        arguments.add(HgHistoryUtil.prepareParameter("rev", source));
        arguments.add(destination);
        HgRemoteCommandExecutor commandExecutor = new HgRemoteCommandExecutor(this.project, destination, ModalityState.any(), doNotShowAuthorizationRequest);
        commandExecutor.setOutputAlwaysSuppressed(true);
        return commandExecutor.executeInCurrentThread(repo, "outgoing", arguments);
    }
}

