/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HgRefManager
implements VcsLogRefManager {
    private static final Color CLOSED_BRANCH_COLOR = new JBColor(new Color(8532281), new Color(0xFF5F6F));
    private static final Color LOCAL_TAG_COLOR = new JBColor(new Color(37008), new Color(62451));
    private static final Color MQ_TAG_COLOR = new JBColor(new Color(12176), new Color(22015));
    public static final VcsRefType TIP = new SimpleRefType("TIP", true, VcsLogStandardColors.Refs.TIP);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, VcsLogStandardColors.Refs.LEAF);
    public static final VcsRefType BRANCH = new SimpleRefType("BRANCH", true, VcsLogStandardColors.Refs.BRANCH);
    public static final VcsRefType CLOSED_BRANCH = new SimpleRefType("CLOSED_BRANCH", false, CLOSED_BRANCH_COLOR);
    public static final VcsRefType BOOKMARK = new SimpleRefType("BOOKMARK", true, VcsLogStandardColors.Refs.BRANCH_REF);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, VcsLogStandardColors.Refs.TAG);
    public static final VcsRefType LOCAL_TAG = new SimpleRefType("LOCAL_TAG", false, LOCAL_TAG_COLOR);
    public static final VcsRefType MQ_APPLIED_TAG = new SimpleRefType("MQ_TAG", false, MQ_TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(TIP, HEAD, BRANCH, BOOKMARK, TAG);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(TIP, HEAD, BRANCH, CLOSED_BRANCH, BOOKMARK, TAG, LOCAL_TAG, MQ_APPLIED_TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = new Comparator<VcsRefType>(){

        @Override
        public int compare(VcsRefType type1, VcsRefType type2) {
            int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
            int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
            return p1 - p2;
        }
    };
    private static final String DEFAULT = "default";
    private final Comparator<VcsRef> REF_COMPARATOR = new Comparator<VcsRef>(){

        @Override
        public int compare(VcsRef ref1, VcsRef ref2) {
            VcsRefType type2;
            VcsRefType type1 = ref1.getType();
            int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
            if (typeComparison != 0) {
                return typeComparison;
            }
            int nameComparison = ref1.getName().compareTo(ref2.getName());
            if (nameComparison != 0) {
                if (type1 == BRANCH) {
                    if (ref1.getName().equals(HgRefManager.DEFAULT)) {
                        return -1;
                    }
                    if (ref2.getName().equals(HgRefManager.DEFAULT)) {
                        return 1;
                    }
                }
                return nameComparison;
            }
            return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
        }
    };

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        return this.REF_COMPARATOR;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<VcsRef> refs) {
        return ContainerUtil.map(this.sort(refs), (Function)new Function<VcsRef, RefGroup>(){

            public RefGroup fun(VcsRef ref) {
                return new SingletonRefGroup(ref);
            }
        });
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<VcsRef> references, boolean compact, boolean showTagNames) {
        List<VcsRef> sortedReferences = this.sort(references);
        MultiMap groupedRefs = ContainerUtil.groupBy(sortedReferences, VcsRef::getType);
        ArrayList result = ContainerUtil.newArrayList();
        List headAndTip = ContainerUtil.filter((Collection)groupedRefs.entrySet(), entry -> ((VcsRefType)entry.getKey()).equals(HEAD) || ((VcsRefType)entry.getKey()).equals(TIP));
        headAndTip.forEach(entry -> groupedRefs.remove(entry.getKey()));
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, (List)result);
        RefGroup firstGroup = (RefGroup)ContainerUtil.getFirstItem((List)result);
        if (firstGroup != null) {
            firstGroup.getRefs().addAll(0, headAndTip.stream().flatMap(entry -> ((Collection)entry.getValue()).stream()).collect(Collectors.toList()));
        }
        return result;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        return REF_TYPE_INDEX.get(id);
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        return this.REF_COMPARATOR;
    }

    @NotNull
    private List<VcsRef> sort(@NotNull Collection<VcsRef> refs) {
        return ContainerUtil.sorted(refs, this.getLabelsOrderComparator());
    }

    private static class SimpleRefType
    implements VcsRefType {
        @NotNull
        private final String myName;
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;

        public SimpleRefType(@NotNull String name, boolean isBranch, @NotNull Color color) {
            this.myName = name;
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            return this.myColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleRefType type = (SimpleRefType)o;
            return this.myIsBranch == type.myIsBranch && Objects.equals(this.myName, type.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.myIsBranch);
        }
    }
}

