/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.repo.AsyncFilesManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgLocalIgnoredHolder
implements Disposable {
    private static final Logger LOG = Logger.getInstance(HgLocalIgnoredHolder.class);
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final AtomicBoolean myInUpdateMode;
    @NotNull
    private final HgRepository myRepository;
    @NotNull
    private final Set<VirtualFile> myIgnoredSet;
    @NotNull
    private final ReentrantReadWriteLock SET_LOCK = new ReentrantReadWriteLock();
    private final EventDispatcher<AsyncFilesManagerListener> myListeners = EventDispatcher.create(AsyncFilesManagerListener.class);

    public HgLocalIgnoredHolder(@NotNull HgRepository repository) {
        this.myRepository = repository;
        this.myIgnoredSet = ContainerUtil.newHashSet();
        this.myInUpdateMode = new AtomicBoolean(false);
        this.myUpdateQueue = new MergingUpdateQueue("HgIgnoreUpdate", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void addUpdateStateListener(@NotNull AsyncFilesManagerListener listener) {
        this.myListeners.addListener((EventListener)listener, (Disposable)this);
    }

    public void startRescan() {
        this.myUpdateQueue.queue(new Update("hgRescanIgnored"){

            public boolean canEat(Update update) {
                return true;
            }

            public void run() {
                if (HgLocalIgnoredHolder.this.myInUpdateMode.compareAndSet(false, true)) {
                    HgLocalIgnoredHolder.this.fireUpdateStarted();
                    HgLocalIgnoredHolder.this.rescanAllIgnored();
                    HgLocalIgnoredHolder.this.myInUpdateMode.set(false);
                    HgLocalIgnoredHolder.this.fireUpdateFinished();
                }
            }
        });
    }

    private void fireUpdateStarted() {
        ((AsyncFilesManagerListener)this.myListeners.getMulticaster()).updateStarted();
    }

    private void fireUpdateFinished() {
        ((AsyncFilesManagerListener)this.myListeners.getMulticaster()).updateFinished();
    }

    private void rescanAllIgnored() {
        HashSet ignored = ContainerUtil.newHashSet();
        try {
            ignored.addAll(new HgStatusCommand.Builder(false).ignored(true).build(this.myRepository.getProject()).getFiles(this.myRepository.getRoot(), null));
        }
        catch (VcsException e) {
            LOG.error("Can't reload ignored files for: " + this.myRepository.getPresentableUrl(), (Throwable)e);
            return;
        }
        try {
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.clear();
            this.myIgnoredSet.addAll(ignored);
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<FilePath> removeIgnoredFiles(@NotNull Collection<FilePath> files) {
        ArrayList removedIgnoredFiles = ContainerUtil.newArrayList();
        try {
            this.SET_LOCK.writeLock().lock();
            Iterator<VirtualFile> iter = this.myIgnoredSet.iterator();
            while (iter.hasNext()) {
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)iter.next());
                if (!files.contains(filePath)) continue;
                iter.remove();
                removedIgnoredFiles.add(filePath);
            }
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
        return removedIgnoredFiles;
    }

    public void addFiles(@NotNull List<VirtualFile> files) {
        try {
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.addAll(files);
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    public boolean contains(@NotNull VirtualFile file) {
        try {
            this.SET_LOCK.readLock().lock();
            boolean bl = this.myIgnoredSet.contains(file);
            return bl;
        }
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }

    public boolean isInUpdateMode() {
        return this.myInUpdateMode.get();
    }

    @NotNull
    public Set<VirtualFile> getIgnoredFiles() {
        try {
            this.SET_LOCK.readLock().lock();
            HashSet hashSet = ContainerUtil.newHashSet(this.myIgnoredSet);
            return hashSet;
        }
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }

    public void dispose() {
        try {
            this.myUpdateQueue.cancelAllUpdates();
            this.SET_LOCK.writeLock().lock();
            this.myIgnoredSet.clear();
        }
        finally {
            this.SET_LOCK.writeLock().unlock();
        }
    }

    public int getSize() {
        try {
            this.SET_LOCK.readLock().lock();
            int n = this.myIgnoredSet.size();
            return n;
        }
        finally {
            this.SET_LOCK.readLock().unlock();
        }
    }
}

