/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;

public class HgAnnotation
extends FileAnnotation {
    private StringBuilder myContentBuffer;
    private final HgLineAnnotationAspect dateAnnotationAspect = new HgLineAnnotationAspect(FIELD.DATE);
    private final HgLineAnnotationAspect userAnnotationAspect = new HgLineAnnotationAspect(FIELD.USER);
    private final HgLineAnnotationAspect revisionAnnotationAspect = new HgLineAnnotationAspect(FIELD.REVISION);
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<HgAnnotationLine> myLines;
    @NotNull
    private final List<HgFileRevision> myFileRevisions;
    @NotNull
    private final HgFile myFile;
    private final VcsRevisionNumber myCurrentRevision;

    public HgAnnotation(@NotNull Project project, @NotNull HgFile hgFile, @NotNull List<HgAnnotationLine> lines, @NotNull List<HgFileRevision> vcsFileRevisions, VcsRevisionNumber revision) {
        super(project);
        this.myProject = project;
        this.myLines = lines;
        this.myFileRevisions = vcsFileRevisions;
        this.myFile = hgFile;
        this.myCurrentRevision = revision;
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    public void dispose() {
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.revisionAnnotationAspect, this.dateAnnotationAspect, this.userAnnotationAspect};
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        if (this.myLines.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        HgAnnotationLine info = this.myLines.get(lineNumber);
        if (info == null) {
            return null;
        }
        for (HgFileRevision revision : this.myFileRevisions) {
            if (!revision.getRevisionNumber().equals(info.getVcsRevisionNumber())) continue;
            return HgVcsMessages.message("hg4idea.annotation.tool.tip", revision.getRevisionNumber().asString(), revision.getAuthor(), revision.getRevisionDate(), revision.getCommitMessage());
        }
        return null;
    }

    public String getAnnotatedContent() {
        if (this.myContentBuffer == null) {
            this.myContentBuffer = new StringBuilder();
            for (HgAnnotationLine line : this.myLines) {
                this.myContentBuffer.append(line.get(FIELD.CONTENT));
            }
        }
        return this.myContentBuffer.toString();
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (lineNumber >= this.myLines.size() || lineNumber < 0) {
            return null;
        }
        HgAnnotationLine annotationLine = this.myLines.get(lineNumber);
        return annotationLine.getVcsRevisionNumber();
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        if (lineNumber >= this.myLines.size() || lineNumber < 0) {
            return null;
        }
        return null;
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        LinkedList<VcsFileRevision> result = new LinkedList<VcsFileRevision>();
        result.addAll(this.myFileRevisions);
        return result;
    }

    @Nullable
    private static String id(FIELD field) {
        switch (field) {
            case USER: {
                return LineAnnotationAspect.AUTHOR;
            }
            case REVISION: {
                return LineAnnotationAspect.REVISION;
            }
            case DATE: {
                return LineAnnotationAspect.DATE;
            }
        }
        return null;
    }

    private static boolean isShowByDefault(FIELD aspectType) {
        return aspectType == FIELD.DATE || aspectType == FIELD.USER;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public VcsKey getVcsKey() {
        return HgVcs.getKey();
    }

    public VirtualFile getFile() {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile.getFile());
    }

    private class HgLineAnnotationAspect
    extends LineAnnotationAspectAdapter {
        private final FIELD myAspectType;

        HgLineAnnotationAspect(FIELD aspectType) {
            super(HgAnnotation.id(aspectType), HgAnnotation.isShowByDefault(aspectType));
            this.myAspectType = aspectType;
        }

        public String getValue(int lineNumber) {
            if (lineNumber >= HgAnnotation.this.myLines.size() || lineNumber < 0) {
                return "";
            }
            HgAnnotationLine annotationLine = (HgAnnotationLine)HgAnnotation.this.myLines.get(lineNumber);
            return this.myAspectType == FIELD.REVISION ? annotationLine.getVcsRevisionNumber().asString() : annotationLine.get(this.myAspectType).toString();
        }

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < HgAnnotation.this.myLines.size()) {
                HgAnnotationLine line = (HgAnnotationLine)HgAnnotation.this.myLines.get(lineNum);
                VirtualFile file = HgAnnotation.this.myFile.toFilePath().getVirtualFile();
                if (line != null && file != null) {
                    ShowAllAffectedGenericAction.showSubmittedFiles((Project)HgAnnotation.this.myProject, (VcsRevisionNumber)line.getVcsRevisionNumber(), (VirtualFile)file, (VcsKey)HgVcs.getKey());
                }
            }
        }
    }

    public static enum FIELD {
        USER,
        REVISION,
        DATE,
        LINE,
        CONTENT;

    }
}

