/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsErrorHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgOutgoingCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgOutgoingCommitsProvider
extends OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> {
    private static final Logger LOG = Logger.getInstance(HgOutgoingCommitsProvider.class);
    private static final String LOGIN_AND_REFRESH_LINK = "Enter Password & Refresh";

    @NotNull
    public OutgoingResult getOutgoingCommits(@NotNull HgRepository repository, @NotNull PushSpec<HgPushSource, HgTarget> pushSpec, boolean initial) {
        Project project = repository.getProject();
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        HgOutgoingCommand hgOutgoingCommand = new HgOutgoingCommand(project);
        HgTarget hgTarget = (HgTarget)pushSpec.getTarget();
        ArrayList<VcsError> errors = new ArrayList<VcsError>();
        if (StringUtil.isEmptyOrSpaces((String)hgTarget.myTarget)) {
            errors.add(new VcsError("Hg push path could not be empty."));
            return new OutgoingResult(Collections.emptyList(), errors);
        }
        HgCommandResult result = hgOutgoingCommand.execute(repository.getRoot(), HgChangesetUtil.makeTemplate(templates), ((HgPushSource)pushSpec.getSource()).getPresentation(), hgTarget.myTarget, initial);
        if (result == null) {
            errors.add(new VcsError("Couldn't execute hg outgoing command for " + repository));
            return new OutgoingResult(Collections.emptyList(), errors);
        }
        List<String> resultErrors = result.getErrorLines();
        if (resultErrors != null && !resultErrors.isEmpty() && result.getExitValue() != 0) {
            for (String error : resultErrors) {
                if (!HgErrorUtil.isAbortLine(error)) continue;
                if (HgErrorUtil.isAuthorizationError(error)) {
                    VcsError authorizationError = new VcsError(error + "<a href='authenticate'>" + LOGIN_AND_REFRESH_LINK + "</a>", new VcsErrorHandler(){

                        public void handleError(@NotNull CommitLoader commitLoader) {
                            commitLoader.reloadCommits();
                        }
                    });
                    errors.add(authorizationError);
                    continue;
                }
                errors.add(new VcsError(error));
            }
            LOG.warn(resultErrors.toString());
        }
        return new OutgoingResult(HgHistoryUtil.createFullCommitsFromResult(project, repository.getRoot(), result, version, true), errors);
    }
}

