/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.AsyncFilesManagerListener;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgBranchesCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgLocalIgnoredHolder;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepoInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryReader;
import org.zmlx.hg4idea.repo.HgRepositoryUpdater;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRepositoryImpl
extends RepositoryImpl
implements HgRepository {
    private static final Logger LOG = Logger.getInstance(HgRepositoryImpl.class);
    @NotNull
    private HgVcs myVcs;
    @NotNull
    private final HgRepositoryReader myReader;
    @NotNull
    private final VirtualFile myHgDir;
    @NotNull
    private volatile HgRepoInfo myInfo;
    @NotNull
    private Set<String> myOpenedBranches = Collections.emptySet();
    @NotNull
    private volatile HgConfig myConfig;
    private boolean myIsFresh = true;
    private final HgLocalIgnoredHolder myLocalIgnoredHolder;

    private HgRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull HgVcs vcs, @NotNull Disposable parentDisposable) {
        super(vcs.getProject(), rootDir, parentDisposable);
        this.myVcs = vcs;
        this.myHgDir = rootDir.findChild(".hg");
        assert (this.myHgDir != null) : ".hg directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new HgRepositoryReader(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myHgDir));
        this.myConfig = HgConfig.getInstance(this.getProject(), rootDir);
        this.myLocalIgnoredHolder = new HgLocalIgnoredHolder(this);
        Disposer.register((Disposable)this, (Disposable)this.myLocalIgnoredHolder);
        this.myLocalIgnoredHolder.addUpdateStateListener(new MyIgnoredHolderAsyncListener(this.getProject()));
        this.update();
    }

    @NotNull
    public static HgRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
        HgVcs vcs = HgVcs.getInstance(project);
        if (vcs == null) {
            throw new IllegalArgumentException("Vcs not found for project " + project);
        }
        HgRepositoryImpl repository = new HgRepositoryImpl(root, vcs, parentDisposable);
        repository.setupUpdater();
        return repository;
    }

    private void setupUpdater() {
        HgRepositoryUpdater updater = new HgRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
        this.myLocalIgnoredHolder.startRescan();
    }

    @Override
    @NotNull
    public VirtualFile getHgDir() {
        return this.myHgDir;
    }

    @NotNull
    public Repository.State getState() {
        return this.myInfo.getState();
    }

    @Nullable
    public String getCurrentBranchName() {
        String branchOrBookMarkName = this.getCurrentBookmark();
        if (StringUtil.isEmptyOrSpaces((String)branchOrBookMarkName)) {
            branchOrBookMarkName = this.getCurrentBranch();
        }
        return branchOrBookMarkName;
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @Override
    @Nullable
    public String getTipRevision() {
        return this.myInfo.getTipRevision();
    }

    @Override
    @NotNull
    public Map<String, LinkedHashSet<Hash>> getBranches() {
        return this.myInfo.getBranches();
    }

    @Override
    @NotNull
    public Set<String> getOpenedBranches() {
        return this.myOpenedBranches;
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        return this.myInfo.getBookmarks();
    }

    @Override
    @Nullable
    public String getCurrentBookmark() {
        return this.myInfo.getCurrentBookmark();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        return this.myInfo.getTags();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        return this.myInfo.getLocalTags();
    }

    @Override
    @NotNull
    public HgConfig getRepositoryConfig() {
        return this.myConfig;
    }

    @Override
    public boolean hasSubrepos() {
        return this.myInfo.hasSubrepos();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        return this.myInfo.getSubrepos();
    }

    @Override
    @NotNull
    public List<HgNameWithHashInfo> getMQAppliedPatches() {
        return this.myInfo.getMQApplied();
    }

    @Override
    @NotNull
    public List<String> getAllPatchNames() {
        return this.myInfo.getMqPatchNames();
    }

    @Override
    @NotNull
    public List<String> getUnappliedPatchNames() {
        final List<String> appliedPatches = HgUtil.getNamesWithoutHashes(this.getMQAppliedPatches());
        return ContainerUtil.filter(this.getAllPatchNames(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return !appliedPatches.contains(s);
            }
        });
    }

    public boolean isFresh() {
        return this.myIsFresh;
    }

    public void update() {
        HgRepoInfo currentInfo = this.readRepoInfo();
        final Project project = this.getProject();
        if (!project.isDisposed() && !currentInfo.equals(this.myInfo)) {
            this.myInfo = currentInfo;
            HgCommandResult branchCommandResult = new HgBranchesCommand(project, this.getRoot()).collectBranches();
            if (branchCommandResult == null || branchCommandResult.getExitValue() != 0) {
                LOG.warn("Could not collect hg opened branches.");
                this.myOpenedBranches = this.myInfo.getBranches().keySet();
            } else {
                this.myOpenedBranches = HgBranchesCommand.collectNames(branchCommandResult);
            }
            HgUtil.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        ((HgUpdater)project.getMessageBus().syncPublisher(HgVcs.STATUS_TOPIC)).update(project, HgRepositoryImpl.this.getRoot());
                    }
                }
            }, (Disposable)project);
        }
    }

    @NotNull
    public String toLogString() {
        return "HgRepository " + this.getRoot() + " : " + this.myInfo;
    }

    @NotNull
    private HgRepoInfo readRepoInfo() {
        this.myIsFresh = this.myIsFresh && this.myReader.isFresh();
        return new HgRepoInfo(this.myReader.readCurrentBranch(), this.myReader.readCurrentRevision(), this.myReader.readCurrentTipRevision(), this.myReader.readState(), this.myReader.readBranches(), this.myReader.readBookmarks(), this.myReader.readCurrentBookmark(), this.myReader.readTags(), this.myReader.readLocalTags(), this.myReader.readSubrepos(), this.myReader.readMQAppliedPatches(), this.myReader.readMqPatchNames());
    }

    @Override
    public void updateConfig() {
        this.myConfig = HgConfig.getInstance(this.getProject(), this.getRoot());
    }

    @Override
    public HgLocalIgnoredHolder getLocalIgnoredHolder() {
        return this.myLocalIgnoredHolder;
    }

    private static class MyIgnoredHolderAsyncListener
    implements AsyncFilesManagerListener {
        @NotNull
        private final ChangesViewI myChangesViewI;

        public MyIgnoredHolderAsyncListener(@NotNull Project project) {
            this.myChangesViewI = ChangesViewManager.getInstance((Project)project);
        }

        public void updateStarted() {
            this.myChangesViewI.scheduleRefresh();
        }

        public void updateFinished() {
            this.myChangesViewI.scheduleRefresh();
        }
    }
}

