/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgCatCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgBranchReferenceValidator;

public abstract class HgUtil {
    public static final Pattern URL_WITH_PASSWORD = Pattern.compile("(?:.+)://(?:.+)(:.+)@(?:.+)");
    public static final int MANY_FILES = 100;
    private static final Logger LOG = Logger.getInstance(HgUtil.class);
    public static final String DOT_HG = ".hg";
    public static final String TIP_REFERENCE = "tip";
    public static final String HEAD_REFERENCE = "HEAD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToTempFile(String basename, String extension) throws IOException {
        InputStream in = HgUtil.class.getClassLoader().getResourceAsStream("python/" + basename + extension);
        File tempFile = FileUtil.createTempFile((String)basename, (String)extension);
        byte[] buffer = new byte[4096];
        OutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(tempFile, false);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void markDirectoryDirty(Project project, VirtualFile file) throws InvocationTargetException, InterruptedException {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
    }

    public static void markFileDirty(Project project, VirtualFile file) throws InvocationTargetException, InterruptedException {
        ApplicationManager.getApplication().runReadAction(() -> VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file));
        HgUtil.runWriteActionAndWait(() -> file.refresh(true, false));
    }

    public static void runWriteActionAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        GuiUtils.runOrInvokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    public static void runWriteActionLater(@NotNull Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(runnable));
    }

    @Nullable
    public static File getTemporaryPythonFile(String base) {
        try {
            File file = HgUtil.copyResourceToTempFile(base, ".py");
            String fileName = file.getName();
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                File[] files = file.getParentFile().listFiles((dir, name) -> name.startsWith(fileName));
                if (files != null) {
                    for (File file1 : files) {
                        file1.delete();
                    }
                }
            });
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void removeFilesFromVcs(Project project, List<FilePath> files) {
        HgRemoveCommand command = new HgRemoveCommand(project);
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath);
            if (vcsRoot == null) continue;
            command.executeInCurrentThread(new HgFile(vcsRoot, filePath));
        }
    }

    @Nullable
    public static VirtualFile getNearestHgRoot(VirtualFile dir) {
        for (VirtualFile currentDir = dir; currentDir != null; currentDir = currentDir.getParent()) {
            if (!HgUtil.isHgRoot(currentDir)) continue;
            return currentDir;
        }
        return null;
    }

    public static boolean isHgRoot(@Nullable VirtualFile dir) {
        return dir != null && dir.findChild(DOT_HG) != null;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, FilePath filePath) {
        if (project == null) {
            return HgUtil.getNearestHgRoot(VcsUtil.getVirtualFile((String)filePath.getPath()));
        }
        return HgUtil.getNearestHgRoot(VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath));
    }

    @NotNull
    public static Set<VirtualFile> hgRoots(@NotNull Project project, @NotNull Collection<FilePath> filePaths) {
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (FilePath path : filePaths) {
            ContainerUtil.addIfNotNull(roots, (Object)HgUtil.getHgRootOrNull(project, path));
        }
        return roots;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, @NotNull VirtualFile file) {
        return HgUtil.getHgRootOrNull(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, FilePath filePath) throws VcsException {
        VirtualFile vf = HgUtil.getHgRootOrNull(project, filePath);
        if (vf == null) {
            throw new VcsException(HgVcsMessages.message("hg4idea.exception.file.not.under.hg", filePath.getPresentableUrl()));
        }
        return vf;
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, VirtualFile file) throws VcsException {
        return HgUtil.getHgRootOrThrow(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    @Nullable
    public static String getNewBranchNameFromUser(@NotNull HgRepository repository, @NotNull String dialogTitle) {
        return Messages.showInputDialog((Project)repository.getProject(), (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new HgBranchReferenceValidator(repository));
    }

    public static boolean isMergeInProgress(@NotNull Project project, VirtualFile repository) {
        return new HgWorkingCopyRevisionsCommand(project).parents(repository).size() > 1;
    }

    @NotNull
    public static Map<VirtualFile, List<String>> getRelativePathsByRepository(Collection<HgFile> hgFiles) {
        HashMap<VirtualFile, List<String>> map = new HashMap<VirtualFile, List<String>>();
        if (hgFiles == null) {
            return map;
        }
        for (HgFile file : hgFiles) {
            VirtualFile repo = file.getRepo();
            ArrayList<String> files = (ArrayList<String>)map.get(repo);
            if (files == null) {
                files = new ArrayList<String>();
                map.put(repo, files);
            }
            files.add(file.getRelativePath());
        }
        return map;
    }

    @NotNull
    public static HgFile getFileNameInTargetRevision(Project project, HgRevisionNumber vcsRevisionNumber, HgFile localHgFile) {
        HgStatusCommand statCommand = new HgStatusCommand.Builder(false).copySource(true).baseRevision(vcsRevisionNumber).targetRevision(HgRevisionNumber.getInstance("", ".")).build(project);
        Set<HgChange> changes = statCommand.executeInCurrentThread(localHgFile.getRepo(), Collections.singletonList(localHgFile.toFilePath()));
        for (HgChange change : changes) {
            if (!change.afterFile().equals(localHgFile)) continue;
            return change.beforeFile();
        }
        return localHgFile;
    }

    @NotNull
    public static FilePath getOriginalFileName(@NotNull FilePath filePath, ChangeListManager changeListManager) {
        Change change = changeListManager.getChange(filePath);
        if (change == null) {
            return filePath;
        }
        FileStatus status = change.getFileStatus();
        if (status == HgChangeProvider.COPIED || status == HgChangeProvider.RENAMED) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null) : "If a file's status is copied or renamed, there must be an previous version";
            return beforeRevision.getFile();
        }
        return filePath;
    }

    @NotNull
    public static Map<VirtualFile, Collection<VirtualFile>> sortByHgRoots(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        HashMap<VirtualFile, Collection<VirtualFile>> sorted = new HashMap<VirtualFile, Collection<VirtualFile>>();
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (VirtualFile file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<VirtualFile> filesForRoot = (HashSet<VirtualFile>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<VirtualFile>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        return sorted;
    }

    @NotNull
    public static Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots(@NotNull Project project, @NotNull Collection<FilePath> files) {
        HashMap<VirtualFile, Collection<FilePath>> sorted = new HashMap<VirtualFile, Collection<FilePath>>();
        if (project.isDisposed()) {
            return sorted;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (FilePath file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<FilePath> filesForRoot = (HashSet<FilePath>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<FilePath>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        return sorted;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        return BackgroundTaskUtil.executeOnPooledThread((Runnable)runnable, (Disposable)parentDisposable);
    }

    @Nullable
    public static VirtualFile convertToLocalVirtualFile(@Nullable VirtualFile file) {
        if (!(file instanceof AbstractVcsVirtualFile)) {
            return file;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile resultFile = lfs.findFileByPath(file.getPath());
        if (resultFile == null) {
            resultFile = lfs.refreshAndFindFileByPath(file.getPath());
        }
        return resultFile;
    }

    @NotNull
    public static List<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable HgRevisionNumber revNum1, @Nullable HgRevisionNumber revNum2) {
        HgStatusCommand statusCommand;
        if (revNum1 != null) {
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(!path.isDirectory()).baseRevision(revNum1).targetRevision(revNum2).build(project);
        } else {
            LOG.assertTrue(revNum2 != null, (Object)("revision1 and revision2 can't both be null. Path: " + path));
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(revNum2).build(project);
        }
        Set<HgChange> hgChanges = statusCommand.executeInCurrentThread(root, Collections.singleton(path));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HgChange hgChange : hgChanges) {
            FileStatus status = HgUtil.convertHgDiffStatus(hgChange.getStatus());
            if (status == FileStatus.UNKNOWN) continue;
            changes.add(HgHistoryUtil.createChange(project, root, hgChange.beforeFile().getRelativePath(), revNum1, hgChange.afterFile().getRelativePath(), revNum2, status));
        }
        return changes;
    }

    @NotNull
    public static FileStatus convertHgDiffStatus(@NotNull HgFileStatusEnum hgstatus) {
        if (hgstatus.equals((Object)HgFileStatusEnum.ADDED)) {
            return FileStatus.ADDED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.DELETED)) {
            return FileStatus.DELETED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.MODIFIED)) {
            return FileStatus.MODIFIED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.COPY)) {
            return HgChangeProvider.COPIED;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.UNVERSIONED)) {
            return FileStatus.UNKNOWN;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.IGNORED)) {
            return FileStatus.IGNORED;
        }
        return FileStatus.UNKNOWN;
    }

    @NotNull
    public static byte[] loadContent(@NotNull Project project, @Nullable HgRevisionNumber revisionNumber, @NotNull HgFile fileToCat) {
        HgCommandResult result = new HgCatCommand(project).execute(fileToCat, revisionNumber, fileToCat.toFilePath().getCharset());
        return result != null && result.getExitValue() == 0 ? result.getBytesOutput() : ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public static String removePasswordIfNeeded(@NotNull String path) {
        Matcher matcher = URL_WITH_PASSWORD.matcher(path);
        if (matcher.matches()) {
            return path.substring(0, matcher.start(1)) + path.substring(matcher.end(1), path.length());
        }
        return path;
    }

    @NotNull
    public static String getDisplayableBranchOrBookmarkText(@NotNull HgRepository repository) {
        Repository.State state = repository.getState();
        String branchText = "";
        if (state != Repository.State.NORMAL) {
            branchText = branchText + state.toString() + " ";
        }
        return branchText + repository.getCurrentBranchName();
    }

    @NotNull
    public static HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        return (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
    }

    @Nullable
    public static HgRepository getCurrentRepository(@NotNull Project project) {
        if (project.isDisposed()) {
            return null;
        }
        return (HgRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)HgUtil.getRepositoryManager(project), (VirtualFile)DvcsUtil.getSelectedFile((Project)project), (String)HgProjectSettings.getInstance(project).getRecentRootPath());
    }

    @Nullable
    public static HgRepository getRepositoryForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (file == null || project.isDisposed()) {
            return null;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        VirtualFile root = HgUtil.getHgRootOrNull(project, file);
        return (HgRepository)repositoryManager.getRepositoryForRoot(root);
    }

    @Nullable
    public static String getRepositoryDefaultPath(@NotNull Project project, @NotNull VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPath();
    }

    @Nullable
    public static String getRepositoryDefaultPushPath(@NotNull Project project, @NotNull VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPushPath();
    }

    @Nullable
    public static String getRepositoryDefaultPushPath(@NotNull HgRepository repository) {
        return repository.getRepositoryConfig().getDefaultPushPath();
    }

    @Nullable
    public static String getConfig(@NotNull Project project, @NotNull VirtualFile root, @NotNull String section, @Nullable String configName) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getNamedConfig(section, configName);
    }

    @NotNull
    public static Collection<String> getRepositoryPaths(@NotNull Project project, @NotNull VirtualFile root) {
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getPaths();
    }

    public static boolean isExecutableValid(@Nullable String executable) {
        try {
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                return false;
            }
            HgCommandResult result = HgUtil.getVersionOutput(executable);
            return result.getExitValue() == 0 && !result.getRawOutput().isEmpty();
        }
        catch (Throwable e) {
            LOG.info("Error during hg executable validation: ", e);
            return false;
        }
    }

    @NotNull
    public static HgCommandResult getVersionOutput(@NotNull String executable) throws ShellCommandException, InterruptedException {
        String hgExecutable = executable.trim();
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(hgExecutable);
        cmdArgs.add("version");
        cmdArgs.add("-q");
        ShellCommand shellCommand = new ShellCommand(cmdArgs, null, CharsetToolkit.getDefaultSystemCharset());
        return shellCommand.execute(false, false);
    }

    public static List<String> getNamesWithoutHashes(Collection<HgNameWithHashInfo> namesWithHashes) {
        ArrayList<String> names = new ArrayList<String>();
        for (HgNameWithHashInfo hash : namesWithHashes) {
            if (names.contains(hash.getName())) continue;
            names.add(hash.getName());
        }
        return names;
    }

    public static List<String> getSortedNamesWithoutHashes(Collection<HgNameWithHashInfo> namesWithHashes) {
        List<String> names = HgUtil.getNamesWithoutHashes(namesWithHashes);
        Collections.sort(names);
        return names;
    }

    @NotNull
    public static Couple<String> parseUserNameAndEmail(@NotNull String authorString) {
        String userName;
        String email;
        int startEmailIndex = authorString.indexOf(60);
        int startDomainIndex = authorString.indexOf(64);
        int endEmailIndex = authorString.indexOf(62);
        if (0 < startEmailIndex && startEmailIndex < startDomainIndex && startDomainIndex < endEmailIndex) {
            email = authorString.substring(startEmailIndex + 1, endEmailIndex);
            userName = authorString.substring(0, startEmailIndex).trim();
        } else if (!authorString.contains(" ") && startDomainIndex > 0) {
            userName = "";
            email = startEmailIndex >= 0 && startDomainIndex > startEmailIndex && startDomainIndex < endEmailIndex ? authorString.substring(startEmailIndex + 1, endEmailIndex).trim() : authorString;
        } else {
            userName = authorString.trim();
            email = "";
        }
        return Couple.of((Object)userName, (Object)email);
    }

    @NotNull
    public static List<String> getTargetNames(@NotNull HgRepository repository) {
        return ContainerUtil.sorted((Collection)ContainerUtil.map(repository.getRepositoryConfig().getPaths(), s -> HgUtil.removePasswordIfNeeded(s)));
    }
}

