/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.jansi.Ansi;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.text.Style;
import org.gradle.internal.logging.text.StyledTextOutput;

public class DefaultColorMap
implements ColorMap {
    private static final String STATUSBAR = "statusbar";
    private static final String BOLD = "bold";
    private final Map<String, String> defaults = new HashMap<String, String>();
    private final Map<String, ColorMap.Color> colors = new HashMap<String, ColorMap.Color>();
    private final ColorMap.Color noDecoration = new ColorMap.Color(){

        public void on(Ansi ansi) {
        }

        public void off(Ansi ansi) {
        }
    };

    public DefaultColorMap() {
        this.addDefault(StyledTextOutput.Style.Info, "yellow");
        this.addDefault(StyledTextOutput.Style.Error, "default");
        this.addDefault(StyledTextOutput.Style.Header, "default");
        this.addDefault(StyledTextOutput.Style.Description, "yellow");
        this.addDefault(StyledTextOutput.Style.ProgressStatus, "yellow");
        this.addDefault(StyledTextOutput.Style.Identifier, "green");
        this.addDefault(StyledTextOutput.Style.UserInput, BOLD);
        this.addDefault(StyledTextOutput.Style.Success, "default");
        this.addDefault(StyledTextOutput.Style.Failure, "red");
        this.addDefault(STATUSBAR, BOLD);
    }

    private void addDefault(StyledTextOutput.Style style, String color) {
        this.addDefault(style.name().toLowerCase(), color);
    }

    private void addDefault(String style, String color) {
        this.defaults.put(style, color);
    }

    public ColorMap.Color getStatusBarColor() {
        return this.getColor(STATUSBAR);
    }

    public ColorMap.Color getColourFor(StyledTextOutput.Style style) {
        return this.getColor(style.name().toLowerCase());
    }

    public ColorMap.Color getColourFor(Style style) {
        ArrayList<ColorMap.Color> colors = new ArrayList<ColorMap.Color>();
        for (Style.Emphasis emphasis : style.getEmphasises()) {
            if (emphasis.equals((Object)Style.Emphasis.BOLD)) {
                colors.add(DefaultColorMap.newBoldColor());
                continue;
            }
            if (emphasis.equals((Object)Style.Emphasis.REVERSE)) {
                colors.add(DefaultColorMap.newReverseColor());
                continue;
            }
            if (!emphasis.equals((Object)Style.Emphasis.ITALIC)) continue;
            colors.add(DefaultColorMap.newItalicColor());
        }
        if (style.getColor().equals((Object)Style.Color.GREY)) {
            colors.add(new BrightForegroundColor(Ansi.Color.BLACK));
        } else {
            Ansi.Color ansiColor = Ansi.Color.valueOf((String)style.getColor().name().toUpperCase());
            if (ansiColor != Ansi.Color.DEFAULT) {
                colors.add(new ForegroundColor(ansiColor));
            }
        }
        return new CompositeColor(colors);
    }

    private ColorMap.Color getColor(String style) {
        ColorMap.Color color = this.colors.get(style);
        if (color == null) {
            color = this.createColor(style);
            this.colors.put(style, color);
        }
        return color;
    }

    private ColorMap.Color createColor(String style) {
        String colorSpec = System.getProperty("org.gradle.color." + style, this.defaults.get(style));
        if (colorSpec != null) {
            if (colorSpec.equalsIgnoreCase(BOLD)) {
                return DefaultColorMap.newBoldColor();
            }
            if (colorSpec.equalsIgnoreCase("reverse")) {
                return DefaultColorMap.newReverseColor();
            }
            if (colorSpec.equalsIgnoreCase("italic")) {
                return DefaultColorMap.newItalicColor();
            }
            Ansi.Color ansiColor = Ansi.Color.valueOf((String)colorSpec.toUpperCase());
            if (ansiColor != Ansi.Color.DEFAULT) {
                return new ForegroundColor(ansiColor);
            }
        }
        return this.noDecoration;
    }

    private static ColorMap.Color newBoldColor() {
        return new AttributeColor(Ansi.Attribute.INTENSITY_BOLD, Ansi.Attribute.RESET);
    }

    private static ColorMap.Color newReverseColor() {
        return new AttributeColor(Ansi.Attribute.NEGATIVE_ON, Ansi.Attribute.NEGATIVE_OFF);
    }

    private static ColorMap.Color newItalicColor() {
        return new AttributeColor(Ansi.Attribute.ITALIC, Ansi.Attribute.ITALIC_OFF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeColor
    implements ColorMap.Color {
        private final List<ColorMap.Color> colors;

        public CompositeColor(List<ColorMap.Color> colors) {
            this.colors = colors;
        }

        @Override
        public void on(Ansi ansi) {
            for (ColorMap.Color color : this.colors) {
                color.on(ansi);
            }
        }

        @Override
        public void off(Ansi ansi) {
            for (ColorMap.Color color : Lists.reverse(this.colors)) {
                color.off(ansi);
            }
        }
    }

    private static class AttributeColor
    implements ColorMap.Color {
        private final Ansi.Attribute on;
        private final Ansi.Attribute off;

        public AttributeColor(Ansi.Attribute on, Ansi.Attribute off) {
            this.on = on;
            this.off = off;
        }

        public void on(Ansi ansi) {
            ansi.a(this.on);
        }

        public void off(Ansi ansi) {
            ansi.a(this.off);
        }
    }

    private static class ForegroundColor
    implements ColorMap.Color {
        private final Ansi.Color ansiColor;

        public ForegroundColor(Ansi.Color ansiColor) {
            this.ansiColor = ansiColor;
        }

        public void on(Ansi ansi) {
            ansi.fg(this.ansiColor);
        }

        public void off(Ansi ansi) {
            ansi.fg(Ansi.Color.DEFAULT);
        }
    }

    private static class BrightForegroundColor
    implements ColorMap.Color {
        private final Ansi.Color ansiColor;

        public BrightForegroundColor(Ansi.Color ansiColor) {
            this.ansiColor = ansiColor;
        }

        public void on(Ansi ansi) {
            ansi.fgBright(this.ansiColor);
        }

        public void off(Ansi ansi) {
            ansi.fg(Ansi.Color.DEFAULT);
        }
    }
}

