/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.LightRefDescriptor;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;

public class CompilerIndices {
    public static final int VERSION = 2;
    public static final ID<LightRef, Void> BACK_USAGES = ID.create((String)"back.refs");
    public static final ID<LightRef, Collection<LightRef>> BACK_HIERARCHY = ID.create((String)"back.hierarchy");
    public static final ID<LightRef, Void> BACK_CLASS_DEF = ID.create((String)"back.class.def");

    public static List<IndexExtension<LightRef, ?, CompiledFileData>> getIndices() {
        return ContainerUtil.list((Object[])new IndexExtension[]{CompilerIndices.createBackwardClassDefinitionExtension(), CompilerIndices.createBackwardUsagesExtension(), CompilerIndices.createBackwardHierarchyExtension()});
    }

    private static IndexExtension<LightRef, Void, CompiledFileData> createBackwardUsagesExtension() {
        return new IndexExtension<LightRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 2;
            }

            @NotNull
            public ID<LightRef, Void> getName() {
                return BACK_USAGES;
            }

            @NotNull
            public DataIndexer<LightRef, Void, CompiledFileData> getIndexer() {
                return new DataIndexer<LightRef, Void, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Void> map(@NotNull CompiledFileData inputData) {
                        return inputData.getReferences();
                    }
                };
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                return LightRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                return VoidDataExternalizer.INSTANCE;
            }
        };
    }

    private static IndexExtension<LightRef, Collection<LightRef>, CompiledFileData> createBackwardHierarchyExtension() {
        return new IndexExtension<LightRef, Collection<LightRef>, CompiledFileData>(){

            public int getVersion() {
                return 2;
            }

            @NotNull
            public ID<LightRef, Collection<LightRef>> getName() {
                return BACK_HIERARCHY;
            }

            @NotNull
            public DataIndexer<LightRef, Collection<LightRef>, CompiledFileData> getIndexer() {
                return new DataIndexer<LightRef, Collection<LightRef>, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Collection<LightRef>> map(@NotNull CompiledFileData inputData) {
                        return inputData.getBackwardHierarchy();
                    }
                };
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                return LightRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Collection<LightRef>> getValueExternalizer() {
                return new DataExternalizer<Collection<LightRef>>(){

                    public void save(final @NotNull DataOutput out, Collection<LightRef> value) throws IOException {
                        DataInputOutputUtil.writeSeq((DataOutput)out, value, (ThrowableConsumer)new ThrowableConsumer<LightRef, IOException>(){

                            public void consume(LightRef lightRef) throws IOException {
                                LightRefDescriptor.INSTANCE.save(out, lightRef);
                            }
                        });
                    }

                    public Collection<LightRef> read(final @NotNull DataInput in) throws IOException {
                        return DataInputOutputUtil.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable<LightRef, IOException>(){

                            public LightRef compute() throws IOException {
                                return LightRefDescriptor.INSTANCE.read(in);
                            }
                        });
                    }
                };
            }
        };
    }

    private static IndexExtension<LightRef, Void, CompiledFileData> createBackwardClassDefinitionExtension() {
        return new IndexExtension<LightRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 2;
            }

            @NotNull
            public ID<LightRef, Void> getName() {
                return BACK_CLASS_DEF;
            }

            @NotNull
            public DataIndexer<LightRef, Void, CompiledFileData> getIndexer() {
                return new DataIndexer<LightRef, Void, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Void> map(@NotNull CompiledFileData inputData) {
                        return inputData.getDefinitions();
                    }
                };
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                return LightRefDescriptor.INSTANCE;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                return VoidDataExternalizer.INSTANCE;
            }
        };
    }
}

