/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;

class FieldRepr
extends ProtoMember {
    public void updateClassUsages(DependencyContext context, int owner, Set<UsageRepr.Usage> s) {
        this.myType.updateClassUsages(context, owner, s);
    }

    public FieldRepr(DependencyContext context, int access, int name, int descriptor, int signature, @NotNull Set<TypeRepr.ClassType> annotations, Object value) {
        super(access, signature, name, TypeRepr.getType(context, descriptor), annotations, value);
    }

    public FieldRepr(DependencyContext context, DataInput in) {
        super(context, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldRepr fieldRepr = (FieldRepr)o;
        return this.name == fieldRepr.name;
    }

    public int hashCode() {
        return 31 * this.name;
    }

    public static DataExternalizer<FieldRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<FieldRepr>(){

            public void save(@NotNull DataOutput out, FieldRepr value) throws IOException {
                value.save(out);
            }

            public FieldRepr read(@NotNull DataInput in) throws IOException {
                return new FieldRepr(context, in);
            }
        };
    }

    public UsageRepr.Usage createUsage(DependencyContext context, int owner) {
        return UsageRepr.createFieldUsage(context, this.name, owner, context.get(this.myType.getDescr(context)));
    }

    public UsageRepr.Usage createAssignUsage(DependencyContext context, int owner) {
        return UsageRepr.createFieldAssignUsage(context, this.name, owner, context.get(this.myType.getDescr(context)));
    }
}

