/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import org.jetbrains.jps.builders.java.dependencyView.CollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;

public class ObjectObjectTransientMultiMaplet<K, V extends Streamable>
extends ObjectObjectMultiMaplet<K, V> {
    private final THashMap<K, Collection<V>> myMap;
    private final CollectionFactory<V> myCollectionFactory;

    public ObjectObjectTransientMultiMaplet(TObjectHashingStrategy<K> hashingStrategy, CollectionFactory<V> collectionFactory) {
        this.myMap = new THashMap(hashingStrategy);
        this.myCollectionFactory = collectionFactory;
    }

    @Override
    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public Collection<V> get(K key) {
        return (Collection)this.myMap.get(key);
    }

    @Override
    public void putAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K key, Collection<V> value) {
                ObjectObjectTransientMultiMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void put(K key, Collection<V> value) {
        Collection x = (Collection)this.myMap.get(key);
        if (x == null) {
            this.myMap.put(key, value);
        } else {
            x.addAll(value);
        }
    }

    @Override
    public void replace(K key, Collection<V> value) {
        if (value == null || value.isEmpty()) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, value);
        }
    }

    @Override
    public void put(K key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection == null) {
            Collection<V> x = this.myCollectionFactory.create();
            x.add(value);
            this.myMap.put(key, x);
        } else {
            collection.add(value);
        }
    }

    @Override
    public void removeFrom(K key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.remove(value) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void removeAll(K key, Collection<V> values) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.removeAll(values) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void remove(K key) {
        this.myMap.remove(key);
    }

    @Override
    public void replaceAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K key, Collection<V> value) {
                ObjectObjectTransientMultiMaplet.this.replace(key, value);
                return true;
            }
        });
    }

    @Override
    public void forEachEntry(TObjectObjectProcedure<K, Collection<V>> procedure) {
        this.myMap.forEachEntry(procedure);
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
    }
}

