/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex.indexer.impl;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.classFilesIndex.AsmUtil;
import org.jetbrains.jps.classFilesIndex.TObjectIntHashMapExternalizer;
import org.jetbrains.jps.classFilesIndex.indexer.api.ClassFileIndexer;
import org.jetbrains.jps.classFilesIndex.indexer.impl.EnumeratedMethodIncompleteSignature;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodsUsageIndexer
extends ClassFileIndexer<Integer, TObjectIntHashMap<EnumeratedMethodIncompleteSignature>> {
    public static final String METHODS_USAGE_INDEX_CANONICAL_NAME = "MethodsUsageIndex";

    public MethodsUsageIndexer() {
        super(METHODS_USAGE_INDEX_CANONICAL_NAME);
    }

    @Override
    @NotNull
    public Map<Integer, TObjectIntHashMap<EnumeratedMethodIncompleteSignature>> map(ClassReader inputData, final Mappings mappings) {
        final HashMap<Integer, TObjectIntHashMap<EnumeratedMethodIncompleteSignature>> map = new HashMap<Integer, TObjectIntHashMap<EnumeratedMethodIncompleteSignature>>();
        final MethodVisitor methodVisitor = new MethodVisitor(393216){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                Type returnType = Type.getReturnType((String)desc);
                if (AsmUtil.isPrimitiveOrArrayOfPrimitives(returnType.getDescriptor()) || "<init>".equals(name)) {
                    return;
                }
                boolean isStatic = opcode == 184;
                String returnClassName = returnType.getInternalName();
                if (!owner.equals(returnClassName) || isStatic) {
                    EnumeratedMethodIncompleteSignature mi = new EnumeratedMethodIncompleteSignature(mappings.getName(owner), mappings.getName(name), isStatic);
                    int enumeratedClassName = mappings.getName(returnClassName);
                    TObjectIntHashMap occurrences = (TObjectIntHashMap)map.get(enumeratedClassName);
                    if (occurrences == null) {
                        occurrences = new TObjectIntHashMap();
                        map.put(enumeratedClassName, occurrences);
                    }
                    if (!occurrences.increment((Object)mi)) {
                        occurrences.put((Object)mi, 1);
                    }
                }
            }
        };
        inputData.accept(new ClassVisitor(393216){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return methodVisitor;
            }
        }, 6);
        return map;
    }

    @Override
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @Override
    public DataExternalizer<TObjectIntHashMap<EnumeratedMethodIncompleteSignature>> getDataExternalizer() {
        return new TObjectIntHashMapExternalizer<EnumeratedMethodIncompleteSignature>(EnumeratedMethodIncompleteSignature.createDataExternalizer());
    }
}

