/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.client;

import com.google.protobuf.MessageLite;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.client.ProtobufResponseHandler;
import org.jetbrains.jps.client.SimpleProtobufClient;
import org.jetbrains.jps.client.UUIDGetter;
import org.jetbrains.jps.javac.JavacRemoteProto;

@ChannelHandler.Sharable
final class ProtobufClientMessageHandler<T extends ProtobufResponseHandler>
extends SimpleChannelInboundHandler<MessageLite> {
    private final ConcurrentMap<UUID, RequestFuture<T>> myHandlers = new ConcurrentHashMap<UUID, RequestFuture<T>>(16, 0.75f, 1);
    @NotNull
    private final UUIDGetter myUuidGetter;
    private final SimpleProtobufClient myClient;
    private final Executor myAsyncExec;

    public ProtobufClientMessageHandler(@NotNull UUIDGetter uuidGetter, SimpleProtobufClient client, Executor asyncExec) {
        this.myUuidGetter = uuidGetter;
        this.myClient = client;
        this.myAsyncExec = asyncExec;
    }

    public final void channelRead0(ChannelHandlerContext context, MessageLite message) throws Exception {
        ProtobufResponseHandler handler;
        UUID messageUUID = this.myUuidGetter.getSessionUUID((JavacRemoteProto.Message)message);
        RequestFuture future = (RequestFuture)this.myHandlers.get(messageUUID);
        ProtobufResponseHandler protobufResponseHandler = handler = future != null ? (ProtobufResponseHandler)future.getMessageHandler() : null;
        if (handler == null) {
            this.terminateSession(messageUUID);
        } else {
            boolean terminateSession = false;
            try {
                terminateSession = handler.handleMessage(message);
            }
            catch (Exception ex) {
                terminateSession = true;
                throw ex;
            }
            finally {
                if (terminateSession) {
                    this.terminateSession(messageUUID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateSession(UUID sessionId) {
        RequestFuture<T> future = this.removeFuture(sessionId);
        if (future != null) {
            ProtobufResponseHandler handler = (ProtobufResponseHandler)future.getMessageHandler();
            try {
                if (handler != null) {
                    try {
                        handler.sessionTerminated();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                future.setDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        try {
            super.channelInactive(context);
        }
        finally {
            try {
                Set keys = this.myHandlers.keySet();
                for (UUID uuid : new ArrayList(keys)) {
                    this.terminateSession(uuid);
                }
            }
            finally {
                this.myAsyncExec.execute(() -> this.myClient.disconnect());
            }
        }
    }

    public void registerFuture(UUID messageId, RequestFuture<T> requestFuture) {
        this.myHandlers.put(messageId, requestFuture);
    }

    public RequestFuture<T> removeFuture(UUID messageId) {
        return (RequestFuture)this.myHandlers.remove(messageId);
    }
}

