/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.module.JpsModule;

public class CompileScopeImpl
extends CompileScope {
    private final Collection<? extends BuildTargetType<?>> myTypes;
    private final Collection<BuildTargetType<?>> myTypesToForceBuild;
    private final Collection<BuildTarget<?>> myTargets;
    private final Map<BuildTarget<?>, Set<File>> myFiles;

    public CompileScopeImpl(Collection<? extends BuildTargetType<?>> types, Collection<? extends BuildTargetType<?>> typesToForceBuild, Collection<BuildTarget<?>> targets, @NotNull Map<BuildTarget<?>, Set<File>> files) {
        this.myTypes = types;
        this.myTypesToForceBuild = new HashSet();
        boolean forceBuildAllModuleBasedTargets = false;
        for (BuildTargetType<?> type : typesToForceBuild) {
            this.myTypesToForceBuild.add(type);
            forceBuildAllModuleBasedTargets |= type instanceof JavaModuleBuildTargetType;
        }
        if (forceBuildAllModuleBasedTargets) {
            for (BuildTargetType<?> targetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
                if (!(targetType instanceof ModuleBasedBuildTargetType)) continue;
                this.myTypesToForceBuild.add(targetType);
            }
        }
        this.myTargets = targets;
        this.myFiles = files;
    }

    @Override
    public boolean isAffected(@NotNull BuildTarget<?> target) {
        return this.isWholeTargetAffected(target) || this.myFiles.containsKey(target);
    }

    @Override
    public boolean isWholeTargetAffected(@NotNull BuildTarget<?> target) {
        return (this.myTypes.contains(target.getTargetType()) || this.myTargets.contains(target) || this.isAffectedByAssociatedModule(target)) && !this.myFiles.containsKey(target);
    }

    @Override
    public boolean isBuildForced(@NotNull BuildTarget<?> target) {
        return this.myTypesToForceBuild.contains(target.getTargetType()) && this.myFiles.isEmpty() && this.isWholeTargetAffected(target);
    }

    @Override
    public boolean isBuildForcedForAllTargets(@NotNull BuildTargetType<?> targetType) {
        return this.myTypesToForceBuild.contains(targetType) && this.myTypes.contains(targetType) && this.myFiles.isEmpty();
    }

    @Override
    public boolean isBuildIncrementally(@NotNull BuildTargetType<?> targetType) {
        return !this.myTypesToForceBuild.contains(targetType);
    }

    @Override
    public boolean isAffected(BuildTarget<?> target, @NotNull File file) {
        if (this.myFiles.isEmpty()) {
            return this.isAffected(target);
        }
        Set<File> files = this.myFiles.get(target);
        return files != null && files.contains(file);
    }

    private boolean isAffectedByAssociatedModule(BuildTarget<?> target) {
        if (target instanceof ModuleBasedTarget) {
            JpsModule module = ((ModuleBasedTarget)target).getModule();
            JavaModuleBuildTargetType targetType = JavaModuleBuildTargetType.getInstance(((ModuleBasedTarget)target).isTests());
            if (this.myTypes.contains(targetType) || this.myTargets.contains(new ModuleBuildTarget(module, targetType))) {
                return true;
            }
        }
        return false;
    }
}

