/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;

public class ExternalProcessUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.ExternalProcessUtil");
    private static final char QUOTE = '\uefef';

    public static String prepareCommand(String parameter) {
        if (SystemInfo.isWindows) {
            if (parameter.contains("\"")) {
                parameter = StringUtil.replace((String)parameter, (String)"\"", (String)"\\\"");
            } else if (parameter.length() == 0) {
                parameter = "\"\"";
            }
        }
        if (parameter.length() >= 2 && parameter.charAt(0) == '\uefef' && parameter.charAt(parameter.length() - 1) == '\uefef') {
            parameter = '\"' + parameter.substring(1, parameter.length() - 1) + '\"';
        }
        return parameter;
    }

    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams) {
        return ExternalProcessUtil.buildJavaCommandLine(javaExecutable, mainClass, bootClasspath, classpath, vmParams, programParams, true);
    }

    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams, boolean useCommandLineWrapper) {
        return ExternalProcessUtil.buildJavaCommandLine(javaExecutable, mainClass, bootClasspath, classpath, vmParams, programParams, useCommandLineWrapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams, boolean useCommandLineWrapper, boolean useClasspathJar) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(javaExecutable);
        for (String param : vmParams) {
            cmdLine.add(param);
        }
        if (!bootClasspath.isEmpty()) {
            cmdLine.add("-bootclasspath");
            cmdLine.add(StringUtil.join(bootClasspath, (String)File.pathSeparator));
        }
        if (!classpath.isEmpty()) {
            List<String> commandLineWrapperArgs;
            block16: {
                commandLineWrapperArgs = null;
                if (useCommandLineWrapper) {
                    Class wrapperClass = ExternalProcessUtil.getCommandLineWrapperClass();
                    if (wrapperClass != null) {
                        try {
                            Object classpathFile;
                            if (useClasspathJar) {
                                classpathFile = CommandLineWrapperUtil.createClasspathJarFile((Manifest)new Manifest(), classpath).getAbsolutePath();
                                commandLineWrapperArgs = Arrays.asList("-classpath", classpathFile);
                                break block16;
                            }
                            classpathFile = FileUtil.createTempFile((String)"classpath", null);
                            try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter((File)classpathFile)));){
                                for (String path : classpath) {
                                    writer.println(path);
                                }
                            }
                            commandLineWrapperArgs = Arrays.asList("-classpath", ClasspathBootstrap.getResourcePath(wrapperClass), wrapperClass.getName(), ((File)classpathFile).getAbsolutePath());
                        }
                        catch (IOException ex) {
                            LOG.info("Error starting " + mainClass + "; Classpath wrapper will not be used: ", (Throwable)ex);
                        }
                    } else {
                        LOG.info("CommandLineWrapper class not found, classpath wrapper will not be used");
                    }
                }
            }
            if (commandLineWrapperArgs != null) {
                cmdLine.addAll(commandLineWrapperArgs);
            } else {
                cmdLine.add("-classpath");
                cmdLine.add(StringUtil.join(classpath, (String)File.pathSeparator));
            }
        }
        cmdLine.add(mainClass);
        for (String param : programParams) {
            cmdLine.add(param);
        }
        return cmdLine;
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        return CommandLineWrapperClassHolder.ourWrapperClass;
    }

    private static class CommandLineWrapperClassHolder {
        static final Class ourWrapperClass;

        private CommandLineWrapperClassHolder() {
        }

        static {
            Class<?> aClass = null;
            try {
                aClass = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ourWrapperClass = aClass;
        }
    }
}

