/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;

public class Utils {
    public static final Key<Map<BuildTarget<?>, Collection<String>>> REMOVED_SOURCES_KEY = Key.create((String)"_removed_sources_");
    public static final Key<Boolean> PROCEED_ON_ERROR_KEY = Key.create((String)"_proceed_on_error_");
    public static final Key<Boolean> ERRORS_DETECTED_KEY = Key.create((String)"_errors_detected_");
    private static volatile File ourSystemRoot = new File(System.getProperty("user.home"), ".idea-build");
    public static final boolean IS_TEST_MODE = Boolean.parseBoolean(System.getProperty("test.mode", "false"));
    public static final boolean IS_PROFILING_MODE = Boolean.parseBoolean(System.getProperty("profiling.mode", "false"));

    private Utils() {
    }

    public static File getSystemRoot() {
        return ourSystemRoot;
    }

    public static void setSystemRoot(File systemRoot) {
        ourSystemRoot = systemRoot;
    }

    @Nullable
    public static File getDataStorageRoot(String projectPath) {
        return Utils.getDataStorageRoot(ourSystemRoot, projectPath);
    }

    public static File getDataStorageRoot(File systemRoot, String projectPath) {
        int locationHash;
        String name;
        if ((projectPath = FileUtil.toCanonicalPath((String)projectPath)) == null) {
            return null;
        }
        File rootFile = new File(projectPath);
        if (!rootFile.isDirectory() && projectPath.endsWith(".ipr")) {
            name = StringUtil.trimEnd((String)rootFile.getName(), (String)".ipr");
            locationHash = projectPath.hashCode();
        } else {
            File directoryBased = null;
            if (".idea".equals(rootFile.getName())) {
                directoryBased = rootFile;
            } else {
                File child = new File(rootFile, ".idea");
                if (child.exists()) {
                    directoryBased = child;
                }
            }
            if (directoryBased == null) {
                return null;
            }
            name = PathUtilRt.suggestFileName((String)JpsProjectLoader.getDirectoryBaseProjectName((File)directoryBased));
            locationHash = directoryBased.getPath().hashCode();
        }
        return new File(systemRoot, name.toLowerCase(Locale.US) + "_" + Integer.toHexString(locationHash));
    }

    public static boolean errorsDetected(CompileContext context) {
        return (Boolean)ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE);
    }

    public static String formatDuration(long duration) {
        return StringUtil.formatDuration((long)duration);
    }
}

