/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.artifacts.impl.ArtifactOutToSourceStorageProvider;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.ArtifactSorter;
import org.jetbrains.jps.incremental.artifacts.impl.JarsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.service.JpsServiceManager;

public class IncArtifactBuilder
extends TargetBuilder<ArtifactRootDescriptor, ArtifactBuildTarget> {
    private static final Logger LOG = Logger.getInstance(IncArtifactBuilder.class);
    public static final String BUILDER_NAME = "Artifacts builder";

    public IncArtifactBuilder() {
        super(Collections.singletonList(ArtifactBuildTargetType.INSTANCE));
    }

    @Override
    public void build(@NotNull ArtifactBuildTarget target, @NotNull DirtyFilesHolder<ArtifactRootDescriptor, ArtifactBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException {
        JpsArtifact artifact = target.getArtifact();
        String outputFilePath = artifact.getOutputFilePath();
        if (StringUtil.isEmpty((String)outputFilePath)) {
            context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot build '" + artifact.getName() + "' artifact: output path is not specified"));
            return;
        }
        ProjectDescriptor pd = context.getProjectDescriptor();
        ArtifactSorter sorter = new ArtifactSorter(pd.getModel());
        Map<JpsArtifact, JpsArtifact> selfIncludingNameMap = sorter.getArtifactToSelfIncludingNameMap();
        JpsArtifact selfIncluding = selfIncludingNameMap.get(artifact);
        if (selfIncluding != null) {
            String name = selfIncluding.equals(artifact) ? "it" : "'" + selfIncluding.getName() + "' artifact";
            context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot build '" + artifact.getName() + "' artifact: " + name + " includes itself in the output layout"));
            return;
        }
        try {
            final Collection<String> deletedFiles = holder.getRemovedFiles(target);
            String messageText = "Building artifact '" + artifact.getName() + "'...";
            context.processMessage(new ProgressMessage(messageText));
            LOG.debug(messageText);
            IncArtifactBuilder.runArtifactTasks(context, target.getArtifact(), ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING);
            final SourceToOutputMapping srcOutMapping = pd.dataManager.getSourceToOutputMap(target);
            ArtifactOutputToSourceMapping outSrcMapping = pd.dataManager.getStorage(target, ArtifactOutToSourceStorageProvider.INSTANCE);
            final TIntObjectHashMap filesToProcess = new TIntObjectHashMap();
            MultiMap filesToDelete = new MultiMap();
            THashSet deletedOutputPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            for (String string : deletedFiles) {
                Collection<String> outputPaths = srcOutMapping.getOutputs(string);
                if (outputPaths == null) continue;
                for (String outputPath : outputPaths) {
                    if (!deletedOutputPaths.add(outputPath)) continue;
                    IncArtifactBuilder.collectSourcesCorrespondingToOutput(outputPath, string, deletedFiles, outSrcMapping, (TIntObjectHashMap<Set<String>>)filesToProcess, (MultiMap<String, String>)filesToDelete);
                }
            }
            THashSet changedOutputPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            holder.processDirtyFiles(new FileProcessor<ArtifactRootDescriptor, ArtifactBuildTarget>((Set)changedOutputPaths, outSrcMapping, filesToDelete){
                final /* synthetic */ Set val$changedOutputPaths;
                final /* synthetic */ ArtifactOutputToSourceMapping val$outSrcMapping;
                final /* synthetic */ MultiMap val$filesToDelete;
                {
                    this.val$changedOutputPaths = set;
                    this.val$outSrcMapping = artifactOutputToSourceMapping;
                    this.val$filesToDelete = multiMap;
                }

                @Override
                public boolean apply(ArtifactBuildTarget target, File file, ArtifactRootDescriptor root) throws IOException {
                    int rootIndex = root.getRootIndex();
                    String sourcePath = FileUtil.toSystemIndependentName((String)file.getPath());
                    IncArtifactBuilder.addFileToProcess((TIntObjectHashMap<Set<String>>)filesToProcess, rootIndex, sourcePath, deletedFiles);
                    Collection<String> outputPaths = srcOutMapping.getOutputs(sourcePath);
                    if (outputPaths != null) {
                        for (String outputPath : outputPaths) {
                            if (!this.val$changedOutputPaths.add(outputPath)) continue;
                            IncArtifactBuilder.collectSourcesCorrespondingToOutput(outputPath, sourcePath, deletedFiles, this.val$outSrcMapping, (TIntObjectHashMap<Set<String>>)filesToProcess, (MultiMap<String, String>)this.val$filesToDelete);
                        }
                    }
                    return true;
                }
            });
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, holder);
            for (Object outputPath : changedOutputPaths) {
                outSrcMapping.remove((String)outputPath);
            }
            if (filesToDelete.isEmpty() && filesToProcess.isEmpty()) {
                return;
            }
            IncArtifactBuilder.deleteOutdatedFiles((MultiMap<String, String>)filesToDelete, context, srcOutMapping, outSrcMapping);
            context.checkCanceled();
            context.processMessage(new ProgressMessage("Building artifact '" + artifact.getName() + "': copying files..."));
            THashSet tHashSet = new THashSet();
            for (ArtifactRootDescriptor descriptor : pd.getBuildRootIndex().getTargetRoots(target, context)) {
                context.checkCanceled();
                Set sourcePaths = (Set)filesToProcess.get(descriptor.getRootIndex());
                if (sourcePaths == null) continue;
                for (String sourcePath : sourcePaths) {
                    if (!descriptor.getFilter().shouldBeCopied(sourcePath, pd)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("File " + sourcePath + " will be skipped because it isn't accepted by filter");
                        continue;
                    }
                    DestinationInfo destination = descriptor.getDestinationInfo();
                    if (destination instanceof ExplodedDestinationInfo) {
                        descriptor.copyFromRoot(sourcePath, descriptor.getRootIndex(), destination.getOutputPath(), context, outputConsumer, outSrcMapping);
                        continue;
                    }
                    List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = outSrcMapping.getState(destination.getOutputFilePath());
                    if (sources != null && (sources.size() <= 0 || sources.get(0).getRootIndex() != descriptor.getRootIndex())) continue;
                    outSrcMapping.update(destination.getOutputFilePath(), Collections.emptyList());
                    tHashSet.add(((JarDestinationInfo)destination).getJarInfo());
                }
            }
            context.checkCanceled();
            JarsBuilder builder = new JarsBuilder((Set<JarInfo>)tHashSet, context, outputConsumer, outSrcMapping);
            builder.buildJars();
            IncArtifactBuilder.runArtifactTasks(context, artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD);
            IncArtifactBuilder.runArtifactTasks(context, artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private static void collectSourcesCorrespondingToOutput(String outputPath, String sourcePath, Collection<String> deletedFiles, ArtifactOutputToSourceMapping outSrcMapping, TIntObjectHashMap<Set<String>> filesToProcess, MultiMap<String, String> filesToDelete) throws IOException {
        filesToDelete.putValue((Object)outputPath, (Object)sourcePath);
        List<ArtifactOutputToSourceMapping.SourcePathAndRootIndex> sources = outSrcMapping.getState(outputPath);
        if (sources != null) {
            for (ArtifactOutputToSourceMapping.SourcePathAndRootIndex source : sources) {
                IncArtifactBuilder.addFileToProcess(filesToProcess, source.getRootIndex(), source.getPath(), deletedFiles);
            }
        }
    }

    private static void runArtifactTasks(CompileContext context, JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase phase) throws ProjectBuildException {
        for (ArtifactBuildTaskProvider provider : JpsServiceManager.getInstance().getExtensions(ArtifactBuildTaskProvider.class)) {
            List<? extends BuildTask> tasks = provider.createArtifactBuildTasks(artifact, phase);
            if (tasks.isEmpty()) continue;
            context.processMessage(new ProgressMessage("Running " + phase.getPresentableName() + " tasks for '" + artifact.getName() + "' artifact..."));
            for (BuildTask buildTask : tasks) {
                buildTask.build(context);
            }
        }
    }

    private static void addFileToProcess(TIntObjectHashMap<Set<String>> filesToProcess, int rootIndex, String path, Collection<String> deletedFiles) {
        if (deletedFiles.contains(path)) {
            return;
        }
        Set paths = (Set)filesToProcess.get(rootIndex);
        if (paths == null) {
            paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            filesToProcess.put(rootIndex, (Object)paths);
        }
        paths.add(path);
    }

    private static void deleteOutdatedFiles(MultiMap<String, String> filesToDelete, CompileContext context, SourceToOutputMapping srcOutMapping, ArtifactOutputToSourceMapping outSrcMapping) throws IOException {
        ProjectBuilderLogger logger;
        if (filesToDelete.isEmpty()) {
            return;
        }
        context.processMessage(new ProgressMessage("Deleting outdated files..."));
        int notDeletedFilesCount = 0;
        THashSet notDeletedPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        THashSet deletedPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (String filePath : filesToDelete.keySet()) {
            if (notDeletedPaths.contains((Object)filePath)) continue;
            boolean deleted = deletedPaths.contains((Object)filePath);
            if (!deleted) {
                deleted = FileUtil.delete((File)new File(filePath));
            }
            if (deleted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Outdated output file deleted: " + filePath);
                }
                outSrcMapping.remove(filePath);
                deletedPaths.add((Object)filePath);
                for (String sourcePath : filesToDelete.get((Object)filePath)) {
                    srcOutMapping.removeOutput(sourcePath, filePath);
                }
                continue;
            }
            notDeletedPaths.add((Object)filePath);
            if (notDeletedFilesCount++ > 50) {
                context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.WARNING, "Deletion of outdated files stopped because too many files cannot be deleted"));
                break;
            }
            context.processMessage(new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.WARNING, "Cannot delete file '" + filePath + "'"));
        }
        if ((logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
            logger.logDeletedFiles((Collection<String>)deletedPaths);
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return BUILDER_NAME;
    }
}

