/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class ArtifactSorter {
    private final JpsModel myModel;
    private Map<JpsArtifact, JpsArtifact> myArtifactToSelfIncludingName;
    private List<JpsArtifact> mySortedArtifacts;

    public ArtifactSorter(JpsModel model) {
        this.myModel = model;
    }

    public Map<JpsArtifact, JpsArtifact> getArtifactToSelfIncludingNameMap() {
        if (this.myArtifactToSelfIncludingName == null) {
            this.myArtifactToSelfIncludingName = this.computeArtifactToSelfIncludingNameMap();
        }
        return this.myArtifactToSelfIncludingName;
    }

    public List<JpsArtifact> getArtifactsSortedByInclusion() {
        if (this.mySortedArtifacts == null) {
            this.mySortedArtifacts = this.doGetSortedArtifacts();
        }
        return this.mySortedArtifacts;
    }

    private List<JpsArtifact> doGetSortedArtifacts() {
        Graph<JpsArtifact> graph = this.createArtifactsGraph();
        DFSTBuilder builder = new DFSTBuilder(graph);
        ArrayList<JpsArtifact> names = new ArrayList<JpsArtifact>();
        names.addAll(graph.getNodes());
        names.sort(builder.comparator());
        return names;
    }

    private Map<JpsArtifact, JpsArtifact> computeArtifactToSelfIncludingNameMap() {
        HashMap<JpsArtifact, JpsArtifact> result = new HashMap<JpsArtifact, JpsArtifact>();
        Graph<JpsArtifact> graph = this.createArtifactsGraph();
        block0: for (Object artifact : graph.getNodes()) {
            Iterator in = graph.getIn(artifact);
            while (in.hasNext()) {
                JpsArtifact next = (JpsArtifact)in.next();
                if (!next.equals(artifact)) continue;
                result.put((JpsArtifact)artifact, (JpsArtifact)artifact);
                continue block0;
            }
        }
        DFSTBuilder builder = new DFSTBuilder(graph);
        if (builder.isAcyclic() && result.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Collection component : builder.getComponents()) {
            if (component.size() <= 1) continue;
            for (JpsArtifact artifact : component) {
                result.put(artifact, artifact);
            }
        }
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            JpsArtifact artifact = (JpsArtifact)builder.getNodeByTNumber(i);
            if (result.containsKey(artifact)) continue;
            Iterator in = graph.getIn((Object)artifact);
            while (in.hasNext()) {
                JpsArtifact next = (JpsArtifact)result.get(in.next());
                if (next == null) continue;
                result.put(artifact, next);
            }
        }
        return result;
    }

    @NotNull
    public static Set<JpsArtifact> addIncludedArtifacts(@NotNull Collection<JpsArtifact> artifacts) {
        HashSet<JpsArtifact> result = new HashSet<JpsArtifact>();
        for (JpsArtifact artifact : artifacts) {
            ArtifactSorter.collectIncludedArtifacts(artifact, new HashSet<JpsArtifact>(), result, true);
        }
        return result;
    }

    private static void collectIncludedArtifacts(JpsArtifact artifact, Set<JpsArtifact> processed, Set<JpsArtifact> result, boolean withOutputPathOnly) {
        if (!processed.add(artifact)) {
            return;
        }
        if (!withOutputPathOnly || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            result.add(artifact);
        }
        ArtifactSorter.processIncludedArtifacts(artifact, (Consumer<JpsArtifact>)((Consumer)included -> ArtifactSorter.collectIncludedArtifacts(included, processed, result, withOutputPathOnly)));
    }

    private Graph<JpsArtifact> createArtifactsGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ArtifactsGraph(this.myModel)));
    }

    private static void processIncludedArtifacts(JpsArtifact artifact, Consumer<JpsArtifact> consumer) {
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)artifact.getRootElement(), (Processor<JpsPackagingElement>)((Processor)element -> {
            if (element instanceof JpsArtifactOutputPackagingElement) {
                JpsArtifact included = (JpsArtifact)((JpsArtifactOutputPackagingElement)element).getArtifactReference().resolve();
                if (included != null) {
                    consumer.consume((Object)included);
                }
                return false;
            }
            return true;
        }));
    }

    private static class ArtifactsGraph
    implements InboundSemiGraph<JpsArtifact> {
        private final Set<JpsArtifact> myArtifactNodes;

        public ArtifactsGraph(JpsModel model) {
            this.myArtifactNodes = new LinkedHashSet<JpsArtifact>(JpsBuilderArtifactService.getInstance().getArtifacts(model, true));
        }

        public Collection<JpsArtifact> getNodes() {
            return this.myArtifactNodes;
        }

        public Iterator<JpsArtifact> getIn(JpsArtifact artifact) {
            LinkedHashSet included = new LinkedHashSet();
            ArtifactSorter.processIncludedArtifacts(artifact, (Consumer<JpsArtifact>)includedArtifact -> {
                if (this.myArtifactNodes.contains(includedArtifact)) {
                    included.add(includedArtifact);
                }
            });
            return included.iterator();
        }
    }
}

